/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.cfg;

import java.io.Serializable;
import java.util.Objects;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.ser.Serializers;
import tools.jackson.databind.ser.ValueSerializerModifier;
import tools.jackson.databind.ser.impl.FailingSerializer;
import tools.jackson.databind.util.ArrayBuilders;
import tools.jackson.databind.util.ArrayIterator;

public final class SerializerFactoryConfig
implements Serializable {
    private static final long serialVersionUID = 3L;
    public static final ValueSerializer<Object> DEFAULT_NULL_KEY_SERIALIZER = new FailingSerializer("Null key for a Map not allowed in JSON (use a converting NullKeySerializer?)");
    protected static final Serializers[] NO_SERIALIZERS = new Serializers[0];
    protected static final ValueSerializerModifier[] NO_MODIFIERS = new ValueSerializerModifier[0];
    protected final Serializers[] _additionalSerializers;
    protected final Serializers[] _additionalKeySerializers;
    protected final ValueSerializerModifier[] _modifiers;
    protected final ValueSerializer<Object> _nullValueSerializer;
    protected final ValueSerializer<Object> _nullKeySerializer;

    public SerializerFactoryConfig() {
        this(null, null, null, DEFAULT_NULL_KEY_SERIALIZER, null);
    }

    protected SerializerFactoryConfig(Serializers[] allAdditionalSerializers, Serializers[] allAdditionalKeySerializers, ValueSerializerModifier[] modifiers, ValueSerializer<Object> nullKeySer, ValueSerializer<Object> nullValueSer) {
        this._additionalSerializers = allAdditionalSerializers == null ? NO_SERIALIZERS : allAdditionalSerializers;
        this._additionalKeySerializers = allAdditionalKeySerializers == null ? NO_SERIALIZERS : allAdditionalKeySerializers;
        this._modifiers = modifiers == null ? NO_MODIFIERS : modifiers;
        this._nullKeySerializer = nullKeySer;
        this._nullValueSerializer = nullValueSer;
    }

    public SerializerFactoryConfig withAdditionalSerializers(Serializers additional) {
        Objects.requireNonNull(additional, "Cannot pass null Serializers");
        Serializers[] all = ArrayBuilders.insertInListNoDup(this._additionalSerializers, additional);
        return new SerializerFactoryConfig(all, this._additionalKeySerializers, this._modifiers, this._nullKeySerializer, this._nullValueSerializer);
    }

    public SerializerFactoryConfig withAdditionalKeySerializers(Serializers additional) {
        Objects.requireNonNull(additional, "Cannot pass null Serializers");
        Serializers[] all = ArrayBuilders.insertInListNoDup(this._additionalKeySerializers, additional);
        return new SerializerFactoryConfig(this._additionalSerializers, all, this._modifiers, this._nullKeySerializer, this._nullValueSerializer);
    }

    public SerializerFactoryConfig withSerializerModifier(ValueSerializerModifier modifier) {
        Objects.requireNonNull(modifier, "Cannot pass null ValueSerializerModifier");
        ValueSerializerModifier[] modifiers = ArrayBuilders.insertInListNoDup(this._modifiers, modifier);
        return new SerializerFactoryConfig(this._additionalSerializers, this._additionalKeySerializers, modifiers, this._nullKeySerializer, this._nullValueSerializer);
    }

    public SerializerFactoryConfig withNullValueSerializer(ValueSerializer<?> nvs) {
        Objects.requireNonNull(nvs, "Cannot pass null ValueSerializer");
        return new SerializerFactoryConfig(this._additionalSerializers, this._additionalKeySerializers, this._modifiers, this._nullKeySerializer, nvs);
    }

    public SerializerFactoryConfig withNullKeySerializer(ValueSerializer<?> nks) {
        Objects.requireNonNull(nks, "Cannot pass null ValueSerializer");
        return new SerializerFactoryConfig(this._additionalSerializers, this._additionalKeySerializers, this._modifiers, nks, this._nullValueSerializer);
    }

    public boolean hasSerializers() {
        return this._additionalSerializers.length > 0;
    }

    public boolean hasKeySerializers() {
        return this._additionalKeySerializers.length > 0;
    }

    public boolean hasSerializerModifiers() {
        return this._modifiers.length > 0;
    }

    public Iterable<Serializers> serializers() {
        return new ArrayIterator<Serializers>(this._additionalSerializers);
    }

    public Iterable<Serializers> keySerializers() {
        return new ArrayIterator<Serializers>(this._additionalKeySerializers);
    }

    public Iterable<ValueSerializerModifier> serializerModifiers() {
        return new ArrayIterator<ValueSerializerModifier>(this._modifiers);
    }

    public ValueSerializer<Object> getNullKeySerializer() {
        return this._nullKeySerializer;
    }

    public ValueSerializer<Object> getNullValueSerializer() {
        return this._nullValueSerializer;
    }
}

