/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird.props.internal;

public final class TransactionNameMapping {
    public static final String TRANSACTION_NONE = "TRANSACTION_NONE";
    public static final String TRANSACTION_READ_UNCOMMITTED = "TRANSACTION_READ_UNCOMMITTED";
    public static final String TRANSACTION_READ_COMMITTED = "TRANSACTION_READ_COMMITTED";
    public static final String TRANSACTION_REPEATABLE_READ = "TRANSACTION_REPEATABLE_READ";
    public static final String TRANSACTION_SERIALIZABLE = "TRANSACTION_SERIALIZABLE";

    private TransactionNameMapping() {
    }

    public static int toIsolationLevel(String isolationLevelName) {
        switch (isolationLevelName) {
            case "TRANSACTION_NONE": 
            case "0": {
                return 0;
            }
            case "TRANSACTION_READ_UNCOMMITTED": 
            case "1": {
                return 1;
            }
            case "TRANSACTION_READ_COMMITTED": 
            case "2": {
                return 2;
            }
            case "TRANSACTION_REPEATABLE_READ": 
            case "4": {
                return 4;
            }
            case "TRANSACTION_SERIALIZABLE": 
            case "8": {
                return 8;
            }
        }
        throw new IllegalArgumentException("Unknown transaction isolation level name: " + isolationLevelName);
    }

    public static String toIsolationLevelName(int isolationLevel) {
        return TransactionNameMapping.toIsolationLevelName(isolationLevel, false);
    }

    public static String toIsolationLevelName(int isolationLevel, boolean lenient) {
        switch (isolationLevel) {
            case 0: {
                return TRANSACTION_NONE;
            }
            case 1: {
                return TRANSACTION_READ_UNCOMMITTED;
            }
            case 2: {
                return TRANSACTION_READ_COMMITTED;
            }
            case 4: {
                return TRANSACTION_REPEATABLE_READ;
            }
            case 8: {
                return TRANSACTION_SERIALIZABLE;
            }
        }
        if (lenient) {
            return String.valueOf(isolationLevel);
        }
        throw new IllegalArgumentException("Unknown transaction isolation level: " + isolationLevel);
    }
}

