﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/config/ConfigServiceRequest.h>
#include <aws/config/ConfigService_EXPORTS.h>
#include <aws/config/model/ConfigRule.h>
#include <aws/config/model/Tag.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
namespace ConfigService {
namespace Model {

/**
 */
class PutConfigRuleRequest : public ConfigServiceRequest {
 public:
  AWS_CONFIGSERVICE_API PutConfigRuleRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "PutConfigRule"; }

  AWS_CONFIGSERVICE_API Aws::String SerializePayload() const override;

  AWS_CONFIGSERVICE_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The rule that you want to add to your account.</p>
   */
  inline const ConfigRule& GetConfigRule() const { return m_configRule; }
  inline bool ConfigRuleHasBeenSet() const { return m_configRuleHasBeenSet; }
  template <typename ConfigRuleT = ConfigRule>
  void SetConfigRule(ConfigRuleT&& value) {
    m_configRuleHasBeenSet = true;
    m_configRule = std::forward<ConfigRuleT>(value);
  }
  template <typename ConfigRuleT = ConfigRule>
  PutConfigRuleRequest& WithConfigRule(ConfigRuleT&& value) {
    SetConfigRule(std::forward<ConfigRuleT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An array of tag object.</p>
   */
  inline const Aws::Vector<Tag>& GetTags() const { return m_tags; }
  inline bool TagsHasBeenSet() const { return m_tagsHasBeenSet; }
  template <typename TagsT = Aws::Vector<Tag>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Vector<Tag>>
  PutConfigRuleRequest& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsT = Tag>
  PutConfigRuleRequest& AddTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace_back(std::forward<TagsT>(value));
    return *this;
  }
  ///@}
 private:
  ConfigRule m_configRule;

  Aws::Vector<Tag> m_tags;
  bool m_configRuleHasBeenSet = false;
  bool m_tagsHasBeenSet = false;
};

}  // namespace Model
}  // namespace ConfigService
}  // namespace Aws
