﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/freetier/FreeTier_EXPORTS.h>
#include <aws/freetier/model/ActivitySummary.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace FreeTier {
namespace Model {
class ListAccountActivitiesResult {
 public:
  AWS_FREETIER_API ListAccountActivitiesResult() = default;
  AWS_FREETIER_API ListAccountActivitiesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_FREETIER_API ListAccountActivitiesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p> A brief information about the activities. </p>
   */
  inline const Aws::Vector<ActivitySummary>& GetActivities() const { return m_activities; }
  template <typename ActivitiesT = Aws::Vector<ActivitySummary>>
  void SetActivities(ActivitiesT&& value) {
    m_activitiesHasBeenSet = true;
    m_activities = std::forward<ActivitiesT>(value);
  }
  template <typename ActivitiesT = Aws::Vector<ActivitySummary>>
  ListAccountActivitiesResult& WithActivities(ActivitiesT&& value) {
    SetActivities(std::forward<ActivitiesT>(value));
    return *this;
  }
  template <typename ActivitiesT = ActivitySummary>
  ListAccountActivitiesResult& AddActivities(ActivitiesT&& value) {
    m_activitiesHasBeenSet = true;
    m_activities.emplace_back(std::forward<ActivitiesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The token to include in another request to get the next page of items. This
   * value is <code>null</code> when there are no more items to return. </p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListAccountActivitiesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListAccountActivitiesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<ActivitySummary> m_activities;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_activitiesHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace FreeTier
}  // namespace Aws
