﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/guardduty/GuardDuty_EXPORTS.h>

namespace Aws {
namespace GuardDuty {
namespace Model {
enum class ListMalwareScansCriterionKey {
  NOT_SET,
  RESOURCE_ARN,
  SCAN_ID,
  ACCOUNT_ID,
  GUARDDUTY_FINDING_ID,
  RESOURCE_TYPE,
  SCAN_START_TIME,
  SCAN_STATUS,
  SCAN_TYPE
};

namespace ListMalwareScansCriterionKeyMapper {
AWS_GUARDDUTY_API ListMalwareScansCriterionKey GetListMalwareScansCriterionKeyForName(const Aws::String& name);

AWS_GUARDDUTY_API Aws::String GetNameForListMalwareScansCriterionKey(ListMalwareScansCriterionKey value);
}  // namespace ListMalwareScansCriterionKeyMapper
}  // namespace Model
}  // namespace GuardDuty
}  // namespace Aws
