/*
 * Decompiled with CFR 0.152.
 */
package org.a11y.brlapi.clients;

import org.a11y.brlapi.Connection;
import org.a11y.brlapi.CursorPositionUsage;
import org.a11y.brlapi.OperandUsage;
import org.a11y.brlapi.Parse;
import org.a11y.brlapi.ProgramException;
import org.a11y.brlapi.clients.PauseClient;

public class WriteTextClient
extends PauseClient {
    private int cursorPosition = 0;
    private final OperandUsage cursorPositionUsage = new CursorPositionUsage(this.cursorPosition);
    private String text = null;

    public WriteTextClient(String ... stringArray2) {
        super(stringArray2);
        this.addRepeatingParameter("text");
        this.addOption("cursor", stringArray -> {
            this.cursorPosition = Parse.asCursorPosition(stringArray[0]);
        }, "position");
    }

    @Override
    protected final void processParameters(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string);
        }
        this.text = stringBuilder.toString();
    }

    @Override
    protected final void extendUsageSummary(StringBuilder stringBuilder) {
        super.extendUsageSummary(stringBuilder);
        this.cursorPositionUsage.appendTo(stringBuilder);
    }

    @Override
    protected final void runClient(Connection connection2) throws ProgramException {
        Parse.checkMaximum(this.cursorPositionUsage.getOperandDescription(), this.cursorPosition, connection2.getCellCount());
        this.ttyMode(connection2, false, (Connection connection) -> {
            WriteTextClient.printf("%s\n", this.text);
            connection.write(this.text, this.cursorPosition);
            byte[] byArray = connection.getParameters().renderedCells.get();
            WriteTextClient.printf("%s\n", WriteTextClient.toUnicodeBraille(byArray));
            this.pause(connection);
        }, new int[0]);
    }
}

