/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.util.StringTokenizer;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.net.DBWUtils;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class ConnectionNameResolver
implements IVariableResolver {
    private final DataSourceDescriptor descriptor;
    private final DBPConnectionConfiguration configuration;
    private final DBPDataSourceContainer dataSourceContainer;
    public static final String[] CONNECTION_NAME_VARIABLES = new String[]{"host", "host.tunnel", "port", "server", "database", "user", "url", "connection.type", "project.name", "date", "host_or_database"};
    public static final String[][] CONNECTION_NAME_VARIABLES_INFO = new String[][]{{"host", "target database host"}, {"host.tunnel", "tunnel database host"}, {"port", "target database port"}, {"server", "target server name"}, {"database", "target database name"}, {"user", "database user name"}, {"url", "connection URL"}, {"connection.type", "connection type"}, {"project.name", "project name"}, {"date", "current date"}, {"host_or_database", "Legacy configuration for the connection name"}};

    @NotNull
    public static String[] getConnectionVariables() {
        return CONNECTION_NAME_VARIABLES;
    }

    @NotNull
    public static String[][] getConnectionVariablesInfo() {
        return CONNECTION_NAME_VARIABLES_INFO;
    }

    public ConnectionNameResolver(DBPDataSourceContainer dataSourceContainer, DBPConnectionConfiguration configuration, @Nullable DataSourceDescriptor descriptor) {
        this.dataSourceContainer = dataSourceContainer;
        this.configuration = configuration;
        this.descriptor = descriptor;
    }

    public DBPDataSourceContainer getDataSourceContainer() {
        return this.dataSourceContainer;
    }

    public DBPConnectionConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    private String generateLegacyConnectionName() {
        String newName;
        String string = newName = this.descriptor == null ? "" : this.getDataSourceContainer().getName();
        if (CommonUtils.isEmpty((String)newName)) {
            newName = this.getConfiguration().getDatabaseName();
            if (CommonUtils.isEmpty((String)newName) || newName.isBlank()) {
                newName = this.getConfiguration().getHostName();
            }
            if (CommonUtils.isEmpty((String)newName)) {
                newName = this.getConfiguration().getServerName();
            }
            if (CommonUtils.isEmpty((String)newName)) {
                newName = this.getDataSourceContainer().getDriver().getName();
            }
            if (CommonUtils.isEmpty((String)newName)) {
                newName = CoreMessages.dialog_connection_wizard_final_default_new_connection_name;
            }
            StringTokenizer st = new StringTokenizer(newName, "/\\");
            while (st.hasMoreTokens()) {
                String nextPart = st.nextToken();
                if (nextPart.matches("[0-9]+")) continue;
                newName = nextPart;
            }
            newName = CommonUtils.truncateString((String)newName, (int)50);
        }
        return CommonUtils.trim((String)CommonUtils.notEmpty((String)newName));
    }

    @Nullable
    public String get(@NotNull String name) {
        block45: {
            block43: {
                if (this.configuration == null) break block43;
                switch (name) {
                    case "host": {
                        return this.configuration.getHostName();
                    }
                    case "host.tunnel": {
                        return DBWUtils.getTargetTunnelHostName((DBPDataSourceContainer)this.dataSourceContainer, (DBPConnectionConfiguration)this.configuration);
                    }
                    case "port": {
                        return this.configuration.getHostPort();
                    }
                    case "server": {
                        return this.configuration.getServerName();
                    }
                    case "database": {
                        return this.configuration.getDatabaseName();
                    }
                    case "user": {
                        return this.configuration.getUserName();
                    }
                    case "host_or_database": {
                        return this.generateLegacyConnectionName();
                    }
                    case "url": {
                        return this.configuration.getUrl();
                    }
                    case "connection.type": 
                    case "connectionType": {
                        return this.configuration.getConnectionType().getId();
                    }
                }
            }
            if (this.dataSourceContainer == null) break block45;
            switch (name) {
                case "project.name": {
                    return this.dataSourceContainer.getProject().getName();
                }
                case "date": {
                    return RuntimeUtils.getCurrentDate();
                }
            }
        }
        return System.getenv(name);
    }
}

