/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSColorMixFunction;
import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSFunctionValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueList;
import io.sf.carte.doc.style.css.om.DefaultDeclarationFormattingContext;
import io.sf.carte.doc.style.css.property.ValueList;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;

public class ColorDeclarationFormattingContext
extends DefaultDeclarationFormattingContext {
    private static final long serialVersionUID = 1L;

    @Override
    public void writeValue(SimpleWriter wri, String propertyName, CSSValue value) throws IOException {
        if (value.getCssValueType() == CSSValue.CssType.LIST) {
            this.writeList(wri, propertyName, (ValueList)value);
            return;
        }
        switch (value.getPrimitiveType()) {
            case COLOR: {
                this.writeColor(wri, propertyName, (CSSColorValue)value);
                break;
            }
            case COLOR_MIX: {
                this.writeColorMix(wri, propertyName, (CSSColorMixFunction)value);
                break;
            }
            case FUNCTION: 
            case MATH_FUNCTION: 
            case GRADIENT: {
                this.writeFunction(wri, propertyName, (CSSFunctionValue)value);
                break;
            }
            default: {
                super.writeValue(wri, propertyName, value);
            }
        }
    }

    private void writeList(SimpleWriter wri, String propertyName, ValueList list) throws IOException {
        if (list.isCommaSeparated()) {
            this.writeCSList(wri, propertyName, list);
        } else if (!list.isBracketList()) {
            this.writeWSList(wri, propertyName, list);
        } else {
            super.writeValue(wri, propertyName, list);
        }
    }

    private void writeCSList(SimpleWriter wri, String propertyName, ValueList valueList) throws IOException {
        if (!valueList.isEmpty()) {
            this.writeValue(wri, propertyName, valueList.item(0));
            int sz = valueList.getLength();
            for (int i = 1; i < sz; ++i) {
                wri.write(',');
                wri.write(' ');
                this.writeValue(wri, propertyName, valueList.item(i));
            }
        }
    }

    private void writeWSList(SimpleWriter wri, String propertyName, ValueList valueList) throws IOException {
        if (!valueList.isEmpty()) {
            this.writeValue(wri, propertyName, valueList.item(0));
            int sz = valueList.getLength();
            for (int i = 1; i < sz; ++i) {
                wri.write(' ');
                this.writeValue(wri, propertyName, valueList.item(i));
            }
        }
    }

    protected void writeColor(SimpleWriter wri, String propertyName, CSSColorValue value) throws IOException {
        value.writeCssText(wri);
    }

    protected void writeColorMix(SimpleWriter wri, String propertyName, CSSColorMixFunction value) throws IOException {
        value.writeCssText(wri);
    }

    private void writeFunction(SimpleWriter wri, String propertyName, CSSFunctionValue value) throws IOException {
        CSSValueList<? extends CSSValue> arguments = value.getArguments();
        wri.write((CharSequence)value.getFunctionName());
        wri.write('(');
        int sz = arguments.getLength();
        if (sz == 1) {
            CSSValue first = arguments.item(0);
            if (first.getPrimitiveType() == CSSValue.Type.EXPRESSION && ((CSSExpressionValue)first).getStringValue().length() == 0) {
                ((CSSExpressionValue)first).getExpression().writeCssText(wri);
            } else {
                this.writeValue(wri, propertyName, first);
            }
        } else if (sz != 0) {
            this.writeValue(wri, propertyName, arguments.item(0));
            for (int i = 1; i < sz; ++i) {
                wri.write(',');
                wri.write(' ');
                this.writeValue(wri, propertyName, arguments.item(i));
            }
        }
        wri.write(')');
    }

    @Override
    public void writeMinifiedValue(SimpleWriter wri, String propertyName, CSSValue value) throws IOException {
        if (value.getCssValueType() == CSSValue.CssType.LIST) {
            this.writeMinifiedList(wri, propertyName, (ValueList)value);
            return;
        }
        switch (value.getPrimitiveType()) {
            case COLOR: {
                this.writeMinifiedColor(wri, propertyName, (CSSColorValue)value);
                break;
            }
            case COLOR_MIX: {
                this.writeColorMix(wri, propertyName, (CSSColorMixFunction)value);
                break;
            }
            case FUNCTION: 
            case MATH_FUNCTION: 
            case GRADIENT: {
                this.writeMinifiedFunction(wri, propertyName, (CSSFunctionValue)value);
                break;
            }
            default: {
                super.writeMinifiedValue(wri, propertyName, value);
            }
        }
    }

    private void writeMinifiedList(SimpleWriter wri, String propertyName, ValueList list) throws IOException {
        if (list.isCommaSeparated()) {
            this.writeMinifiedCSList(wri, propertyName, list);
        } else if (!list.isBracketList()) {
            this.writeMinifiedWSList(wri, propertyName, list);
        } else {
            super.writeMinifiedValue(wri, propertyName, list);
        }
    }

    private void writeMinifiedCSList(SimpleWriter wri, String propertyName, ValueList valueList) throws IOException {
        if (!valueList.isEmpty()) {
            this.writeMinifiedValue(wri, propertyName, valueList.item(0));
            int sz = valueList.getLength();
            for (int i = 1; i < sz; ++i) {
                wri.write(',');
                this.writeMinifiedValue(wri, propertyName, valueList.item(i));
            }
        }
    }

    private void writeMinifiedWSList(SimpleWriter wri, String propertyName, ValueList valueList) throws IOException {
        if (!valueList.isEmpty()) {
            this.writeMinifiedValue(wri, propertyName, valueList.item(0));
            int sz = valueList.getLength();
            for (int i = 1; i < sz; ++i) {
                wri.write(' ');
                this.writeMinifiedValue(wri, propertyName, valueList.item(i));
            }
        }
    }

    protected void writeMinifiedColor(SimpleWriter wri, String propertyName, CSSColorValue value) throws IOException {
        super.writeMinifiedValue(wri, propertyName, value);
    }

    protected void writeMinifiedColorMix(SimpleWriter wri, String propertyName, CSSColorMixFunction value) throws IOException {
        super.writeMinifiedValue(wri, propertyName, value);
    }

    private void writeMinifiedFunction(SimpleWriter wri, String propertyName, CSSFunctionValue value) throws IOException {
        CSSValueList<? extends CSSValue> arguments = value.getArguments();
        wri.write((CharSequence)value.getFunctionName());
        wri.write('(');
        int sz = arguments.getLength();
        if (sz == 1) {
            CSSValue first = arguments.item(0);
            if (first.getPrimitiveType() == CSSValue.Type.EXPRESSION && ((CSSExpressionValue)first).getStringValue().length() == 0) {
                wri.write((CharSequence)((CSSExpressionValue)first).getExpression().getMinifiedCssText());
            } else {
                this.writeMinifiedValue(wri, propertyName, first);
            }
        } else if (sz != 0) {
            this.writeMinifiedValue(wri, propertyName, arguments.item(0));
            for (int i = 1; i < sz; ++i) {
                wri.write(',');
                this.writeMinifiedValue(wri, propertyName, arguments.item(i));
            }
        }
        wri.write(')');
    }
}

