/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSRectValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class RectValue
extends TypedValue
implements CSSRectValue {
    private static final long serialVersionUID = 1L;
    private PrimitiveValue top = null;
    private PrimitiveValue right = null;
    private PrimitiveValue bottom = null;
    private PrimitiveValue left = null;

    RectValue() {
        super(CSSValue.Type.RECT);
    }

    protected RectValue(RectValue copied) {
        super(copied);
        this.left = copied.left;
        this.top = copied.top;
        this.right = copied.right;
        this.bottom = copied.bottom;
    }

    public void setTop(PrimitiveValue top) {
        if (top == null) {
            throw new NullPointerException();
        }
        this.top = top;
    }

    @Override
    public PrimitiveValue getTop() {
        return this.top;
    }

    public void setRight(PrimitiveValue right) {
        if (right == null) {
            throw new NullPointerException();
        }
        this.right = right;
    }

    @Override
    public PrimitiveValue getRight() {
        return this.right;
    }

    public void setBottom(PrimitiveValue bottom) {
        if (bottom == null) {
            throw new NullPointerException();
        }
        this.bottom = bottom;
    }

    @Override
    public PrimitiveValue getBottom() {
        return this.bottom;
    }

    public void setLeft(PrimitiveValue left) {
        if (left == null) {
            throw new NullPointerException();
        }
        this.left = left;
    }

    @Override
    public PrimitiveValue getLeft() {
        return this.left;
    }

    @Override
    public PrimitiveValue getComponent(int index) {
        switch (index) {
            case 0: {
                return this.top;
            }
            case 1: {
                return this.right;
            }
            case 2: {
                return this.bottom;
            }
            case 3: {
                return this.left;
            }
        }
        return null;
    }

    @Override
    public void setComponent(int index, StyleValue component) {
        if (component == null) {
            throw new NullPointerException();
        }
        PrimitiveValue primi = (PrimitiveValue)component;
        switch (index) {
            case 0: {
                this.top = primi;
                break;
            }
            case 1: {
                this.right = primi;
                break;
            }
            case 2: {
                this.bottom = primi;
                break;
            }
            case 3: {
                this.left = primi;
            }
        }
    }

    @Override
    public int getComponentCount() {
        return 4;
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public String getCssText() {
        BufferSimpleWriter sw = new BufferSimpleWriter(32);
        try {
            this.writeCssText((SimpleWriter)sw);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        StringBuilder buf = new StringBuilder(32);
        buf.append("rect(").append(this.getTop().getCssText()).append(',').append(this.getRight().getCssText()).append(',').append(this.getBottom().getCssText()).append(',').append(this.getLeft().getCssText()).append(')');
        return buf.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write((CharSequence)"rect(");
        this.getTop().writeCssText(wri);
        wri.write(',');
        wri.write(' ');
        this.getRight().writeCssText(wri);
        wri.write(',');
        wri.write(' ');
        this.getBottom().writeCssText(wri);
        wri.write(',');
        wri.write(' ');
        this.getLeft().writeCssText(wri);
        wri.write(')');
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.bottom == null ? 0 : this.bottom.hashCode());
        result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
        result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
        result = 31 * result + (this.top == null ? 0 : this.top.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RectValue other = (RectValue)obj;
        if (this.bottom == null ? other.bottom != null : !this.bottom.equals(other.bottom)) {
            return false;
        }
        if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
            return false;
        }
        if (this.right == null ? other.right != null : !this.right.equals(other.right)) {
            return false;
        }
        if (this.top == null) {
            return other.top == null;
        }
        return this.top.equals(other.top);
    }

    @Override
    public RectValue clone() {
        return new RectValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            ValueFactory factory = new ValueFactory();
            boolean commaFound = false;
            LexicalUnit lu = lunit.getParameters();
            this.checkProxyValue(lu);
            PrimitiveValue dimens = factory.createCSSPrimitiveValue(lu, true);
            RectValue.this.setTop(dimens);
            lu = lu.getNextLexicalUnit();
            if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                lu = lu.getNextLexicalUnit();
                commaFound = true;
            }
            this.checkProxyValue(lu);
            dimens = factory.createCSSPrimitiveValue(lu, true);
            RectValue.this.setRight(dimens);
            lu = lu.getNextLexicalUnit();
            if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                if (commaFound) {
                    throw new DOMException(12, "Bad syntax for rect.");
                }
            } else {
                if (!commaFound) {
                    throw new DOMException(12, "Bad syntax for rect.");
                }
                lu = lu.getNextLexicalUnit();
            }
            this.checkProxyValue(lu);
            dimens = factory.createCSSPrimitiveValue(lu, true);
            RectValue.this.setBottom(dimens);
            lu = lu.getNextLexicalUnit();
            if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                if (commaFound) {
                    throw new DOMException(12, "Bad syntax for rect.");
                }
            } else {
                lu = lu.getNextLexicalUnit();
            }
            this.checkProxyValue(lu);
            dimens = factory.createCSSPrimitiveValue(lu, true);
            RectValue.this.setLeft(dimens);
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }
    }
}

