/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.dom.svg;

import org.w3c.dom.DOMException;

public interface SVGLength {
    public static final short SVG_LENGTHTYPE_UNKNOWN = 0;
    public static final short SVG_LENGTHTYPE_NUMBER = 1;
    public static final short SVG_LENGTHTYPE_PERCENTAGE = 2;
    public static final short SVG_LENGTHTYPE_EMS = 3;
    public static final short SVG_LENGTHTYPE_EXS = 4;
    public static final short SVG_LENGTHTYPE_PX = 5;
    public static final short SVG_LENGTHTYPE_CM = 6;
    public static final short SVG_LENGTHTYPE_MM = 7;
    public static final short SVG_LENGTHTYPE_IN = 8;
    public static final short SVG_LENGTHTYPE_PT = 9;
    public static final short SVG_LENGTHTYPE_PC = 10;

    default public short getCSSUnitType() {
        return 255;
    }

    default public short getUnitType() {
        short svgUnit;
        switch (this.getCSSUnitType()) {
            case 0: {
                svgUnit = 1;
                break;
            }
            case 3: {
                svgUnit = 5;
                break;
            }
            case 20: {
                svgUnit = 3;
                break;
            }
            case 21: {
                svgUnit = 4;
                break;
            }
            case 4: {
                svgUnit = 8;
                break;
            }
            case 7: {
                svgUnit = 6;
                break;
            }
            case 8: {
                svgUnit = 7;
                break;
            }
            case 5: {
                svgUnit = 10;
                break;
            }
            case 6: {
                svgUnit = 9;
                break;
            }
            case 2: {
                svgUnit = 2;
                break;
            }
            default: {
                svgUnit = 0;
            }
        }
        return svgUnit;
    }

    public float getValue();

    public void setValue(float var1) throws DOMException;

    public float getValueInSpecifiedUnits();

    public void setValueInSpecifiedUnits(float var1) throws DOMException;

    public String getValueAsString();

    public void setValueAsString(String var1) throws DOMException;

    default public void newValueSpecifiedCSSUnits(short cssUnitType, float valueInSpecifiedUnits) throws DOMException {
        short svgUnit;
        switch (this.getCSSUnitType()) {
            case 0: {
                svgUnit = 1;
                break;
            }
            case 3: {
                svgUnit = 5;
                break;
            }
            case 20: {
                svgUnit = 3;
                break;
            }
            case 21: {
                svgUnit = 4;
                break;
            }
            case 4: {
                svgUnit = 8;
                break;
            }
            case 7: {
                svgUnit = 6;
                break;
            }
            case 8: {
                svgUnit = 7;
                break;
            }
            case 5: {
                svgUnit = 10;
                break;
            }
            case 6: {
                svgUnit = 9;
                break;
            }
            case 2: {
                svgUnit = 2;
                break;
            }
            default: {
                throw new DOMException(9, "Unsupported CSS unit: " + cssUnitType);
            }
        }
        this.newValueSpecifiedUnits(svgUnit, valueInSpecifiedUnits);
    }

    public void newValueSpecifiedUnits(short var1, float var2) throws DOMException;

    public void convertToSpecifiedUnits(short var1) throws DOMException;
}

