/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.BitmapResource;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataImage;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DynamicDataType;
import ghidra.program.model.data.ReadOnlyDataTypeComponent;
import ghidra.program.model.data.Resource;
import ghidra.program.model.data.WordDataType;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.classfinder.ClassTranslator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class BitmapResourceDataType
extends DynamicDataType
implements Resource {
    private static final long serialVersionUID = 1L;

    public BitmapResourceDataType() {
        this(null, "BitmapResource", null);
    }

    public BitmapResourceDataType(DataTypeManager dtm) {
        this(null, "BitmapResource", dtm);
    }

    protected BitmapResourceDataType(CategoryPath path, String name, DataTypeManager dtm) {
        super(path, name, dtm);
    }

    @Override
    public String getDescription() {
        return "Bitmap stored as a Resource";
    }

    @Override
    public String getMnemonic(Settings settings) {
        return "BitmapRes";
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        BitmapResource bitmap = this.getBitmapResource(buf);
        if (bitmap == null) {
            return null;
        }
        DataImage img = bitmap.getDataImage(buf);
        if (img != null) {
            img.setDescription("<Bitmap-Image>");
        }
        return img;
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return DataImage.class;
    }

    @Override
    protected final synchronized DataTypeComponent[] getAllComponents(MemBuffer buf) {
        BitmapResource bmr = this.getBitmapResource(buf);
        if (bmr == null) {
            return null;
        }
        try {
            bmr.getDataImage(buf);
        }
        catch (Exception e) {
            return null;
        }
        ArrayList<DataTypeComponent> comps = new ArrayList<DataTypeComponent>();
        this.addComponents(buf, bmr, comps);
        DataTypeComponent[] compsArray = new DataTypeComponent[comps.size()];
        comps.toArray(compsArray);
        comps = null;
        return compsArray;
    }

    protected final synchronized int addComp(DataType dataType, int length, String fieldName, List<DataTypeComponent> comps, int offset) {
        comps.add(new ReadOnlyDataTypeComponent(dataType, this, length, comps.size(), offset, fieldName, null));
        return offset + length;
    }

    protected BitmapResource getBitmapResource(MemBuffer buf) {
        try {
            return new BitmapResource(buf);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    protected int addComponents(MemBuffer buf, BitmapResource bmr, List<DataTypeComponent> comps) {
        ArrayDataType array;
        int offset = 0;
        offset = this.addComp(DWordDataType.dataType, 4, "size", comps, offset);
        offset = this.addComp(DWordDataType.dataType, 4, "width", comps, offset);
        offset = this.addComp(DWordDataType.dataType, 4, "height", comps, offset);
        offset = this.addComp(WordDataType.dataType, 2, "planes", comps, offset);
        offset = this.addComp(WordDataType.dataType, 2, "bitCount", comps, offset);
        offset = this.addComp(DWordDataType.dataType, 4, "compression", comps, offset);
        offset = this.addComp(DWordDataType.dataType, 4, "sizeImage", comps, offset);
        offset = this.addComp(DWordDataType.dataType, 4, "XpelsPerMeter", comps, offset);
        offset = this.addComp(DWordDataType.dataType, 4, "YpelsPerMeter", comps, offset);
        offset = this.addComp(DWordDataType.dataType, 4, "clrUsed", comps, offset);
        offset = this.addComp(DWordDataType.dataType, 4, "clrImportant", comps, offset);
        int arraySize = bmr.getColorMapLength();
        if (arraySize > 0) {
            array = new ArrayDataType(ByteDataType.dataType, arraySize, 1);
            offset = this.addComp(array, arraySize, "ColorMap", comps, offset);
        }
        if ((arraySize = bmr.getRawSizeImage()) > 0) {
            array = new ArrayDataType(ByteDataType.dataType, arraySize, 1);
            offset = this.addComp(array, arraySize, "ImageData", comps, offset);
        }
        return offset;
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return "<Bitmap-Image>";
    }

    @Override
    public String getDefaultLabelPrefix() {
        return "BITMAP";
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new BitmapResourceDataType(dtm);
    }

    static {
        ClassTranslator.put((String)"ghidra.app.plugin.prototype.data.BitmapResourceDataType", (String)BitmapResourceDataType.class.getName());
    }
}

