/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.listing;

import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.AutoParameterType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.InvalidInputException;

public class AutoParameterImpl
extends ParameterImpl {
    private Function function;

    public AutoParameterImpl(DataType dataType, int ordinal, VariableStorage storage, Function function) throws InvalidInputException {
        super(AutoParameterImpl.getAutoName(storage.getAutoParameterType()), ordinal, dataType, storage, false, function.getProgram(), SourceType.ANALYSIS);
        if (storage.isForcedIndirect() || !storage.isAutoStorage()) {
            throw new IllegalArgumentException("Improper auto storage specified");
        }
        this.function = function;
    }

    @Override
    public Function getFunction() {
        return this.function;
    }

    private static String getAutoName(AutoParameterType autoParamType) {
        if (autoParamType == null) {
            throw new IllegalArgumentException("storage does not correspond to an auto-parameter");
        }
        return autoParamType.getDisplayName();
    }

    @Override
    public void setDataType(DataType type, VariableStorage storage, boolean force, SourceType source) throws InvalidInputException {
        throw new InvalidInputException("Auto-parameter may not be modified");
    }

    @Override
    public void setDataType(DataType type, SourceType source) throws InvalidInputException {
        throw new InvalidInputException("Auto-parameter may not be modified");
    }

    @Override
    public void setComment(String comment) {
    }

    @Override
    public void setName(String name, SourceType source) throws InvalidInputException {
        throw new InvalidInputException("Auto-parameter may not be modified");
    }
}

