/*
 * Decompiled with CFR 0.152.
 */
package datagraph.data.graph.panel.model.row;

import datagraph.data.graph.panel.model.row.ArrayGroupDataRowObject;
import datagraph.data.graph.panel.model.row.ComponentDataRowObject;
import datagraph.data.graph.panel.model.row.DataRowObject;
import ghidra.program.model.data.Array;
import ghidra.program.model.listing.Data;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class OpenDataChildren
implements Comparable<OpenDataChildren> {
    private static final int ARRAY_GROUP_SIZE = 100;
    private int rowIndex;
    private int rowCount;
    private int componentIndex;
    private int componentCount;
    protected int indentLevel;
    protected List<OpenDataChildren> openChildren;
    protected Data data;

    protected OpenDataChildren(Data data, int rowIndex, int componentIndex, int componentCount, int indentLevel) {
        this.data = data;
        this.rowIndex = rowIndex;
        this.componentCount = componentCount;
        this.rowCount = componentCount;
        this.componentIndex = componentIndex;
        this.indentLevel = indentLevel;
        this.openChildren = new ArrayList<OpenDataChildren>();
    }

    public static OpenDataChildren createOpenDataNode(Data data, int rowIndex, int componentIndex, int indentLevel) {
        int numComponents = data.getNumComponents();
        if (data.getDataType() instanceof Array) {
            if (numComponents <= 100) {
                return new ArrayElementsComponentNode(data, rowIndex, componentIndex, numComponents, 0, indentLevel);
            }
            return new ArrayGroupComponentNode(data, rowIndex, componentIndex, 0, numComponents, indentLevel);
        }
        return new DataComponentNode(data, rowIndex, componentIndex, numComponents, indentLevel);
    }

    private OpenDataChildren(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public DataRowObject getRow(int childRowIndex) {
        OpenDataChildren node = this.findChildNodeAtOrBefore(childRowIndex);
        if (node == null) {
            return this.generateRow(childRowIndex, false);
        }
        if (node.getRowIndex() == childRowIndex) {
            return this.generateRow(node.getComponentIndex(), true);
        }
        int childIndex = childRowIndex - node.getRowIndex() - 1;
        if (childIndex < node.getRowCount()) {
            return node.getRow(childIndex);
        }
        int childComponentIndex = node.getComponentIndex() + childRowIndex - node.getRowIndex() - node.getRowCount();
        return this.generateRow(childComponentIndex, false);
    }

    protected int getComponentIndex() {
        return this.componentIndex;
    }

    protected abstract DataRowObject generateRow(int var1, boolean var2);

    public int expandChild(int childRowIndex) {
        OpenDataChildren node = this.findChildNodeAtOrBefore(childRowIndex);
        if (node == null) {
            return this.insertNode(childRowIndex, childRowIndex);
        }
        int indexPastNode = childRowIndex - node.getRowIndex();
        if (indexPastNode == 0) {
            return 0;
        }
        if (indexPastNode <= node.getRowCount()) {
            int diff = node.expandChild(indexPastNode - 1);
            this.rebuildNodeIndex();
            return diff;
        }
        int childComponentIndex = node.getComponentIndex() + indexPastNode - node.rowCount;
        return this.insertNode(childRowIndex, childComponentIndex);
    }

    public int collapseChild(int childRowIndex) {
        OpenDataChildren node = this.findChildNodeAtOrBefore(childRowIndex);
        if (node == null) {
            return 0;
        }
        int offsetIndex = childRowIndex - node.rowIndex;
        if (offsetIndex == 0) {
            this.openChildren.remove(node);
            this.rebuildNodeIndex();
            return node.getRowCount();
        }
        if (offsetIndex <= node.getRowCount()) {
            int diff = node.collapseChild(offsetIndex - 1);
            this.rebuildNodeIndex();
            return diff;
        }
        return 0;
    }

    protected void rebuildNodeIndex() {
        this.rowCount = this.componentCount;
        OpenDataChildren lastNode = null;
        for (OpenDataChildren node : this.openChildren) {
            node.rowIndex = lastNode == null ? node.componentIndex : lastNode.rowIndex + node.componentIndex - lastNode.componentIndex + lastNode.rowCount;
            this.rowCount += node.rowCount;
            lastNode = node;
        }
    }

    protected int insertNode(int childRowIndex, int childComponentIndex) {
        OpenDataChildren newNode = this.generatedNode(childRowIndex, childComponentIndex);
        if (newNode == null) {
            return 0;
        }
        int index = Collections.binarySearch(this.openChildren, newNode);
        if (index >= 0) {
            return 0;
        }
        int insertionIndex = -index - 1;
        this.openChildren.add(insertionIndex, newNode);
        this.rebuildNodeIndex();
        return newNode.getRowCount();
    }

    protected abstract OpenDataChildren generatedNode(int var1, int var2);

    int getRowIndex() {
        return this.rowIndex;
    }

    void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    @Override
    public int compareTo(OpenDataChildren o) {
        return this.getRowIndex() - o.getRowIndex();
    }

    public boolean refresh(Data newData) {
        int newComponentCount = this.data.getNumComponents();
        if (this.data != newData || newComponentCount == 0) {
            this.openChildren.clear();
            return false;
        }
        if (newComponentCount != this.componentCount) {
            this.openChildren.clear();
            this.rowCount = this.componentCount = newComponentCount;
            return true;
        }
        Iterator<OpenDataChildren> it = this.openChildren.iterator();
        while (it.hasNext()) {
            OpenDataChildren child = it.next();
            if (child.refresh(this.data.getComponent(child.componentIndex))) continue;
            it.remove();
        }
        this.rebuildNodeIndex();
        return true;
    }

    protected OpenDataChildren findChildNodeAtOrBefore(int childRowIndex) {
        if (this.openChildren.isEmpty()) {
            return null;
        }
        int index = Collections.binarySearch(this.openChildren, new SearchKeyNode(childRowIndex));
        if (index < 0) {
            index = -index - 2;
        }
        return index < 0 ? null : this.openChildren.get(index);
    }

    private static class ArrayElementsComponentNode
    extends OpenDataChildren {
        private int arrayStartIndex;
        private int totalArraySize;

        protected ArrayElementsComponentNode(Data data, int rowIndex, int componentIndex, int componentCount, int arrayStartIndex, int indentLevel) {
            super(data, rowIndex, componentIndex, componentCount, indentLevel);
            this.arrayStartIndex = arrayStartIndex;
            this.totalArraySize = data.getNumComponents();
        }

        @Override
        protected DataRowObject generateRow(int childComponentIndex, boolean isOpen) {
            Data component = this.data.getComponent(this.arrayStartIndex + childComponentIndex);
            return new ComponentDataRowObject(this.indentLevel + 1, component, isOpen);
        }

        @Override
        protected OpenDataChildren generatedNode(int childRowIndex, int childComponentIndex) {
            Data component = this.data.getComponent(this.arrayStartIndex + childComponentIndex);
            return ArrayElementsComponentNode.createOpenDataNode(component, childRowIndex, childComponentIndex, this.indentLevel + 1);
        }

        @Override
        public boolean refresh(Data newData) {
            if (!(newData.getDataType() instanceof Array)) {
                return false;
            }
            int newTotalArraySize = this.data.getNumComponents();
            if (this.data != newData || newTotalArraySize != this.totalArraySize) {
                return false;
            }
            for (OpenDataChildren child : this.openChildren) {
                Data component;
                if (child.refresh(component = this.data.getComponent(this.arrayStartIndex + child.getComponentIndex()))) continue;
                this.openChildren.clear();
                break;
            }
            this.rebuildNodeIndex();
            return true;
        }
    }

    private static class ArrayGroupComponentNode
    extends OpenDataChildren {
        private int arrayStartIndex;
        private int groupSize;
        private int arrayCount;
        private int totalArraySize;

        public ArrayGroupComponentNode(Data data, int rowIndex, int componentIndex, int arrayStartIndex, int arrayCount, int indentLevel) {
            super(data, rowIndex, componentIndex, ArrayGroupComponentNode.getGroupCount(arrayCount), indentLevel);
            this.arrayStartIndex = arrayStartIndex;
            this.arrayCount = arrayCount;
            this.groupSize = ArrayGroupComponentNode.getGroupSize(arrayCount);
            this.totalArraySize = data.getNumComponents();
        }

        private static int getGroupCount(int length) {
            int groupSize = 100;
            int numGroups = (length + groupSize - 1) / groupSize;
            while (numGroups > 100) {
                numGroups = (length + (groupSize *= 100) - 1) / groupSize;
            }
            return numGroups;
        }

        private static int getGroupSize(int length) {
            int groupSize = 100;
            int numGroups = (length + groupSize - 1) / groupSize;
            while (numGroups > 100) {
                numGroups = (length + (groupSize *= 100) - 1) / groupSize;
            }
            return groupSize;
        }

        @Override
        protected DataRowObject generateRow(int childComponentIndex, boolean isOpen) {
            int subArrayStartIndex = this.arrayStartIndex + childComponentIndex * this.groupSize;
            int length = Math.min(this.groupSize, this.arrayCount - childComponentIndex * this.groupSize);
            return new ArrayGroupDataRowObject(this.data, subArrayStartIndex, length, this.indentLevel + 1, isOpen);
        }

        @Override
        protected OpenDataChildren generatedNode(int childRowIndex, int childComponentIndex) {
            int arrayOffsetFromStart = childComponentIndex * this.groupSize;
            int subArrayStartIndex = this.arrayStartIndex + arrayOffsetFromStart;
            int length = Math.min(this.groupSize, this.arrayCount - arrayOffsetFromStart);
            if (this.groupSize == 100) {
                return new ArrayElementsComponentNode(this.data, childRowIndex, childComponentIndex, length, subArrayStartIndex, this.indentLevel + 1);
            }
            return new ArrayGroupComponentNode(this.data, childRowIndex, childComponentIndex, subArrayStartIndex, length, this.indentLevel + 1);
        }

        @Override
        public boolean refresh(Data newData) {
            if (!(newData.getDataType() instanceof Array)) {
                return false;
            }
            int newTotalArraySize = this.data.getNumComponents();
            if (this.data != newData || newTotalArraySize != this.totalArraySize) {
                return false;
            }
            for (OpenDataChildren child : this.openChildren) {
                if (child.refresh(this.data)) continue;
                this.openChildren.clear();
                break;
            }
            this.rebuildNodeIndex();
            return true;
        }
    }

    private static class DataComponentNode
    extends OpenDataChildren {
        public DataComponentNode(Data data, int rowIndex, int componentIndex, int numComponents, int indentLevel) {
            super(data, rowIndex, componentIndex, numComponents, indentLevel);
        }

        @Override
        protected DataRowObject generateRow(int childComponentIndex, boolean isOpen) {
            Data component = this.data.getComponent(childComponentIndex);
            return new ComponentDataRowObject(this.indentLevel, component, isOpen);
        }

        @Override
        protected OpenDataChildren generatedNode(int childRowIndex, int childComponentIndex) {
            Data component = this.data.getComponent(childComponentIndex);
            return DataComponentNode.createOpenDataNode(component, childRowIndex, childComponentIndex, this.indentLevel + 1);
        }
    }

    private static class SearchKeyNode
    extends OpenDataChildren {
        SearchKeyNode(int rowIndex) {
            super(rowIndex);
        }

        @Override
        protected DataRowObject generateRow(int childComponentIndex, boolean isOpen) {
            return null;
        }

        @Override
        protected OpenDataChildren generatedNode(int childRowIndex, int childComponentIndex) {
            return null;
        }
    }
}

