/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.RISCV_ElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.RISCV_ElfRelocationType;
import ghidra.program.model.address.Address;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;

class RISCV_ElfRelocationContext
extends ElfRelocationContext<RISCV_ElfRelocationHandler> {
    protected RISCV_ElfRelocationContext(RISCV_ElfRelocationHandler handler, ElfLoadHelper loadHelper, Map<ElfSymbol, Address> symbolMap) {
        super((ElfRelocationHandler)handler, loadHelper, symbolMap);
    }

    ElfRelocation getHi20Relocation(ElfSymbol hi20Symbol) {
        Long symValue = hi20Symbol.getValue();
        ElfRelocation[] relocations = this.relocationTable.getRelocations();
        int relIndex = Arrays.binarySearch(relocations, symValue, OffsetComparator.INSTANCE);
        if (relIndex < 0) {
            return null;
        }
        while (relIndex > 0 && relocations[relIndex - 1].getOffset() == symValue.longValue()) {
            --relIndex;
        }
        while (relIndex < relocations.length && relocations[relIndex].getOffset() == symValue.longValue()) {
            int typeId = relocations[relIndex].getType();
            if (typeId == RISCV_ElfRelocationType.R_RISCV_PCREL_HI20.typeId || typeId == RISCV_ElfRelocationType.R_RISCV_GOT_HI20.typeId) {
                return relocations[relIndex];
            }
            ++relIndex;
        }
        return null;
    }

    private static class OffsetComparator
    implements Comparator<Object> {
        public static final OffsetComparator INSTANCE = new OffsetComparator();

        private OffsetComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            long offset;
            if (o1 instanceof Long) {
                return -this.compare(o2, o1);
            }
            ElfRelocation rel = (ElfRelocation)o1;
            long relOffset = rel.getOffset();
            if (relOffset == (offset = ((Long)o2).longValue())) {
                return 0;
            }
            return Long.compareUnsigned(relOffset, offset);
        }
    }
}

