/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.events;

import ghidra.framework.plugintool.PluginEvent;
import ghidra.program.util.GroupPath;

public final class TreeSelectionPluginEvent
extends PluginEvent {
    public static final String NAME = "ProgramTreeSelection";
    private GroupPath[] groupPaths;
    private String treeName;

    public TreeSelectionPluginEvent(String source, String treeName, GroupPath[] groupPaths) {
        super(source, NAME);
        this.treeName = treeName;
        this.groupPaths = groupPaths;
    }

    public GroupPath[] getGroupPaths() {
        return this.groupPaths;
    }

    public String getTreeName() {
        return this.treeName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Tree Name = ");
        sb.append(this.treeName);
        sb.append(", Group Paths = {");
        for (int i = 0; i < this.groupPaths.length; ++i) {
            sb.append("[");
            sb.append(this.groupPaths[i].toString());
            sb.append("]");
            if (i >= this.groupPaths.length - 1) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

