/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.som;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class SomImportEntry
implements StructConverter {
    public static final int SIZE = 8;
    private String name;
    private int reserved2;
    private int type;
    private boolean bypassable;
    private int reserved1;

    public SomImportEntry(BinaryReader reader, long stringTableLoc) throws IOException {
        int nameIndex = reader.readNextInt();
        this.name = nameIndex != -1 ? reader.readAsciiString(stringTableLoc + (long)nameIndex) : null;
        int bitfield = reader.readNextInt();
        this.reserved1 = bitfield & 0x7F;
        this.bypassable = (bitfield >> 7 & 1) != 0;
        this.type = bitfield >> 8 & 0xFF;
        this.reserved2 = bitfield >> 16 & 0xFFFF;
    }

    public String getName() {
        return this.name;
    }

    public int getReserved2() {
        return this.reserved2;
    }

    public int getType() {
        return this.type;
    }

    public boolean isBypassable() {
        return this.bypassable;
    }

    public int getReserved1() {
        return this.reserved1;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("import_entry", 8);
        struct.setPackingEnabled(true);
        struct.add(DWORD, "name", "offset in string table");
        try {
            struct.addBitField(DWORD, 16, "reserved2", "unused");
            struct.addBitField(DWORD, 8, "type", "symbol type");
            struct.addBitField(DWORD, 1, "bypassable", "address of code symbol not taken in shlib");
            struct.addBitField(DWORD, 7, "reserved1", "unused");
        }
        catch (InvalidDataTypeException e) {
            throw new IOException(e);
        }
        struct.setCategoryPath(new CategoryPath("/SOM"));
        return struct;
    }
}

