/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.extension.datatype.finder;

import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangLine;
import ghidra.app.extension.datatype.finder.DecompilerReference;
import ghidra.app.extension.datatype.finder.VariableAccessDR;
import ghidra.app.services.DataTypeReference;
import ghidra.app.services.FieldMatcher;
import ghidra.program.model.data.DataType;
import java.util.List;

public class AnonymousVariableAccessDR
extends VariableAccessDR {
    protected AnonymousVariableAccessDR(ClangLine line, ClangFieldToken token) {
        super(line, token);
    }

    @Override
    public void accumulateMatches(DataType dt, FieldMatcher fieldMatcher, List<DataTypeReference> results) {
        boolean noMatch;
        ClangFieldToken field = (ClangFieldToken)this.sourceToken;
        DataType compositeType = field.getDataType();
        DataType fieldDt = DecompilerReference.getFieldDataType(field);
        boolean matchesCompositeType = AnonymousVariableAccessDR.isEqual(dt, compositeType);
        boolean matchesFieldType = AnonymousVariableAccessDR.isEqual(dt, fieldDt);
        boolean bl = noMatch = !matchesCompositeType && !matchesFieldType;
        if (noMatch) {
            return;
        }
        if (fieldMatcher.isIgnored()) {
            if (matchesFieldType) {
                results.add(this.createReference(this.variable));
            }
            return;
        }
        String text = field.getText();
        int offset = field.getOffset();
        if (matchesCompositeType && fieldMatcher.matches(text, offset)) {
            results.add(new DataTypeReference(compositeType, fieldMatcher.getFieldName(), this.getFunction(), this.getAddress(), this.getContext()));
        }
    }
}

