/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.layout;

import ghidra.graph.VisualGraph;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.layout.LayoutPositions;
import ghidra.graph.viewer.layout.VisualGraphLayout;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;

public class CalculateLayoutLocationsTask<V extends VisualVertex, E extends VisualEdge<V>>
extends Task {
    private VisualGraphLayout<V, E> layout;
    private VisualGraph<V, E> graph;
    private LayoutPositions<V, E> locations;

    public CalculateLayoutLocationsTask(VisualGraph<V, E> graph, VisualGraphLayout<V, E> layout) {
        super("Calculate Layout Locations", true, false, true, true);
        this.graph = graph;
        this.layout = layout;
    }

    public void run(TaskMonitor monitor) {
        monitor.setMessage("Calculating layout locations...");
        this.locations = this.layout.calculateLocations(this.graph, monitor);
    }

    public LayoutPositions<V, E> getLocations() {
        return this.locations;
    }
}

