/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control.modal;

import java.awt.GridLayout;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jungrapht.visualization.control.modal.Modal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModePanel
extends JPanel
implements Modal {
    private static final Logger log = LoggerFactory.getLogger(ModePanel.class);
    protected Supplier<AbstractButton> buttonSupplier;
    protected Modal.Mode[] modes;
    protected Set<Modal> modals;
    protected ButtonGroup buttonGroup = new ButtonGroup();
    protected Modal.Mode mode;
    protected Map<Modal.Mode, AbstractButton> modeMap = new HashMap<Modal.Mode, AbstractButton>();

    public static Builder builder() {
        return new Builder();
    }

    ModePanel(Builder builder) {
        this(builder.mode, builder.buttonSupplier, builder.modes, builder.modals);
    }

    private ModePanel(Modal.Mode mode, Supplier<AbstractButton> buttonSupplier, Modal.Mode[] modes, Set<Modal> modals) {
        this.setLayout(new GridLayout(0, 1));
        this.mode = mode;
        this.buttonSupplier = buttonSupplier;
        this.modes = modes;
        this.modals = modals;
        if (this.mode == null) {
            this.mode = modes[0];
        }
    }

    public boolean addModal(Modal modal) {
        return this.modals.add(modal);
    }

    public boolean removeModal(Modal modal) {
        return this.modals.remove(modal);
    }

    public void addModals(Modal ... modals) {
        Stream.of(modals).forEach(this.modals::add);
    }

    public void removeModal(Modal ... modals) {
        Stream.of(modals).forEach(this.modals::remove);
    }

    public ModePanel buildUI() {
        Stream.of(this.modes).forEach(m -> {
            AbstractButton button = this.buttonSupplier.get();
            button.setText(m.name());
            this.buttonGroup.add(button);
            this.modeMap.put((Modal.Mode)((Object)m), button);
            this.add(button);
            button.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    String text = ((AbstractButton)e.getItem()).getText();
                    Modal.Mode mode = Modal.Mode.valueOf(text);
                    this.modals.forEach(modal -> modal.setMode(mode));
                }
            });
        });
        this.modals.forEach(modal -> modal.setMode(this.mode));
        this.setMode(this.mode);
        return this;
    }

    @Override
    public void setMode(Modal.Mode mode) {
        AbstractButton button = this.modeMap.get((Object)mode);
        if (!button.isSelected()) {
            button.setSelected(true);
        }
    }

    @Override
    public Modal.Mode getMode() {
        return this.mode;
    }

    public static class Builder {
        protected Supplier<AbstractButton> buttonSupplier = JRadioButton::new;
        protected Modal.Mode[] modes;
        protected Set<Modal> modals = new LinkedHashSet<Modal>();
        protected Modal.Mode mode;

        public Builder buttonSupplier(Supplier<AbstractButton> buttonSupplier) {
            this.buttonSupplier = buttonSupplier;
            return this;
        }

        public Builder modes(Modal.Mode ... modes) {
            this.modes = modes;
            return this;
        }

        public Builder modals(Modal ... modals) {
            this.modals = Stream.of(modals).collect(Collectors.toCollection(LinkedHashSet::new));
            return this;
        }

        public Builder mode(Modal.Mode mode) {
            this.mode = mode;
            return this;
        }

        public ModePanel build() {
            return new ModePanel(this);
        }
    }
}

