/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.analyzers;

import generic.stl.Pair;
import ghidra.app.analyzers.FuncRecord;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;

public class LibraryRecord
implements Comparable<LibraryRecord> {
    private TreeSet<FuncRecord> records = new TreeSet();
    private String libName;
    private String libVersion;

    public LibraryRecord() {
        this.libName = null;
        this.libVersion = null;
    }

    public LibraryRecord(Program prgm) throws CancelledException {
        this.libName = prgm.getName();
        this.libVersion = "1.0";
        HashMap<String, FuncRecord> nameToEntry = new HashMap<String, FuncRecord>();
        HashMap<Address, FuncRecord> addrToEntry = new HashMap<Address, FuncRecord>();
        for (Function func : prgm.getFunctionManager().getFunctions(true)) {
            FuncRecord entry = new FuncRecord(func);
            this.insert(entry);
            nameToEntry.put(func.toString(), entry);
            addrToEntry.put(entry.func.getEntryPoint(), entry);
        }
        for (FuncRecord entry : this.records) {
            for (Address call : entry.calls) {
                entry.children.add((FuncRecord)addrToEntry.get(call));
            }
        }
    }

    private void insert(FuncRecord record) {
        this.records.add(record);
    }

    public TreeSet<FuncRecord> getRecords() {
        return this.records;
    }

    public ArrayList<FuncRecord> query(Long hash) {
        ArrayList<FuncRecord> result = new ArrayList<FuncRecord>();
        FuncRecord temp = new FuncRecord();
        temp.hashValue = hash;
        for (FuncRecord entry : this.records.tailSet(temp)) {
            if (entry.hashValue == hash) {
                result.add(entry);
                continue;
            }
            if (entry.hashValue <= hash) continue;
            break;
        }
        return result;
    }

    public void restoreXml(XmlPullParser parser) {
        ArrayList<Pair<String, String>> strEdges = new ArrayList<Pair<String, String>>();
        HashMap<String, FuncRecord> str2rec = new HashMap<String, FuncRecord>();
        XmlElement el = parser.start(new String[]{"libRec"});
        this.libName = el.getAttribute("libName");
        this.libVersion = el.getAttribute("libVersion");
        while (parser.peek().isStart()) {
            FuncRecord entry = new FuncRecord();
            ArrayList<Pair<String, String>> arrayList = entry.restoreXml(parser);
            str2rec.put(entry.funcName, entry);
            strEdges.addAll(arrayList);
            this.insert(entry);
        }
        for (Pair pair : strEdges) {
            FuncRecord source = (FuncRecord)str2rec.get(pair.first);
            FuncRecord dest = (FuncRecord)str2rec.get(pair.second);
            source.children.add(dest);
        }
        parser.end();
    }

    public void saveXml(Writer fwrite) throws IOException {
        StringBuilder buf = new StringBuilder();
        buf.append(" <libRec");
        buf.append(" libName=\"");
        SpecXmlUtils.xmlEscape((StringBuilder)buf, (String)this.libName);
        buf.append("\"");
        buf.append(" libVersion=\"");
        SpecXmlUtils.xmlEscape((StringBuilder)buf, (String)this.libVersion);
        buf.append("\">\n");
        fwrite.append(buf.toString());
        for (FuncRecord entry : this.records) {
            entry.saveXml(fwrite);
        }
        fwrite.append(" </libRec>\n");
    }

    @Override
    public int compareTo(LibraryRecord o) {
        int first = this.libName.compareTo(o.libName);
        if (first != 0) {
            return first;
        }
        return this.libVersion.compareTo(o.libVersion);
    }
}

