/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis.rust.demangler;

public enum RustDemanglerFormat {
    AUTO("", Version.ALL),
    LEGACY("legacy", Version.ALL),
    V0("v0", Version.MODERN);

    private final String format;
    private final Version version;

    private RustDemanglerFormat(String format, Version version) {
        this.format = format;
        this.version = version;
    }

    public boolean isDeprecatedFormat() {
        return this.version == Version.DEPRECATED || this.version == Version.ALL;
    }

    public boolean isModernFormat() {
        return this.version == Version.MODERN || this.version == Version.ALL;
    }

    public boolean isAvailable(boolean isDeprecated) {
        return isDeprecated ? this.isDeprecatedFormat() : this.isModernFormat();
    }

    public String getFormat() {
        return this.format;
    }

    private static enum Version {
        DEPRECATED,
        MODERN,
        ALL;

    }
}

