/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti.types;

import ghidra.app.util.bin.format.golang.GoVer;
import ghidra.app.util.bin.format.golang.GoVerRange;
import java.util.EnumSet;
import java.util.Set;

public enum GoTypeFlag {
    Uncommon(1, GoVerRange.ALL),
    ExtraStar(2, GoVerRange.ALL),
    Named(4, GoVerRange.ALL),
    RegularMemory(8, GoVerRange.ALL),
    UnrolledBitmap(16, GoVerRange.parse("1.22-"));

    private final int value;
    private GoVerRange validVersions;
    private static final GoTypeFlag[] lookupvalues;

    private GoTypeFlag(int i, GoVerRange validVersions) {
        this.value = i;
        this.validVersions = validVersions;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isSet(int i) {
        return (i & this.value) != 0;
    }

    public static boolean isValid(int b, GoVer ver) {
        int maxMask = 0;
        for (GoTypeFlag flag : lookupvalues) {
            if (!flag.validVersions.contains(ver)) continue;
            maxMask |= flag.value;
        }
        return b <= maxMask;
    }

    public static Set<GoTypeFlag> parseFlags(int b) {
        EnumSet<GoTypeFlag> result = EnumSet.noneOf(GoTypeFlag.class);
        for (GoTypeFlag flag : lookupvalues) {
            if (!flag.isSet(b)) continue;
            result.add(flag);
        }
        return result;
    }

    static {
        lookupvalues = GoTypeFlag.values();
    }
}

