/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.List;

public class NList
implements StructConverter {
    private int n_strx;
    private byte n_type;
    private byte n_sect;
    private short n_desc;
    private long n_value;
    private String string;
    private boolean is32bit;

    public NList(BinaryReader reader, boolean is32bit) throws IOException {
        this.is32bit = is32bit;
        this.n_strx = reader.readNextInt();
        this.n_type = reader.readNextByte();
        this.n_sect = reader.readNextByte();
        this.n_desc = reader.readNextShort();
        this.n_value = is32bit ? reader.readNextUnsignedInt() : reader.readNextLong();
    }

    public void initString(BinaryReader reader, long stringTableOffset) {
        this.string = "";
        if (this.n_strx != 0) {
            try {
                this.string = reader.readAsciiString(stringTableOffset + (long)this.n_strx);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("nlist", 0);
        struct.add(DWORD, "n_strx", null);
        struct.add(BYTE, "n_type", null);
        struct.add(BYTE, "n_sect", null);
        struct.add(WORD, "n_desc", null);
        if (this.is32bit) {
            struct.add(DWORD, "n_value", null);
        } else {
            struct.add(QWORD, "n_value", null);
        }
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    public String getString() {
        if (this.string == null) {
            throw new AssertException("initString must be called first");
        }
        return this.string;
    }

    public int getStringTableIndex() {
        return this.n_strx;
    }

    public byte getType() {
        return this.n_type;
    }

    public boolean isTypeUndefined() {
        return this.n_sect == 0 && (this.n_type & 0xE) == 0;
    }

    public boolean isTypeAbsolute() {
        return this.n_sect == 0 && (this.n_type & 0xE) == 2;
    }

    public boolean isTypePreboundUndefined() {
        return this.n_sect == 0 && (this.n_type & 0xE) == 12;
    }

    public boolean isIndirect() {
        return this.n_sect == 0 && (this.n_type & 0xE) == 10;
    }

    public boolean isSymbolicDebugging() {
        return (this.n_type & 0xE0) != 0;
    }

    public boolean isPrivateExternal() {
        return (this.n_type & 0x10) != 0;
    }

    public boolean isExternal() {
        return (this.n_type & 1) != 0;
    }

    public boolean isLazyBind() {
        return (this.n_desc & 7) != 0;
    }

    public boolean isThumbSymbol() {
        return (this.n_desc & 8) != 0;
    }

    public byte getSection() {
        return this.n_sect;
    }

    public short getDescription() {
        return this.n_desc;
    }

    public long getValue() {
        return this.n_value;
    }

    public int getLibraryOrdinal() {
        return this.n_desc >> 8 & 0xFF;
    }

    public boolean is32bit() {
        return this.is32bit;
    }

    public int getSize() {
        return this.is32bit ? 12 : 16;
    }

    public String toString() {
        return this.string;
    }

    public static int getSize(List<NList> nlists) {
        if (!nlists.isEmpty()) {
            int totalStringSize = 1;
            for (NList nlist : nlists) {
                totalStringSize += nlist.getString().length() + 1;
            }
            return nlists.size() * nlists.get(0).getSize() + totalStringSize;
        }
        return 0;
    }
}

