/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec.trace.data;

import ghidra.pcode.exec.trace.data.DefaultPcodeTracePropertyAccess;
import ghidra.pcode.exec.trace.data.InternalPcodeTraceDataAccess;
import ghidra.pcode.exec.trace.data.PcodeTracePropertyAccess;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Language;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.TraceTimeViewport;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryOperations;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.util.TraceRegisterUtils;
import java.nio.ByteBuffer;
import java.util.Iterator;

public abstract class AbstractPcodeTraceDataAccess
implements InternalPcodeTraceDataAccess {
    protected final TracePlatform platform;
    protected final long snap;
    protected final TraceTimeViewport viewport;
    protected final TraceMemoryManager mm;

    public AbstractPcodeTraceDataAccess(TracePlatform platform, long snap, TraceTimeViewport viewport) {
        this.platform = platform;
        this.snap = snap;
        this.viewport = viewport;
        this.mm = platform.getTrace().getMemoryManager();
    }

    @Override
    public TraceTimeViewport getViewport() {
        return this.viewport;
    }

    @Override
    public Language getLanguage() {
        return this.platform.getLanguage();
    }

    @Override
    public TracePlatform getPlatform() {
        return this.platform;
    }

    @Override
    public long getSnap() {
        return this.snap;
    }

    protected abstract TraceMemoryOperations getMemoryOps(boolean var1);

    protected abstract Address toOverlay(Address var1);

    protected abstract AddressRange toOverlay(AddressRange var1);

    protected abstract AddressSetView toOverlay(AddressSetView var1);

    @Override
    public void setState(AddressRange guestRange, TraceMemoryState state) {
        AddressRange hostRange = this.platform.mapGuestToHost(guestRange);
        if (hostRange == null) {
            return;
        }
        TraceMemoryOperations ops = this.getMemoryOps(true);
        if (ops == null) {
            throw new AssertionError((Object)"Cannot get memory operations for writing. This usually indicates a schema issue.");
        }
        ops.setState(this.snap, this.toOverlay(hostRange), state);
    }

    @Override
    public TraceMemoryState getViewportState(AddressRange guestRange) {
        TraceMemoryOperations ops = this.getMemoryOps(false);
        if (ops == null) {
            return TraceMemoryState.UNKNOWN;
        }
        AddressRange hostRange = this.platform.mapGuestToHost(guestRange);
        if (hostRange == null) {
            return TraceMemoryState.UNKNOWN;
        }
        AddressSet hostSet = new AddressSet(this.toOverlay(hostRange));
        for (long snap : this.viewport.getOrderedSnaps()) {
            hostSet.delete(ops.getAddressesWithState(snap, (AddressSetView)hostSet, s -> s == TraceMemoryState.KNOWN));
        }
        return hostSet.isEmpty() ? TraceMemoryState.KNOWN : TraceMemoryState.UNKNOWN;
    }

    @Override
    public AddressSetView intersectViewKnown(AddressSetView guestView, boolean useFullSpans) {
        TraceMemoryOperations ops = this.getMemoryOps(false);
        if (ops == null) {
            return new AddressSet();
        }
        AddressSetView hostView = this.toOverlay(this.platform.mapGuestToHost(guestView));
        AddressSet hostKnown = new AddressSet();
        if (useFullSpans) {
            for (Lifespan span : this.viewport.getOrderedSpans()) {
                hostKnown.add(ops.getAddressesWithState(span, hostView, st -> st != null && st != TraceMemoryState.UNKNOWN));
            }
        } else {
            Iterator<Object> iterator = this.viewport.getOrderedSnaps().iterator();
            while (iterator.hasNext()) {
                long snap = (Long)iterator.next();
                hostKnown.add(ops.getAddressesWithState(snap, hostView, st -> st != null && st != TraceMemoryState.UNKNOWN));
            }
        }
        AddressSetView hostResult = TraceRegisterUtils.getPhysicalSet((AddressSetView)hostView.intersect((AddressSetView)hostKnown));
        return this.platform.mapHostToGuest(hostResult);
    }

    @Override
    public int putBytes(Address start, ByteBuffer buf) {
        Address hostStart = this.platform.mapGuestToHost(start);
        if (hostStart == null) {
            return 0;
        }
        TraceMemoryOperations ops = this.getMemoryOps(true);
        if (ops == null) {
            throw new AssertionError((Object)"Cannot get memory operations for writing. This usually indicates a schema issue or a missing object.");
        }
        return ops.putBytes(this.snap, this.toOverlay(hostStart), buf);
    }

    @Override
    public int getBytes(Address start, ByteBuffer buf) {
        Address hostStart = this.platform.mapGuestToHost(start);
        if (hostStart == null) {
            return 0;
        }
        TraceMemoryOperations ops = this.getMemoryOps(false);
        if (ops == null) {
            int length = buf.remaining();
            buf.position(buf.position() + length);
            return length;
        }
        return ops.getViewBytes(this.snap, this.toOverlay(hostStart), buf);
    }

    @Override
    public Address translate(Address address) {
        Address host = this.platform.mapGuestToHost(address);
        if (host == null) {
            return null;
        }
        return this.toOverlay(host);
    }

    @Override
    public <T> PcodeTracePropertyAccess<T> getPropertyAccess(String name, Class<T> type) {
        return new DefaultPcodeTracePropertyAccess<T>(this, name, type);
    }
}

