/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.filechooser.GhidraFileChooser;
import ghidra.framework.main.FrontEndPlugin;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.main.ImportGhidraToolsDialog;
import ghidra.framework.main.SetToolAssociationsDialog;
import ghidra.framework.main.ToolConnectionDialog;
import ghidra.framework.model.Project;
import ghidra.framework.model.ToolChest;
import ghidra.framework.model.ToolChestChangeListener;
import ghidra.framework.model.ToolManager;
import ghidra.framework.model.ToolSet;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.model.Workspace;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.preferences.Preferences;
import ghidra.framework.project.tool.GhidraToolTemplate;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.xml.XmlUtilities;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import resources.ResourceManager;

class ToolActionManager
implements ToolChestChangeListener {
    private static final int TYPICAL_NUM_TOOLS_IN_TOOLCHEST = 5;
    private static final int NEWTOOL_ACCELERATOR = 84;
    private static final String MENU_ITEM_CREATE_TOOL = "&Create Tool...";
    private static final String MENU_ITEM_RUN_TOOL = "&Run Tool";
    private static final String MENU_ITEM_DELETE_TOOL = "Delete Tool";
    private static final String MENU_ITEM_IMPORT_TOOL = "&Import Tool...";
    private static final String MENU_ITEM_IMPORT_DEFAULT_TOOLS = "Import &Default Tools...";
    private static final String MENU_ITEM_EXPORT_TOOL = "&Export Tool";
    private static final String MENU_ITEM_CONNECT_TOOLS = "Connect &Tools...";
    private static final String MENU_ITEM_SET_DEFAULT_TOOL = "&Set As Default";
    private FrontEndPlugin plugin;
    private FrontEndTool tool;
    private ToolConnectionDialog toolConnectionDialog;
    private DockingAction createToolAction;
    private DockingAction connectToolsAction;
    private DockingAction importAction;
    private DockingAction importDefaultToolsAction;
    private DockingAction setToolAssociationsAction;
    private Map<String, DockingAction> runToolActionMap;
    private Map<String, DockingAction> delToolActionMap;
    private Map<String, DockingAction> exportToolActionMap;

    ToolActionManager(FrontEndPlugin fePlugin) {
        this.plugin = fePlugin;
        this.tool = (FrontEndTool)this.plugin.getTool();
        this.runToolActionMap = new HashMap<String, DockingAction>(5);
        this.delToolActionMap = new HashMap<String, DockingAction>(5);
        this.exportToolActionMap = new HashMap<String, DockingAction>(5);
        this.createActions();
    }

    void enableActions(boolean enabled) {
        this.createToolAction.setEnabled(enabled);
        this.enableConnectTools();
        this.enableActions(this.runToolActionMap, enabled);
        this.enableActions(this.delToolActionMap, enabled);
        this.enableActions(this.exportToolActionMap, enabled);
        this.importAction.setEnabled(enabled);
        this.importDefaultToolsAction.setEnabled(enabled);
        this.setToolAssociationsAction.setEnabled(enabled);
    }

    void updateConnectionDialog() {
        if (this.toolConnectionDialog != null) {
            this.toolConnectionDialog.updateDisplay();
        }
        this.enableConnectTools();
    }

    void setActiveProject(Project activeProject) {
        if (this.toolConnectionDialog != null) {
            if (activeProject != null) {
                this.toolConnectionDialog.setToolManager(activeProject.getToolManager());
            } else if (this.toolConnectionDialog.isVisible()) {
                this.toolConnectionDialog.setVisible(false);
            }
        }
        this.populateToolMenus(activeProject);
    }

    private void createActions() {
        this.createToolAction = new DockingAction("Create Tool", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                ToolActionManager.this.createNewTool();
            }
        };
        this.createToolAction.setKeyBindingData(new KeyBindingData(84, 2));
        this.createToolAction.setMenuBarData(new MenuData(new String[]{"&Tools", MENU_ITEM_CREATE_TOOL}, null, "ATools"));
        this.createToolAction.setEnabled(false);
        this.createToolAction.setHelpLocation(new HelpLocation("Tool", "Create_Tool"));
        this.tool.addAction((DockingActionIf)this.createToolAction);
        this.importAction = new DockingAction("Import Tool", this.plugin.getName()){

            public void actionPerformed(ActionContext e) {
                ToolActionManager.this.importTool();
            }
        };
        this.importAction.setMenuBarData(new MenuData(new String[]{"&Tools", MENU_ITEM_IMPORT_TOOL}, null, "DTools"));
        this.importAction.setHelpLocation(new HelpLocation("Tool", "Import Tool"));
        this.importAction.setEnabled(false);
        this.tool.addAction((DockingActionIf)this.importAction);
        this.importDefaultToolsAction = new DockingAction("Import Ghidra Tools", this.plugin.getName()){

            public void actionPerformed(ActionContext e) {
                ToolActionManager.this.addDefaultTools();
            }
        };
        this.importDefaultToolsAction.setMenuBarData(new MenuData(new String[]{"&Tools", MENU_ITEM_IMPORT_DEFAULT_TOOLS}, null, "DTools"));
        this.importDefaultToolsAction.setHelpLocation(new HelpLocation("Tool", "Import Ghidra Tools"));
        this.importDefaultToolsAction.setEnabled(false);
        this.tool.addAction((DockingActionIf)this.importDefaultToolsAction);
        this.connectToolsAction = new DockingAction("Connect Tools", this.plugin.getName()){

            public void actionPerformed(ActionContext e) {
                ToolActionManager.this.connectTools();
            }
        };
        this.connectToolsAction.setMenuBarData(new MenuData(new String[]{"&Tools", MENU_ITEM_CONNECT_TOOLS}, null, "ETools"));
        this.connectToolsAction.setEnabled(false);
        this.tool.addAction((DockingActionIf)this.connectToolsAction);
        this.setToolAssociationsAction = new DockingAction("Set Tool Associations", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                ToolActionManager.this.showToolAssociationsDialog();
            }
        };
        this.setToolAssociationsAction.setEnabled(false);
        this.setToolAssociationsAction.setMenuBarData(new MenuData(new String[]{"&Tools", "Set Tool Associations..."}, null, "FTools"));
        this.tool.addAction((DockingActionIf)this.setToolAssociationsAction);
        this.setToolAssociationsAction.setHelpLocation(new HelpLocation("Tool", "Set Tool Associations"));
        this.tool.setMenuGroup(new String[]{"&Tools", MENU_ITEM_RUN_TOOL}, "BTools");
        this.tool.setMenuGroup(new String[]{"&Tools", MENU_ITEM_DELETE_TOOL}, "CTools");
        this.tool.setMenuGroup(new String[]{"&Tools", MENU_ITEM_EXPORT_TOOL}, "DTools");
        this.tool.setMenuGroup(new String[]{"&Tools", MENU_ITEM_SET_DEFAULT_TOOL}, "FTools");
        this.populateToolMenus(this.plugin.getActiveProject());
    }

    private void showToolAssociationsDialog() {
        SetToolAssociationsDialog dialog = new SetToolAssociationsDialog(this.tool);
        dialog.showDialog();
    }

    private void addDefaultTools() {
        ImportGhidraToolsDialog dialog = new ImportGhidraToolsDialog(this.tool);
        dialog.showDialog();
        if (dialog.isCancelled()) {
            return;
        }
        List<String> list = dialog.getSelectedList();
        for (String filename : list) {
            this.addDefaultTool(filename);
        }
    }

    private void addDefaultTool(String filename) {
        try {
            InputStream is = ResourceManager.getResourceAsStream((String)filename);
            this.addToolTemplate(is, filename);
        }
        catch (Exception e) {
            Msg.showError((Object)this, null, (String)"Error", (Object)("Error loading default tool: " + filename), (Throwable)e);
        }
    }

    private void enableActions(Map<String, DockingAction> map, boolean enabled) {
        for (String name : map.keySet()) {
            DockingAction action = map.get(name);
            action.setEnabled(enabled);
        }
    }

    private void populateToolMenus(Project activeProject) {
        ToolTemplate[] templates;
        this.removeActions(this.runToolActionMap);
        this.removeActions(this.delToolActionMap);
        this.removeActions(this.exportToolActionMap);
        if (activeProject == null) {
            this.createPlaceHolderActions();
            return;
        }
        for (ToolTemplate template : templates = activeProject.getLocalToolChest().getToolTemplates()) {
            this.addConfig(template);
        }
        if (templates.length == 0) {
            this.createPlaceHolderActions();
        }
    }

    private void removeActions(Map<String, DockingAction> map) {
        for (String toolName : map.keySet()) {
            DockingAction action = map.get(toolName);
            this.tool.removeAction((DockingActionIf)action);
        }
        map.clear();
    }

    private void removeDefaultAction(Map<String, DockingAction> map, String toolName) {
        DockingAction action = map.get(toolName);
        if (action != null) {
            this.tool.removeAction((DockingActionIf)action);
            map.remove(toolName);
        }
    }

    private void connectTools() {
        ToolManager tm = this.plugin.getActiveProject().getToolManager();
        if (this.toolConnectionDialog == null) {
            this.toolConnectionDialog = new ToolConnectionDialog(this.tool, tm);
        } else {
            this.toolConnectionDialog.setToolManager(tm);
        }
        this.toolConnectionDialog.setVisible(true);
    }

    void enableConnectTools() {
        Project project = this.plugin.getActiveProject();
        if (project == null) {
            this.connectToolsAction.setEnabled(false);
            return;
        }
        ToolManager tm = project.getToolManager();
        PluginTool[] runningTools = tm.getRunningTools();
        this.connectToolsAction.setEnabled(runningTools.length > 1);
    }

    private void createNewTool() {
        Workspace ws = this.plugin.getActiveWorkspace();
        PluginTool runningTool = ws.createTool();
        runningTool.showConfig(true, true);
    }

    @Override
    public void toolTemplateAdded(ToolTemplate tc) {
        this.populateToolMenus(this.plugin.getActiveProject());
    }

    @Override
    public void toolSetAdded(ToolSet toolset) {
        ToolChest toolChest = this.plugin.getActiveProject().getLocalToolChest();
        this.toolTemplateAdded(toolChest.getToolTemplate(toolset.getName()));
    }

    @Override
    public void toolRemoved(String toolName) {
        this.removeDefaultAction(this.runToolActionMap, toolName);
        this.removeDefaultAction(this.delToolActionMap, toolName);
        this.removeDefaultAction(this.exportToolActionMap, toolName);
        if (this.runToolActionMap.size() == 0) {
            this.createPlaceHolderActions();
        }
    }

    private void createPlaceHolderActions() {
        String owner = this.plugin.getName();
        DockingAction action = new DockingAction(this, "Run Tool", owner){

            public void actionPerformed(ActionContext context) {
            }
        };
        action.setMenuBarData(new MenuData(new String[]{"&Tools", MENU_ITEM_RUN_TOOL}, null, "BTools"));
        action.setHelpLocation(new HelpLocation("Tool", "Run Tool"));
        action.setEnabled(false);
        this.tool.addAction((DockingActionIf)action);
        this.runToolActionMap.put(action.getName(), action);
        action = new DockingAction(this, MENU_ITEM_DELETE_TOOL, owner){

            public void actionPerformed(ActionContext context) {
            }
        };
        action.setMenuBarData(new MenuData(new String[]{"&Tools", MENU_ITEM_DELETE_TOOL}, null, "CTools"));
        action.setHelpLocation(new HelpLocation("Tool", MENU_ITEM_DELETE_TOOL));
        action.setEnabled(false);
        this.tool.addAction((DockingActionIf)action);
        this.delToolActionMap.put(action.getName(), action);
        action = new DockingAction(this, "Export Tool", owner){

            public void actionPerformed(ActionContext context) {
            }
        };
        action.setMenuBarData(new MenuData(new String[]{"&Tools", MENU_ITEM_EXPORT_TOOL}, null, "DTools"));
        action.setHelpLocation(new HelpLocation("Tool", "Export Tool"));
        action.setEnabled(false);
        this.exportToolActionMap.put(action.getName(), action);
        this.tool.addAction((DockingActionIf)action);
    }

    private void importTool() {
        File dir;
        GhidraFileChooser fileChooser = new GhidraFileChooser((Component)this.tool.getToolFrame());
        fileChooser.setFileFilter((GhidraFileFilter)new ExtensionFileFilter(new String[]{"tool", "tcd"}, "Tools"));
        fileChooser.setTitle("Import Tool");
        fileChooser.setApproveButtonText("Import");
        String importDir = Preferences.getProperty((String)"LastToolImportDirectory");
        if (importDir != null && (dir = new File(importDir)).isDirectory()) {
            fileChooser.setCurrentDirectory(dir);
        }
        fileChooser.rescanCurrentDirectory();
        File selectedFile = fileChooser.getSelectedFile(true);
        fileChooser.dispose();
        if (selectedFile == null) {
            return;
        }
        if (!selectedFile.exists()) {
            Msg.showError((Object)this, null, (String)"Error", (Object)("Tool " + selectedFile.getName() + " doesn't exist!"));
        }
        Preferences.setProperty((String)"LastToolImportDirectory", (String)selectedFile.getParent());
        try {
            this.addToolTemplate(new FileInputStream(selectedFile.getAbsolutePath()), selectedFile.getAbsolutePath());
        }
        catch (Exception e) {
            Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"Error Creating Input Stream", (Object)("Error creating input stream for\n" + selectedFile.getAbsolutePath() + ": " + String.valueOf(e)), (Throwable)e);
        }
    }

    private void addToolTemplate(InputStream instream, String path) {
        try {
            SAXBuilder sax = XmlUtilities.createSecureSAXBuilder((boolean)false, (boolean)false);
            Element root = sax.build(instream).getRootElement();
            GhidraToolTemplate template = new GhidraToolTemplate(root, path);
            if (this.plugin.getActiveProject().getLocalToolChest().addToolTemplate(template)) {
                Msg.info((Object)this, (Object)("Successfully added " + template.getName() + " to project tool chest."));
            } else {
                Msg.warn((Object)this, (Object)("Could not add " + template.getName() + " to project tool chest."));
            }
        }
        catch (Exception e) {
            Msg.showError(this.getClass(), (Component)this.tool.getToolFrame(), (String)"Error Reading Tool", (Object)("Could not read tool: " + String.valueOf(e)), (Throwable)e);
        }
    }

    private void addConfig(ToolTemplate template) {
        String toolName = template.getName();
        ToolAction runAction = new ToolAction(toolName, "Run_Tool"){

            public void actionPerformed(ActionContext context) {
                String name = this.getName();
                Workspace ws = ToolActionManager.this.plugin.getActiveWorkspace();
                ToolChest toolChest = ToolActionManager.this.plugin.getActiveProject().getLocalToolChest();
                ws.runTool(toolChest.getToolTemplate(name));
            }
        };
        runAction.setEnabled(true);
        runAction.setMenuBarData(new MenuData(new String[]{"&Tools", MENU_ITEM_RUN_TOOL, toolName}, null, "BTools"));
        runAction.setHelpLocation(new HelpLocation("Tool", "Run_Tool"));
        this.runToolActionMap.put(toolName, runAction);
        this.tool.addAction((DockingActionIf)runAction);
        ToolAction deleteAction = new ToolAction(toolName, "Delete_Tool"){

            public void actionPerformed(ActionContext context) {
                String name = this.getName();
                if (!ToolActionManager.this.plugin.confirmDelete(name + " from the project tool chest?")) {
                    return;
                }
                ToolChest toolChest = ToolActionManager.this.plugin.getActiveProject().getLocalToolChest();
                toolChest.remove(name);
            }
        };
        deleteAction.setEnabled(true);
        deleteAction.setMenuBarData(new MenuData(new String[]{"&Tools", MENU_ITEM_DELETE_TOOL, toolName}, null, "CTools"));
        deleteAction.setHelpLocation(new HelpLocation("Tool", "Delete_Tool"));
        this.delToolActionMap.put(toolName, deleteAction);
        this.tool.addAction((DockingActionIf)deleteAction);
        ToolAction exportToolAction = new ToolAction(toolName, "Export_Tool"){

            public void actionPerformed(ActionContext context) {
                String name = this.getName();
                ToolChest toolChest = ToolActionManager.this.plugin.getActiveProject().getLocalToolChest();
                ToolActionManager.this.plugin.exportToolConfig(toolChest.getToolTemplate(name), "Tool Menu");
            }
        };
        exportToolAction.setEnabled(true);
        exportToolAction.setMenuBarData(new MenuData(new String[]{"&Tools", MENU_ITEM_EXPORT_TOOL, toolName}, null, "DTools"));
        exportToolAction.setHelpLocation(new HelpLocation("Tool", "Export_Tool"));
        this.exportToolActionMap.put(toolName, exportToolAction);
        this.tool.addAction((DockingActionIf)exportToolAction);
    }

    private abstract class ToolAction
    extends DockingAction {
        private ToolAction(ToolActionManager toolActionManager, String toolName, String helpStr) {
            super(toolName, toolActionManager.plugin.getName(), false);
            this.setHelpLocation(new HelpLocation("FrontEndPlugin", helpStr));
        }
    }
}

