/*
 * Decompiled with CFR 0.152.
 */
package generic.algorithms;

import generic.algorithms.Lcs;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;

public abstract class ReducingLcs<I, T>
extends Lcs<T> {
    private I xSource;
    private I ySource;
    private I x;
    private I y;
    private int startn;
    private int endn;

    public ReducingLcs(I ix, I iy) {
        this.xSource = ix;
        this.ySource = iy;
        this.startn = this.getMatchCountFromStart();
        this.endn = this.getMatchCountFromEnd();
        int endx = this.getEnd(this.xSource);
        int endy = this.getEnd(this.ySource);
        this.x = this.reduce(ix, this.startn, endx);
        this.y = this.reduce(iy, this.startn, endy);
    }

    private int getEnd(I i) {
        int end = this.lengthOf(i) - this.endn;
        if (end <= this.startn) {
            end = this.startn;
        }
        return end;
    }

    protected abstract I reduce(I var1, int var2, int var3);

    protected abstract int lengthOf(I var1);

    protected abstract T valueOf(I var1, int var2);

    @Override
    protected List<T> doGetLcs(TaskMonitor monitor) throws CancelledException {
        int endx;
        List reducedLcs = super.doGetLcs(monitor);
        int size = reducedLcs.size() + this.lengthOf(this.x) + this.lengthOf(this.y);
        ArrayList<T> lcs = new ArrayList<T>(size);
        for (int i = 0; i < this.startn; ++i) {
            monitor.checkCancelled();
            lcs.add(this.valueOf(this.xSource, i));
        }
        lcs.addAll(reducedLcs);
        int length = this.lengthOf(this.xSource);
        for (int i = endx = this.getEnd(this.xSource); i < length; ++i) {
            monitor.checkCancelled();
            lcs.add(this.valueOf(this.xSource, i));
        }
        return lcs;
    }

    @Override
    protected int lengthOfX() {
        return this.lengthOf(this.x);
    }

    @Override
    protected int lengthOfY() {
        return this.lengthOf(this.y);
    }

    @Override
    protected T valueOfX(int index) {
        return this.valueOf(this.x, index - 1);
    }

    @Override
    protected T valueOfY(int index) {
        return this.valueOf(this.y, index - 1);
    }

    @Override
    protected boolean matches(T tx, T ty) {
        return tx.equals(ty);
    }

    private int getMatchCountFromStart() {
        int xl = this.lengthOf(this.xSource);
        int yl = this.lengthOf(this.ySource);
        for (int n = 0; n < xl && n < yl; ++n) {
            T yt;
            T xt = this.valueOf(this.xSource, n);
            if (this.matches(xt, yt = this.valueOf(this.ySource, n))) continue;
            return n;
        }
        return 0;
    }

    private int getMatchCountFromEnd() {
        int xi = this.lengthOf(this.xSource) - 1;
        int n = 0;
        for (int yi = this.lengthOf(this.ySource) - 1; xi >= 0 && yi >= 0; --xi, --yi) {
            T yt;
            T xt = this.valueOf(this.xSource, xi);
            if (!this.matches(xt, yt = this.valueOf(this.ySource, yi))) {
                return n == 0 ? 0 : n - 1;
            }
            ++n;
        }
        return 0;
    }
}

