## What does this MR do and why?

%{first_multiline_commit}

## References

<!--
Include [links](https://handbook.gitlab.com/handbook/communication/#start-with-a-merge-request:~:text=Cross%20link%20issues,alternate%20if%20duplicate.) to any resources that are relevant to this MR.
This will give reviewers and future readers helpful context.
-->

## Screenshots or screen recordings

<!---
Screenshots are required for UI changes, and strongly recommended for all other merge requests.
-->

| Before | After  |
| ------ | ------ |
|        |        |

<!--
OPTIONAL: For responsive UI changes, you can use the viewport size table below.
Delete this table if not needed or delete rows that are not relevant to your changes.

| Viewport size   | Before     | After      |
| ----------------| ---------- | ---------- |
| `xs` (<576px)   |            |            |
| `sm` (>=576px)  |            |            |
| `md` (>=768px)  |            |            |
| `lg` (>=992px)  |            |            |
| `xl` (>=1200px) |            |            |
-->

## How to set up and validate locally

<!--
Numbered steps to set up and validate the change are strongly suggested.

Example:

1. In rails console enable the feature flag
   ```ruby
   Feature.enable(:member_areas_of_focus)
   ```
1. Visit any group or project member pages such as `http://127.0.0.1:3000/groups/flightjs/-/group_members`
1. Click the `invite members` button.
-->

## MR acceptance checklist

Evaluate this MR against the [MR acceptance checklist](https://docs.gitlab.com/development/code_review/#acceptance-checklist).
It helps you analyze changes to reduce risks in quality, performance, reliability, security, and maintainability.

/assign me
