/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirSuspendCallChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirErrorFunction;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirReturnExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReturnSyntaxAndLabelChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirReturnExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReturnExpressionChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isReturnAllowed", "", "targetSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirReturnSyntaxAndLabelChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirReturnSyntaxAndLabelChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReturnSyntaxAndLabelChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n43#2:95\n1761#3,3:96\n*S KotlinDebug\n*F\n+ 1 FirReturnSyntaxAndLabelChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReturnSyntaxAndLabelChecker\n*L\n51#1:95\n51#1:96,3\n*E\n"})
public final class FirReturnSyntaxAndLabelChecker
extends FirExpressionChecker<FirReturnExpression> {
    @NotNull
    public static final FirReturnSyntaxAndLabelChecker INSTANCE = new FirReturnSyntaxAndLabelChecker();

    private FirReturnSyntaxAndLabelChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void check(@NotNull FirReturnExpression expression, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        block18: {
            block14: {
                block17: {
                    block16: {
                        Intrinsics.checkNotNullParameter(expression, "expression");
                        Intrinsics.checkNotNullParameter(context, "context");
                        Intrinsics.checkNotNullParameter(reporter, "reporter");
                        v0 = source = expression.getSource();
                        if ((v0 != null ? v0.getKind() : null) instanceof KtFakeSourceElementKind.ImplicitReturn) {
                            return;
                        }
                        labeledElement = expression.getTarget().getLabeledElement();
                        targetSymbol = labeledElement.getSymbol();
                        if (!(labeledElement instanceof FirErrorFunction)) break block16;
                        var8_7 = ((FirErrorFunction)labeledElement).getDiagnostic();
                        v1 = var8_7 instanceof ConeSimpleDiagnostic != false ? (ConeSimpleDiagnostic)var8_7 : null;
                        if ((v1 != null ? v1.getKind() : null) != DiagnosticKind.NotAFunctionLabel) break block16;
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNOT_A_FUNCTION_LABEL(), (DiagnosticContext)context, null, 8, null);
                        break block17;
                    }
                    if (!(labeledElement instanceof FirErrorFunction)) ** GOTO lbl-1000
                    var8_7 = ((FirErrorFunction)labeledElement).getDiagnostic();
                    v2 = var8_7 instanceof ConeSimpleDiagnostic != false ? (ConeSimpleDiagnostic)var8_7 : null;
                    if ((v2 != null ? v2.getKind() : null) == DiagnosticKind.UnresolvedLabel) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNRESOLVED_LABEL(), (DiagnosticContext)context, null, 8, null);
                    } else if (!this.isReturnAllowed(targetSymbol, context)) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getRETURN_NOT_ALLOWED(), (DiagnosticContext)context, null, 8, null);
                    }
                }
                if (!(targetSymbol instanceof FirAnonymousFunctionSymbol) || ((v3 = (label = ((FirAnonymousFunctionSymbol)targetSymbol).getLabel())) != null && (v3 = v3.getSource()) != null ? v3.getKind() : null) instanceof KtRealSourceElementKind) break block18;
                var10_9 = CollectionsKt.asReversed(context.getCallsOrAssignments());
                for (T var12_12 : var10_9) {
                    it = (FirStatement)var12_12;
                    $i$a$-find-FirReturnSyntaxAndLabelChecker$check$functionCall$1 = false;
                    if (!(it instanceof FirFunctionCall)) ** GOTO lbl-1000
                    v4 = FirReferenceUtilsKt.toResolvedNamedFunctionSymbol$default(((FirFunctionCall)it).getCalleeReference(), false, 1, null);
                    if (Intrinsics.areEqual(v4 != null ? v4.getCallableId() : null, FirSuspendCallChecker.INSTANCE.getKOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID$checkers())) {
                        v5 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v5 = false;
                    }
                    if (!v5) continue;
                    v6 = var12_12;
                    break block14;
                }
                v6 = null;
            }
            functionCall = v6;
            if (functionCall instanceof FirFunctionCall) {
                block15: {
                    $this$arguments$iv = (FirCall)functionCall;
                    $i$f$getArguments = false;
                    $this$any$iv = $this$arguments$iv.getArgumentList().getArguments();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v7 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            it = (FirExpression)element$iv;
                            $i$a$-any-FirReturnSyntaxAndLabelChecker$check$1 = false;
                            if (!(it instanceof FirAnonymousFunctionExpression != false && Intrinsics.areEqual(((FirAnonymousFunctionExpression)it).getAnonymousFunction().getSymbol(), targetSymbol) != false)) continue;
                            v7 = true;
                            break block15;
                        }
                        v7 = false;
                    }
                }
                if (v7) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getRETURN_FOR_BUILT_IN_SUSPEND(), (DiagnosticContext)context, null, 8, null);
                }
            }
        }
        if ((containingDeclaration = CollectionsKt.last(context.getContainingDeclarations())) instanceof FirFunction && ((FirFunction)containingDeclaration).getBody() instanceof FirSingleExpressionBlock) {
            v8 = ((FirFunction)containingDeclaration).getSource();
            if (!Intrinsics.areEqual(v8 != null ? v8.getKind() : null, KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getRETURN_IN_FUNCTION_WITH_EXPRESSION_BODY(), (DiagnosticContext)context, null, 8, null);
            }
        }
    }

    private final boolean isReturnAllowed(FirFunctionSymbol<?> targetSymbol, CheckerContext context) {
        if (CollectionsKt.lastOrNull(context.getContainingDeclarations()) instanceof FirValueParameter) {
            return false;
        }
        for (FirDeclaration containingDeclaration : CollectionsKt.asReversed(context.getContainingDeclarations())) {
            FirDeclaration firDeclaration = containingDeclaration;
            if (firDeclaration instanceof FirClass) {
                return false;
            }
            if (firDeclaration instanceof FirFunction) {
                if (Intrinsics.areEqual(((FirFunction)containingDeclaration).getSymbol(), targetSymbol)) {
                    return true;
                }
                if (containingDeclaration instanceof FirAnonymousFunction) {
                    if (((FirAnonymousFunction)containingDeclaration).getInlineStatus().getReturnAllowed()) continue;
                    return false;
                }
                return false;
            }
            if (firDeclaration instanceof FirProperty) {
                if (((FirProperty)containingDeclaration).isLocal()) continue;
                return false;
            }
            if (!(firDeclaration instanceof FirValueParameter)) continue;
            return true;
        }
        return true;
    }
}

