/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java;

import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.FileFilter;
import java.nio.file.Path;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.incremental.ResourcesTarget;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;

@ApiStatus.Internal
public class ResourceRootDescriptor
extends BuildRootDescriptor {
    @NotNull
    private final File root;
    @NotNull
    public final Path rootFile;
    @NotNull
    private final ResourcesTarget myTarget;
    @NotNull
    private final String myPackagePrefix;
    @NotNull
    private final Set<Path> myExcludes;
    protected final FileFilter myFilterForExcludedPatterns;

    @Deprecated(forRemoval=true)
    public ResourceRootDescriptor(@NotNull File root, @NotNull ResourcesTarget target, @NotNull String packagePrefix, @NotNull Set<Path> excludes) {
        if (root == null) {
            ResourceRootDescriptor.$$$reportNull$$$0(0);
        }
        if (target == null) {
            ResourceRootDescriptor.$$$reportNull$$$0(1);
        }
        if (packagePrefix == null) {
            ResourceRootDescriptor.$$$reportNull$$$0(2);
        }
        if (excludes == null) {
            ResourceRootDescriptor.$$$reportNull$$$0(3);
        }
        this(root, target, packagePrefix, excludes, FileFilters.EVERYTHING);
    }

    public ResourceRootDescriptor(@NotNull File root, @NotNull ResourcesTarget target, @NotNull String packagePrefix, @NotNull Set<Path> excludes, @NotNull FileFilter filterForExcludedPatterns) {
        if (root == null) {
            ResourceRootDescriptor.$$$reportNull$$$0(4);
        }
        if (target == null) {
            ResourceRootDescriptor.$$$reportNull$$$0(5);
        }
        if (packagePrefix == null) {
            ResourceRootDescriptor.$$$reportNull$$$0(6);
        }
        if (excludes == null) {
            ResourceRootDescriptor.$$$reportNull$$$0(7);
        }
        if (filterForExcludedPatterns == null) {
            ResourceRootDescriptor.$$$reportNull$$$0(8);
        }
        this.myPackagePrefix = packagePrefix;
        this.root = root;
        this.rootFile = root.toPath().toAbsolutePath().normalize();
        this.myTarget = target;
        this.myExcludes = excludes;
        this.myFilterForExcludedPatterns = filterForExcludedPatterns;
    }

    @Override
    @NotNull
    public File getRootFile() {
        File file = this.root;
        if (file == null) {
            ResourceRootDescriptor.$$$reportNull$$$0(9);
        }
        return file;
    }

    @Override
    @NotNull
    public Set<Path> getExcludedRoots() {
        Set<Path> set = this.myExcludes;
        if (set == null) {
            ResourceRootDescriptor.$$$reportNull$$$0(10);
        }
        return set;
    }

    @NotNull
    public ResourcesTarget getTarget() {
        ResourcesTarget resourcesTarget = this.myTarget;
        if (resourcesTarget == null) {
            ResourceRootDescriptor.$$$reportNull$$$0(11);
        }
        return resourcesTarget;
    }

    @NotNull
    public String getPackagePrefix() {
        String string = this.myPackagePrefix;
        if (string == null) {
            ResourceRootDescriptor.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    @NotNull
    public FileFilter createFileFilter() {
        JpsProject project = this.getTarget().getModule().getProject();
        JpsCompilerExcludes excludes = JpsJavaExtensionService.getInstance().getCompilerConfiguration(project).getCompilerExcludes();
        FileFilter fileFilter = file -> !excludes.isExcluded(file) && this.myFilterForExcludedPatterns.accept(file);
        if (fileFilter == null) {
            ResourceRootDescriptor.$$$reportNull$$$0(13);
        }
        return fileFilter;
    }

    public String toString() {
        return "ResourceRootDescriptor{target='" + String.valueOf(this.myTarget) + "', root=" + String.valueOf(this.root) + "}";
    }

    @Override
    @NotNull
    public String getRootId() {
        String string = FileUtilRt.toSystemIndependentName((String)this.root.getPath());
        if (string == null) {
            ResourceRootDescriptor.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packagePrefix";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterForExcludedPatterns";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/builders/java/ResourceRootDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/builders/java/ResourceRootDescriptor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedRoots";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagePrefix";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileFilter";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

