/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.syncContributor;

import com.intellij.gradle.toolingExtension.modelAction.GradleModelFetchPhase;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.impl.UnloadedModulesListStorage;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.WorkspaceModelKt;
import com.intellij.platform.workspace.jps.UnloadedModulesNameHolder;
import com.intellij.platform.workspace.jps.entities.ContentRootEntity;
import com.intellij.platform.workspace.jps.entities.InheritedSdkDependency;
import com.intellij.platform.workspace.jps.entities.ModuleDependencyItem;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.ModuleSourceDependency;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.impl.url.VirtualFileUrlImplKt;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.service.syncAction.GradleSyncContributor;
import org.jetbrains.plugins.gradle.service.syncContributor.entitites.GradleLinkedProjectEntitySource;

@Order(value=0)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\nJ&\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u001b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/gradle/service/syncContributor/GradleProjectRootSyncContributor;", "Lorg/jetbrains/plugins/gradle/service/syncAction/GradleSyncContributor;", "<init>", "()V", "onResolveProjectInfoStarted", "", "context", "Lorg/jetbrains/plugins/gradle/service/project/ProjectResolverContext;", "storage", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "(Lorg/jetbrains/plugins/gradle/service/project/ProjectResolverContext;Lcom/intellij/platform/workspace/storage/MutableEntityStorage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onModelFetchPhaseCompleted", "phase", "Lcom/intellij/gradle/toolingExtension/modelAction/GradleModelFetchPhase;", "(Lorg/jetbrains/plugins/gradle/service/project/ProjectResolverContext;Lcom/intellij/platform/workspace/storage/MutableEntityStorage;Lcom/intellij/gradle/toolingExtension/modelAction/GradleModelFetchPhase;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "configureProjectRoot", "isConflictedContentRootEntity", "", "contentRootEntity", "Lcom/intellij/platform/workspace/jps/entities/ContentRootEntity;", "entitySource", "Lorg/jetbrains/plugins/gradle/service/syncContributor/entitites/GradleLinkedProjectEntitySource;", "isUnloadedModule", "project", "Lcom/intellij/openapi/project/Project;", "addModuleEntity", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity$Builder;", "addContentRootEntity", "moduleEntity", "resolveModuleName", "", "removeProjectRoot", "intellij.gradle"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nGradleProjectRootSyncContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleProjectRootSyncContributor.kt\norg/jetbrains/plugins/gradle/service/syncContributor/GradleProjectRootSyncContributor\n+ 2 EntityStorage.kt\ncom/intellij/platform/workspace/storage/EntityStorageKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,137:1\n59#2:138\n1255#3,2:139\n*S KotlinDebug\n*F\n+ 1 GradleProjectRootSyncContributor.kt\norg/jetbrains/plugins/gradle/service/syncContributor/GradleProjectRootSyncContributor\n*L\n48#1:138\n49#1:139,2\n*E\n"})
public final class GradleProjectRootSyncContributor
implements GradleSyncContributor {
    @Override
    @Nullable
    public Object onResolveProjectInfoStarted(@NotNull ProjectResolverContext context, @NotNull MutableEntityStorage storage, @NotNull Continuation<? super Unit> $completion) {
        if (context.isPhasedSyncEnabled()) {
            this.configureProjectRoot(context, storage);
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object onModelFetchPhaseCompleted(@NotNull ProjectResolverContext context, @NotNull MutableEntityStorage storage, @NotNull GradleModelFetchPhase phase, @NotNull Continuation<? super Unit> $completion) {
        if (context.isPhasedSyncEnabled() && phase == GradleModelFetchPhase.PROJECT_LOADED_PHASE) {
            this.removeProjectRoot(context, storage);
        }
        return Unit.INSTANCE;
    }

    private final void configureProjectRoot(ProjectResolverContext context, MutableEntityStorage storage) {
        boolean bl;
        GradleLinkedProjectEntitySource linkedProjectEntitySource;
        Project project;
        block3: {
            Sequence contentRootEntities;
            project = context.getProject();
            VirtualFileUrlManager virtualFileUrlManager = WorkspaceModelKt.getWorkspaceModel((Project)project).getVirtualFileUrlManager();
            Path linkedProjectRootPath = Path.of(context.getProjectPath(), new String[0]);
            Intrinsics.checkNotNull((Object)linkedProjectRootPath);
            VirtualFileUrl linkedProjectRootUrl = VirtualFileUrlImplKt.toVirtualFileUrl((Path)linkedProjectRootPath, (VirtualFileUrlManager)virtualFileUrlManager);
            linkedProjectEntitySource = new GradleLinkedProjectEntitySource(linkedProjectRootUrl);
            EntityStorage $this$entities$iv = (EntityStorage)storage;
            boolean $i$f$entities = false;
            Sequence $this$any$iv = contentRootEntities = $this$entities$iv.entities(ContentRootEntity.class);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ContentRootEntity it = (ContentRootEntity)element$iv;
                boolean bl2 = false;
                if (!this.isConflictedContentRootEntity(it, linkedProjectEntitySource)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        if (bl) {
            return;
        }
        if (this.isUnloadedModule(project, linkedProjectEntitySource)) {
            return;
        }
        this.configureProjectRoot(storage, linkedProjectEntitySource);
    }

    private final boolean isConflictedContentRootEntity(ContentRootEntity contentRootEntity, GradleLinkedProjectEntitySource entitySource) {
        return Intrinsics.areEqual((Object)contentRootEntity.getEntitySource(), (Object)entitySource) || Intrinsics.areEqual((Object)contentRootEntity.getUrl(), (Object)entitySource.getProjectRootUrl());
    }

    private final boolean isUnloadedModule(Project project, GradleLinkedProjectEntitySource entitySource) {
        UnloadedModulesListStorage unloadedModulesListStorage = UnloadedModulesListStorage.getInstance((Project)project);
        UnloadedModulesNameHolder unloadedModulesNameHolder = unloadedModulesListStorage.getUnloadedModuleNameHolder();
        Intrinsics.checkNotNullExpressionValue((Object)unloadedModulesNameHolder, (String)"getUnloadedModuleNameHolder(...)");
        UnloadedModulesNameHolder unloadedModuleNameHolder = unloadedModulesNameHolder;
        String moduleName = this.resolveModuleName(entitySource);
        return unloadedModuleNameHolder.isUnloaded(moduleName);
    }

    private final void configureProjectRoot(MutableEntityStorage storage, GradleLinkedProjectEntitySource entitySource) {
        ModuleEntity.Builder moduleEntity = this.addModuleEntity(storage, entitySource);
        this.addContentRootEntity(storage, entitySource, moduleEntity);
    }

    private final ModuleEntity.Builder addModuleEntity(MutableEntityStorage storage, GradleLinkedProjectEntitySource entitySource) {
        String moduleName = this.resolveModuleName(entitySource);
        ModuleEntity.Companion companion = ModuleEntity.Companion;
        Object[] objectArray = new ModuleDependencyItem[]{InheritedSdkDependency.INSTANCE, ModuleSourceDependency.INSTANCE};
        List list = CollectionsKt.listOf((Object[])objectArray);
        ModuleEntity.Builder moduleEntity = ModuleEntity.Companion.create$default((ModuleEntity.Companion)companion, (String)moduleName, (List)list, (EntitySource)entitySource, null, (int)8, null);
        storage.addEntity((WorkspaceEntity.Builder)moduleEntity);
        return moduleEntity;
    }

    private final void addContentRootEntity(MutableEntityStorage storage, GradleLinkedProjectEntitySource entitySource, ModuleEntity.Builder moduleEntity) {
        ContentRootEntity.Companion companion = ContentRootEntity.Companion;
        VirtualFileUrl virtualFileUrl = entitySource.getProjectRootUrl();
        List list = CollectionsKt.emptyList();
        storage.addEntity((WorkspaceEntity.Builder)companion.create(virtualFileUrl, list, (EntitySource)entitySource, arg_0 -> GradleProjectRootSyncContributor.addContentRootEntity$lambda$1(moduleEntity, arg_0)));
    }

    private final String resolveModuleName(GradleLinkedProjectEntitySource entitySource) {
        String string = entitySource.getProjectRootUrl().getFileName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
        return string;
    }

    private final void removeProjectRoot(ProjectResolverContext context, MutableEntityStorage storage) {
        Project project = context.getProject();
        VirtualFileUrlManager virtualFileUrlManager = WorkspaceModelKt.getWorkspaceModel((Project)project).getVirtualFileUrlManager();
        Path linkedProjectRootPath = Path.of(context.getProjectPath(), new String[0]);
        Intrinsics.checkNotNull((Object)linkedProjectRootPath);
        VirtualFileUrl linkedProjectRootUrl = VirtualFileUrlImplKt.toVirtualFileUrl((Path)linkedProjectRootPath, (VirtualFileUrlManager)virtualFileUrlManager);
        GradleLinkedProjectEntitySource linkedProjectEntitySource = new GradleLinkedProjectEntitySource(linkedProjectRootUrl);
        Sequence linkedProjectEntities = storage.entitiesBySource(arg_0 -> GradleProjectRootSyncContributor.removeProjectRoot$lambda$2(linkedProjectEntitySource, arg_0));
        for (WorkspaceEntity linkedProjectEntity : SequencesKt.toList((Sequence)linkedProjectEntities)) {
            storage.removeEntity(linkedProjectEntity);
        }
    }

    private static final Unit addContentRootEntity$lambda$1(ModuleEntity.Builder $moduleEntity, ContentRootEntity.Builder $this$ContentRootEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$ContentRootEntity, (String)"$this$ContentRootEntity");
        $this$ContentRootEntity.setModule($moduleEntity);
        return Unit.INSTANCE;
    }

    private static final boolean removeProjectRoot$lambda$2(GradleLinkedProjectEntitySource $linkedProjectEntitySource, EntitySource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it, (Object)$linkedProjectEntitySource);
    }
}

