/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tests.bazel;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class SafeXml {
    public static boolean isLegalCharacter(int codePoint) {
        return codePoint == 9 || codePoint == 10 || codePoint == 13 || codePoint >= 32 && codePoint <= 55295 || codePoint >= 57344 && codePoint <= 65533 || codePoint >= 65536 && codePoint <= 0x10FFFF;
    }

    public static String escapeIllegalCharacters(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        text.codePoints().forEach(codePoint -> {
            if (SafeXml.isLegalCharacter(codePoint)) {
                result.appendCodePoint(codePoint);
            } else {
                result.append("&#").append(codePoint).append(';');
            }
        });
        return result.toString();
    }

    public static void writeTextElement(XMLStreamWriter xml, String elementName, String text) throws XMLStreamException {
        if (text == null) {
            return;
        }
        xml.writeStartElement(elementName);
        SafeXml.writeCData(xml, text);
        xml.writeEndElement();
    }

    public static void writeCData(XMLStreamWriter xml, String text) throws XMLStreamException {
        if (text == null) {
            return;
        }
        xml.writeCData(SafeXml.escapeIllegalCharacters(text.replace("]]>", "]]]]><![CDATA[>")));
    }
}

