/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.hashing.AbstractHashStream128;
import com.dynatrace.hash4j.hashing.AbstractHasher128;
import com.dynatrace.hash4j.hashing.ByteAccess;
import com.dynatrace.hash4j.hashing.HashStream128;
import com.dynatrace.hash4j.hashing.HashUtil;
import com.dynatrace.hash4j.hashing.HashValue128;
import com.dynatrace.hash4j.hashing.Hasher128;
import com.dynatrace.hash4j.internal.ByteArrayUtil;
import com.dynatrace.hash4j.internal.Preconditions;

final class Murmur3_128
implements AbstractHasher128 {
    private static final long C1 = -8663945395140668459L;
    private static final long C2 = 5545529020109919103L;
    private static final Hasher128 DEFAULT_HASHER_INSTANCE = Murmur3_128.create(0);
    private final long seed;

    static Hasher128 create() {
        return DEFAULT_HASHER_INSTANCE;
    }

    static Hasher128 create(int seed) {
        return new Murmur3_128(seed);
    }

    private static long fmix64(long k) {
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }

    private static long mixK1(long k1) {
        k1 *= -8663945395140668459L;
        k1 = Long.rotateLeft(k1, 31);
        return k1 *= 5545529020109919103L;
    }

    private static long mixK2(long k2) {
        k2 *= 5545529020109919103L;
        k2 = Long.rotateLeft(k2, 33);
        return k2 *= -8663945395140668459L;
    }

    private static long mixH1(long h1, long h2) {
        h1 = Long.rotateLeft(h1, 27);
        return (h1 += h2) * 5L + 1390208809L;
    }

    private static long mixH2(long h1, long h2) {
        h2 = Long.rotateLeft(h2, 31);
        return (h2 += h1) * 5L + 944331445L;
    }

    private static HashValue128 finalizeHash(long h1, long h2, long byteCount) {
        h1 ^= byteCount;
        h1 += (h2 ^= byteCount);
        h2 += h1;
        h1 = Murmur3_128.fmix64(h1);
        h2 = Murmur3_128.fmix64(h2);
        h1 += h2;
        return new HashValue128(h2 += h1, h1);
    }

    private static long finalizeHashToLong(long h1, long h2, long byteCount) {
        h1 ^= byteCount;
        h1 += (h2 ^= byteCount);
        h2 += h1;
        h1 = Murmur3_128.fmix64(h1);
        h2 = Murmur3_128.fmix64(h2);
        return h1 + h2;
    }

    public Murmur3_128(int seed) {
        this.seed = (long)seed & 0xFFFFFFFFL;
    }

    @Override
    public HashStream128 hashStream() {
        return new HashStreamImpl();
    }

    @Override
    public HashValue128 hashBytesTo128Bits(byte[] input, int off, int len) {
        int nblocks = len >>> 4;
        long h1 = this.seed;
        long h2 = this.seed;
        int i = 0;
        while (i < nblocks) {
            long k1 = ByteArrayUtil.getLong(input, off);
            long k2 = ByteArrayUtil.getLong(input, off + 8);
            h1 ^= Murmur3_128.mixK1(k1);
            h1 = Murmur3_128.mixH1(h1, h2);
            h2 ^= Murmur3_128.mixK2(k2);
            h2 = Murmur3_128.mixH2(h1, h2);
            ++i;
            off += 16;
        }
        long k1 = 0L;
        long k2 = 0L;
        switch (len & 0xF) {
            case 15: {
                k2 ^= ((long)input[off + 14] & 0xFFL) << 48;
            }
            case 14: {
                k2 ^= ((long)input[off + 13] & 0xFFL) << 40;
            }
            case 13: {
                k2 ^= ((long)input[off + 12] & 0xFFL) << 32;
            }
            case 12: {
                k2 ^= ((long)input[off + 11] & 0xFFL) << 24;
            }
            case 11: {
                k2 ^= ((long)input[off + 10] & 0xFFL) << 16;
            }
            case 10: {
                k2 ^= ((long)input[off + 9] & 0xFFL) << 8;
            }
            case 9: {
                h2 ^= Murmur3_128.mixK2(k2 ^= (long)input[off + 8] & 0xFFL);
            }
            case 8: {
                k1 ^= (long)input[off + 7] << 56;
            }
            case 7: {
                k1 ^= ((long)input[off + 6] & 0xFFL) << 48;
            }
            case 6: {
                k1 ^= ((long)input[off + 5] & 0xFFL) << 40;
            }
            case 5: {
                k1 ^= ((long)input[off + 4] & 0xFFL) << 32;
            }
            case 4: {
                k1 ^= ((long)input[off + 3] & 0xFFL) << 24;
            }
            case 3: {
                k1 ^= ((long)input[off + 2] & 0xFFL) << 16;
            }
            case 2: {
                k1 ^= ((long)input[off + 1] & 0xFFL) << 8;
            }
            case 1: {
                h1 ^= Murmur3_128.mixK1(k1 ^= (long)input[off] & 0xFFL);
            }
        }
        return Murmur3_128.finalizeHash(h1, h2, len);
    }

    @Override
    public <T> HashValue128 hashBytesTo128Bits(T input, long off, long len, ByteAccess<T> access) {
        long nblocks = len >>> 4;
        long h1 = this.seed;
        long h2 = this.seed;
        long i = 0L;
        while (i < nblocks) {
            long k1 = access.getLong(input, off);
            long k2 = access.getLong(input, off + 8L);
            h1 ^= Murmur3_128.mixK1(k1);
            h1 = Murmur3_128.mixH1(h1, h2);
            h2 ^= Murmur3_128.mixK2(k2);
            h2 = Murmur3_128.mixH2(h1, h2);
            ++i;
            off += 16L;
        }
        long k1 = 0L;
        long k2 = 0L;
        switch ((int)(len & 0xFL)) {
            case 15: {
                k2 ^= access.getByteAsUnsignedLong(input, off + 14L) << 48;
            }
            case 14: {
                k2 ^= access.getByteAsUnsignedLong(input, off + 13L) << 40;
            }
            case 13: {
                k2 ^= access.getByteAsUnsignedLong(input, off + 12L) << 32;
            }
            case 12: {
                k2 ^= access.getByteAsUnsignedLong(input, off + 11L) << 24;
            }
            case 11: {
                k2 ^= access.getByteAsUnsignedLong(input, off + 10L) << 16;
            }
            case 10: {
                k2 ^= access.getByteAsUnsignedLong(input, off + 9L) << 8;
            }
            case 9: {
                h2 ^= Murmur3_128.mixK2(k2 ^= access.getByteAsUnsignedLong(input, off + 8L));
            }
            case 8: {
                k1 ^= (long)access.getByte(input, off + 7L) << 56;
            }
            case 7: {
                k1 ^= access.getByteAsUnsignedLong(input, off + 6L) << 48;
            }
            case 6: {
                k1 ^= access.getByteAsUnsignedLong(input, off + 5L) << 40;
            }
            case 5: {
                k1 ^= access.getByteAsUnsignedLong(input, off + 4L) << 32;
            }
            case 4: {
                k1 ^= access.getByteAsUnsignedLong(input, off + 3L) << 24;
            }
            case 3: {
                k1 ^= access.getByteAsUnsignedLong(input, off + 2L) << 16;
            }
            case 2: {
                k1 ^= access.getByteAsUnsignedLong(input, off + 1L) << 8;
            }
            case 1: {
                h1 ^= Murmur3_128.mixK1(k1 ^= access.getByteAsUnsignedLong(input, off));
            }
        }
        return Murmur3_128.finalizeHash(h1, h2, len);
    }

    @Override
    public HashValue128 hashCharsTo128Bits(CharSequence s) {
        int i;
        long h1 = this.seed;
        long h2 = this.seed;
        int len = s.length();
        for (i = 0; i <= len - 8; i += 8) {
            long b0 = ByteArrayUtil.getLong(s, i);
            long b1 = ByteArrayUtil.getLong(s, i + 4);
            h1 ^= Murmur3_128.mixK1(b0);
            h1 = Murmur3_128.mixH1(h1, h2);
            h2 ^= Murmur3_128.mixK2(b1);
            h2 = Murmur3_128.mixH2(h1, h2);
        }
        if (i < len) {
            long buffer0 = s.charAt(i);
            if (i + 1 < len) {
                buffer0 |= (long)s.charAt(i + 1) << 16;
                if (i + 2 < len) {
                    buffer0 |= (long)s.charAt(i + 2) << 32;
                    if (i + 3 < len) {
                        buffer0 |= (long)s.charAt(i + 3) << 48;
                        if (i + 4 < len) {
                            long buffer1 = s.charAt(i + 4);
                            if (i + 5 < len) {
                                buffer1 |= (long)s.charAt(i + 5) << 16;
                                if (i + 6 < len) {
                                    buffer1 |= (long)s.charAt(i + 6) << 32;
                                }
                            }
                            h2 ^= Murmur3_128.mixK2(buffer1);
                        }
                    }
                }
            }
            h1 ^= Murmur3_128.mixK1(buffer0);
        }
        return Murmur3_128.finalizeHash(h1, h2, (long)len << 1);
    }

    @Override
    public long hashIntToLong(int v) {
        return Murmur3_128.finalizeHashToLong(this.seed ^ Murmur3_128.mixK1((long)v & 0xFFFFFFFFL), this.seed, 4L);
    }

    @Override
    public long hashIntIntIntToLong(int v1, int v2, int v3) {
        return this.finish12Bytes((long)v3 & 0xFFFFFFFFL, (long)v1 & 0xFFFFFFFFL | (long)v2 << 32);
    }

    @Override
    public long hashIntLongToLong(int v1, long v2) {
        return this.finish12Bytes(v2 >>> 32, (long)v1 & 0xFFFFFFFFL | v2 << 32);
    }

    @Override
    public long hashLongToLong(long v) {
        return Murmur3_128.finalizeHashToLong(this.seed ^ Murmur3_128.mixK1(v), this.seed, 8L);
    }

    @Override
    public long hashLongLongToLong(long v1, long v2) {
        long h1 = this.seed;
        long h2 = this.seed;
        h1 ^= Murmur3_128.mixK1(v1);
        h1 = Murmur3_128.mixH1(h1, h2);
        h2 ^= Murmur3_128.mixK2(v2);
        h2 = Murmur3_128.mixH2(h1, h2);
        return Murmur3_128.finalizeHashToLong(h1, h2, 16L);
    }

    @Override
    public long hashLongLongLongToLong(long v1, long v2, long v3) {
        long h1 = this.seed;
        long h2 = this.seed;
        h1 ^= Murmur3_128.mixK1(v1);
        h1 = Murmur3_128.mixH1(h1, h2);
        h2 ^= Murmur3_128.mixK2(v2);
        h2 = Murmur3_128.mixH2(h1, h2);
        return Murmur3_128.finalizeHashToLong(h1 ^= Murmur3_128.mixK1(v3), h2, 24L);
    }

    @Override
    public long hashLongIntToLong(long v1, int v2) {
        return this.finish12Bytes((long)v2 & 0xFFFFFFFFL, v1);
    }

    private long finish12Bytes(long a, long b) {
        long h1 = this.seed;
        long h2 = this.seed;
        return Murmur3_128.finalizeHashToLong(h1 ^= Murmur3_128.mixK1(b), h2 ^= Murmur3_128.mixK2(a & 0xFFFFFFFFL), 12L);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Murmur3_128)) {
            return false;
        }
        Murmur3_128 that = (Murmur3_128)obj;
        return this.seed == that.seed;
    }

    public int hashCode() {
        return Long.hashCode(this.seed);
    }

    private class HashStreamImpl
    implements AbstractHashStream128 {
        private long h1;
        private long h2;
        private long buffer0;
        private long buffer1;
        private long byteCount;
        private static final byte SERIAL_VERSION_V0 = 0;

        private HashStreamImpl() {
            this.h1 = Murmur3_128.this.seed;
            this.h2 = Murmur3_128.this.seed;
            this.buffer0 = 0L;
            this.buffer1 = 0L;
            this.byteCount = 0L;
        }

        public int hashCode() {
            return this.getAsInt();
        }

        public boolean equals(Object obj) {
            return HashUtil.equalsHelper(this, obj);
        }

        @Override
        public HashStream128 reset() {
            this.h1 = Murmur3_128.this.seed;
            this.h2 = Murmur3_128.this.seed;
            this.buffer0 = 0L;
            this.buffer1 = 0L;
            this.byteCount = 0L;
            return this;
        }

        @Override
        public Hasher128 getHasher() {
            return Murmur3_128.this;
        }

        @Override
        public byte[] getState() {
            int numBufferBytes = (int)(this.byteCount & 0xFL);
            byte[] state = new byte[9 + (this.byteCount < 0L || this.byteCount >= 16L ? 16 : 0) + numBufferBytes];
            state[0] = 0;
            int off = 1;
            ByteArrayUtil.setLong(state, off, this.byteCount);
            off += 8;
            if (this.byteCount < 0L || this.byteCount >= 16L) {
                ByteArrayUtil.setLong(state, off, this.h1);
                ByteArrayUtil.setLong(state, off += 8, this.h2);
                off += 8;
            }
            if (numBufferBytes >= 8) {
                ByteArrayUtil.setLong(state, off, this.buffer0);
                off += 8;
            }
            for (int i = 0; i < (numBufferBytes & 7); ++i) {
                state[off++] = (byte)(this.buffer1 >>> (i << 3));
            }
            return state;
        }

        @Override
        public HashStream128 setState(byte[] state) {
            Preconditions.checkArgument(state != null);
            Preconditions.checkArgument(state.length >= 9);
            Preconditions.checkArgument(state[0] == 0);
            int off = 1;
            this.byteCount = ByteArrayUtil.getLong(state, off);
            off += 8;
            int numBufferBytes = (int)(this.byteCount & 0xFL);
            Preconditions.checkArgument(state.length == 9 + (this.byteCount < 0L || this.byteCount >= 16L ? 16 : 0) + numBufferBytes);
            if (this.byteCount < 0L || this.byteCount >= 16L) {
                this.h1 = ByteArrayUtil.getLong(state, off);
                this.h2 = ByteArrayUtil.getLong(state, off += 8);
                off += 8;
            } else {
                this.h1 = Murmur3_128.this.seed;
                this.h2 = Murmur3_128.this.seed;
            }
            if (numBufferBytes >= 8) {
                this.buffer0 = ByteArrayUtil.getLong(state, off);
                off += 8;
            } else {
                this.buffer0 = 0L;
            }
            this.buffer1 = 0L;
            for (int i = 0; i < (numBufferBytes & 7); ++i) {
                this.buffer1 |= ((long)state[off++] & 0xFFL) << (i << 3);
            }
            return this;
        }

        @Override
        public HashStream128 putByte(byte b) {
            this.buffer1 |= ((long)b & 0xFFL) << (int)(this.byteCount << 3);
            if ((this.byteCount & 7L) == 7L) {
                if ((this.byteCount & 8L) != 0L) {
                    this.processBuffer(this.buffer0, this.buffer1);
                }
                this.buffer0 = this.buffer1;
                this.buffer1 = 0L;
            }
            ++this.byteCount;
            return this;
        }

        @Override
        public HashStream128 putShort(short v) {
            return this.putTwoBytes((long)v & 0xFFFFL);
        }

        @Override
        public HashStream128 putChar(char v) {
            return this.putTwoBytes(v);
        }

        private HashStream128 putTwoBytes(long l) {
            this.buffer1 |= l << (int)(this.byteCount << 3);
            if ((this.byteCount & 6L) == 6L) {
                if ((this.byteCount & 8L) != 0L) {
                    this.processBuffer(this.buffer0, this.buffer1);
                }
                this.buffer0 = this.buffer1;
                this.buffer1 = l >>> (int)(-(this.byteCount << 3));
            }
            this.byteCount += 2L;
            return this;
        }

        @Override
        public HashStream128 putInt(int v) {
            long l = (long)v & 0xFFFFFFFFL;
            this.buffer1 |= l << (int)(this.byteCount << 3);
            if ((this.byteCount & 4L) != 0L) {
                if ((this.byteCount & 8L) != 0L) {
                    this.processBuffer(this.buffer0, this.buffer1);
                }
                this.buffer0 = this.buffer1;
                this.buffer1 = l >>> (int)(-(this.byteCount << 3));
            }
            this.byteCount += 4L;
            return this;
        }

        @Override
        public HashStream128 putLong(long l) {
            this.buffer1 |= l << (int)(this.byteCount << 3);
            if ((this.byteCount & 8L) != 0L) {
                this.processBuffer(this.buffer0, this.buffer1);
            }
            this.buffer0 = this.buffer1;
            this.buffer1 = l >>> 1 >>> (int)(this.byteCount << 3 ^ 0xFFFFFFFFFFFFFFFFL);
            this.byteCount += 8L;
            return this;
        }

        @Override
        public HashStream128 putBytes(byte[] b, int off, int len) {
            int bufferOffset = (int)this.byteCount;
            int bitOffset = bufferOffset << 3;
            int regularBlockStartIdx = -bufferOffset & 0xF;
            int regularBlockEndIdx = len - (len + bufferOffset & 0xF);
            this.byteCount += (long)len;
            if (regularBlockEndIdx < regularBlockStartIdx) {
                int z = -bufferOffset & 7;
                if (len < z) {
                    for (int x = 0; x < len; ++x) {
                        this.buffer1 |= ((long)b[off + x] & 0xFFL) << (x + bufferOffset << 3);
                    }
                } else {
                    int x;
                    if (0 < z) {
                        for (x = 0; x < z; ++x) {
                            this.buffer1 |= ((long)b[off + x] & 0xFFL) << (x + bufferOffset << 3);
                        }
                        this.buffer0 = this.buffer1;
                        this.buffer1 = 0L;
                    }
                    for (x = z; x < len; ++x) {
                        this.buffer1 |= ((long)b[off + x] & 0xFFL) << (x + bufferOffset << 3);
                    }
                }
                return this;
            }
            if (regularBlockStartIdx > 0) {
                if (regularBlockStartIdx >= 8) {
                    if (regularBlockStartIdx > 8) {
                        this.buffer0 = this.buffer1 | ByteArrayUtil.getLong(b, off) << bitOffset;
                    }
                    this.buffer1 = ByteArrayUtil.getLong(b, off + regularBlockStartIdx - 8);
                } else if (len >= 8) {
                    this.buffer1 |= ByteArrayUtil.getLong(b, off) << bitOffset;
                } else if (regularBlockStartIdx >= 4) {
                    if (regularBlockStartIdx >= 5) {
                        if (regularBlockStartIdx >= 6) {
                            if (regularBlockStartIdx >= 7) {
                                this.buffer1 |= ((long)b[off + regularBlockStartIdx - 7] & 0xFFL) << 8;
                            }
                            this.buffer1 |= ((long)b[off + regularBlockStartIdx - 6] & 0xFFL) << 16;
                        }
                        this.buffer1 |= ((long)b[off + regularBlockStartIdx - 5] & 0xFFL) << 24;
                    }
                    this.buffer1 |= (long)ByteArrayUtil.getInt(b, off + regularBlockStartIdx - 4) << 32;
                } else {
                    if (regularBlockStartIdx >= 2) {
                        if (regularBlockStartIdx >= 3) {
                            this.buffer1 |= ((long)b[off + regularBlockStartIdx - 3] & 0xFFL) << 40;
                        }
                        this.buffer1 |= ((long)b[off + regularBlockStartIdx - 2] & 0xFFL) << 48;
                    }
                    this.buffer1 |= (long)b[off + regularBlockStartIdx - 1] << 56;
                }
                this.processBuffer(this.buffer0, this.buffer1);
                this.buffer1 = 0L;
            }
            for (int i = regularBlockStartIdx; i < regularBlockEndIdx; i += 16) {
                long b0 = ByteArrayUtil.getLong(b, off + i);
                long b1 = ByteArrayUtil.getLong(b, off + i + 8);
                this.processBuffer(b0, b1);
            }
            int remainingBytes = len - regularBlockEndIdx;
            int offLen = off + len;
            if (remainingBytes > 0) {
                if (remainingBytes >= 8) {
                    if (remainingBytes > 8) {
                        this.buffer1 = ByteArrayUtil.getLong(b, offLen - 8) >>> -(remainingBytes << 3);
                    }
                    this.buffer0 = ByteArrayUtil.getLong(b, offLen - remainingBytes);
                } else if (len >= 8) {
                    this.buffer1 |= ByteArrayUtil.getLong(b, offLen - 8) >>> -(remainingBytes << 3);
                } else if (remainingBytes > 3) {
                    this.buffer1 |= (long)ByteArrayUtil.getInt(b, offLen - remainingBytes) & 0xFFFFFFFFL;
                    if (remainingBytes > 4) {
                        this.buffer1 |= ((long)b[offLen - remainingBytes + 4] & 0xFFL) << 32;
                        if (remainingBytes > 5) {
                            this.buffer1 |= ((long)b[offLen - remainingBytes + 5] & 0xFFL) << 40;
                            if (remainingBytes > 6) {
                                this.buffer1 |= ((long)b[offLen - remainingBytes + 6] & 0xFFL) << 48;
                            }
                        }
                    }
                } else {
                    this.buffer1 |= (long)b[offLen - remainingBytes] & 0xFFL;
                    if (remainingBytes > 1) {
                        this.buffer1 |= ((long)b[offLen - remainingBytes + 1] & 0xFFL) << 8;
                        if (remainingBytes > 2) {
                            this.buffer1 |= ((long)b[offLen - remainingBytes + 2] & 0xFFL) << 16;
                        }
                    }
                }
            }
            return this;
        }

        @Override
        public <T> HashStream128 putBytes(T b, long off, long len, ByteAccess<T> access) {
            int bufferOffset = (int)this.byteCount;
            int bitOffset = bufferOffset << 3;
            int regularBlockStartIdx = -bufferOffset & 0xF;
            long regularBlockEndIdx = len - (len + (long)bufferOffset & 0xFL);
            this.byteCount += len;
            if (regularBlockEndIdx < (long)regularBlockStartIdx) {
                int z = -bufferOffset & 7;
                if (len < (long)z) {
                    int x = 0;
                    while ((long)x < len) {
                        this.buffer1 |= access.getByteAsUnsignedLong(b, off + (long)x) << (x + bufferOffset << 3);
                        ++x;
                    }
                } else {
                    int x;
                    if (0 < z) {
                        for (x = 0; x < z; ++x) {
                            this.buffer1 |= access.getByteAsUnsignedLong(b, off + (long)x) << (x + bufferOffset << 3);
                        }
                        this.buffer0 = this.buffer1;
                        this.buffer1 = 0L;
                    }
                    x = z;
                    while ((long)x < len) {
                        this.buffer1 |= access.getByteAsUnsignedLong(b, off + (long)x) << (x + bufferOffset << 3);
                        ++x;
                    }
                }
                return this;
            }
            if (regularBlockStartIdx > 0) {
                if (regularBlockStartIdx >= 8) {
                    if (regularBlockStartIdx > 8) {
                        this.buffer0 = this.buffer1 | access.getLong(b, off) << bitOffset;
                    }
                    this.buffer1 = access.getLong(b, off + (long)regularBlockStartIdx - 8L);
                } else if (len >= 8L) {
                    this.buffer1 |= access.getLong(b, off) << bitOffset;
                } else if (regularBlockStartIdx >= 4) {
                    if (regularBlockStartIdx >= 5) {
                        if (regularBlockStartIdx >= 6) {
                            if (regularBlockStartIdx >= 7) {
                                this.buffer1 |= access.getByteAsUnsignedLong(b, off + (long)regularBlockStartIdx - 7L) << 8;
                            }
                            this.buffer1 |= access.getByteAsUnsignedLong(b, off + (long)regularBlockStartIdx - 6L) << 16;
                        }
                        this.buffer1 |= access.getByteAsUnsignedLong(b, off + (long)regularBlockStartIdx - 5L) << 24;
                    }
                    this.buffer1 |= (long)access.getInt(b, off + (long)regularBlockStartIdx - 4L) << 32;
                } else {
                    if (regularBlockStartIdx >= 2) {
                        if (regularBlockStartIdx >= 3) {
                            this.buffer1 |= access.getByteAsUnsignedLong(b, off + (long)regularBlockStartIdx - 3L) << 40;
                        }
                        this.buffer1 |= access.getByteAsUnsignedLong(b, off + (long)regularBlockStartIdx - 2L) << 48;
                    }
                    this.buffer1 |= (long)access.getByte(b, off + (long)regularBlockStartIdx - 1L) << 56;
                }
                this.processBuffer(this.buffer0, this.buffer1);
                this.buffer1 = 0L;
            }
            for (long i = (long)regularBlockStartIdx; i < regularBlockEndIdx; i += 16L) {
                long b0 = access.getLong(b, off + i);
                long b1 = access.getLong(b, off + i + 8L);
                this.processBuffer(b0, b1);
            }
            long remainingBytes = len - regularBlockEndIdx;
            long offLen = off + len;
            if (remainingBytes > 0L) {
                if (remainingBytes >= 8L) {
                    if (remainingBytes > 8L) {
                        this.buffer1 = access.getLong(b, offLen - 8L) >>> (int)(-(remainingBytes << 3));
                    }
                    this.buffer0 = access.getLong(b, offLen - remainingBytes);
                } else if (len >= 8L) {
                    this.buffer1 |= access.getLong(b, offLen - 8L) >>> (int)(-(remainingBytes << 3));
                } else if (remainingBytes > 3L) {
                    this.buffer1 |= access.getIntAsUnsignedLong(b, offLen - remainingBytes);
                    if (remainingBytes > 4L) {
                        this.buffer1 |= access.getByteAsUnsignedLong(b, offLen - remainingBytes + 4L) << 32;
                        if (remainingBytes > 5L) {
                            this.buffer1 |= access.getByteAsUnsignedLong(b, offLen - remainingBytes + 5L) << 40;
                            if (remainingBytes > 6L) {
                                this.buffer1 |= access.getByteAsUnsignedLong(b, offLen - remainingBytes + 6L) << 48;
                            }
                        }
                    }
                } else {
                    this.buffer1 |= access.getByteAsUnsignedLong(b, offLen - remainingBytes);
                    if (remainingBytes > 1L) {
                        this.buffer1 |= access.getByteAsUnsignedLong(b, offLen - remainingBytes + 1L) << 8;
                        if (remainingBytes > 2L) {
                            this.buffer1 |= access.getByteAsUnsignedLong(b, offLen - remainingBytes + 2L) << 16;
                        }
                    }
                }
            }
            return this;
        }

        private void processBuffer(long b0, long b1) {
            this.h1 ^= Murmur3_128.mixK1(b0);
            this.h1 = Murmur3_128.mixH1(this.h1, this.h2);
            this.h2 ^= Murmur3_128.mixK2(b1);
            this.h2 = Murmur3_128.mixH2(this.h1, this.h2);
        }

        @Override
        public HashValue128 get() {
            long g1 = this.h1;
            long g2 = this.h2;
            if ((this.byteCount & 0xFL) != 0L) {
                this.buffer1 &= -1L >>> (int)(-(this.byteCount << 3));
                if ((this.byteCount & 8L) == 0L) {
                    g1 ^= Murmur3_128.mixK1(this.buffer1);
                } else {
                    g1 ^= Murmur3_128.mixK1(this.buffer0);
                    g2 ^= Murmur3_128.mixK2(this.buffer1);
                }
            }
            return Murmur3_128.finalizeHash(g1, g2, this.byteCount);
        }

        @Override
        public long getAsLong() {
            long g1 = this.h1;
            long g2 = this.h2;
            if ((this.byteCount & 0xFL) != 0L) {
                this.buffer1 &= -1L >>> (int)(-(this.byteCount << 3));
                if ((this.byteCount & 8L) == 0L) {
                    g1 ^= Murmur3_128.mixK1(this.buffer1);
                } else {
                    g1 ^= Murmur3_128.mixK1(this.buffer0);
                    g2 ^= Murmur3_128.mixK2(this.buffer1);
                }
            }
            return Murmur3_128.finalizeHashToLong(g1, g2, this.byteCount);
        }

        @Override
        public HashStream128 putChars(CharSequence s) {
            int i;
            int len = s.length();
            if (len < (i = 1 - (int)this.byteCount >>> 1 & 7)) {
                for (int j = 0; j < len; ++j) {
                    long l = s.charAt(j);
                    this.buffer1 |= l << (int)(this.byteCount << 3);
                    if ((this.byteCount & 6L) == 6L) {
                        this.buffer0 = this.buffer1;
                        this.buffer1 = l >>> (int)(-(this.byteCount << 3));
                    }
                    this.byteCount += 2L;
                }
                return this;
            }
            if ((this.byteCount & 1L) == 0L) {
                if (i - 1 >= 0) {
                    if (i - 2 >= 0) {
                        if (i - 3 >= 0) {
                            if (i - 4 >= 0) {
                                if (i - 5 >= 0) {
                                    if (i - 6 >= 0) {
                                        if (i - 7 >= 0) {
                                            this.buffer1 |= (long)s.charAt(0) << 16;
                                        }
                                        this.buffer1 |= (long)s.charAt(i - 6) << 32;
                                    }
                                    this.buffer1 |= (long)s.charAt(i - 5) << 48;
                                    this.buffer0 = this.buffer1;
                                    this.buffer1 = 0L;
                                }
                                this.buffer1 |= (long)s.charAt(i - 4);
                            }
                            this.buffer1 |= (long)s.charAt(i - 3) << 16;
                        }
                        this.buffer1 |= (long)s.charAt(i - 2) << 32;
                    }
                    this.buffer1 |= (long)s.charAt(i - 1) << 48;
                    this.processBuffer(this.buffer0, this.buffer1);
                    this.buffer1 = 0L;
                }
                while (i <= len - 8) {
                    long b0 = ByteArrayUtil.getLong(s, i);
                    long b1 = ByteArrayUtil.getLong(s, i + 4);
                    this.processBuffer(b0, b1);
                    i += 8;
                }
                if (i < len) {
                    this.buffer1 |= (long)s.charAt(i);
                    if (i + 1 < len) {
                        this.buffer1 |= (long)s.charAt(i + 1) << 16;
                        if (i + 2 < len) {
                            this.buffer1 |= (long)s.charAt(i + 2) << 32;
                            if (i + 3 < len) {
                                this.buffer1 |= (long)s.charAt(i + 3) << 48;
                                this.buffer0 = this.buffer1;
                                this.buffer1 = 0L;
                                if (i + 4 < len) {
                                    this.buffer1 |= (long)s.charAt(i + 4);
                                    if (i + 5 < len) {
                                        this.buffer1 |= (long)s.charAt(i + 5) << 16;
                                        if (i + 6 < len) {
                                            this.buffer1 |= (long)s.charAt(i + 6) << 32;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            } else {
                long l;
                if (i - 1 >= 0) {
                    if (i - 2 >= 0) {
                        if (i - 3 >= 0) {
                            if (i - 4 >= 0) {
                                if (i - 5 >= 0) {
                                    if (i - 6 >= 0) {
                                        if (i - 7 >= 0) {
                                            this.buffer1 |= (long)s.charAt(0) << 24;
                                        }
                                        this.buffer1 |= (long)s.charAt(i - 6) << 40;
                                    }
                                    l = s.charAt(i - 5);
                                    this.buffer1 |= l << 56;
                                    this.buffer0 = this.buffer1;
                                    this.buffer1 = l >>> 8;
                                }
                                this.buffer1 |= (long)s.charAt(i - 4) << 8;
                            }
                            this.buffer1 |= (long)s.charAt(i - 3) << 24;
                        }
                        this.buffer1 |= (long)s.charAt(i - 2) << 40;
                    }
                    l = s.charAt(i - 1);
                    this.buffer1 |= l << 56;
                    this.processBuffer(this.buffer0, this.buffer1);
                    this.buffer1 = l >>> 8;
                }
                while (i <= len - 8) {
                    long c0 = s.charAt(i);
                    long c1 = s.charAt(i + 1);
                    long c2 = s.charAt(i + 2);
                    long c3 = s.charAt(i + 3);
                    long c4 = s.charAt(i + 4);
                    long c5 = s.charAt(i + 5);
                    long c6 = s.charAt(i + 6);
                    long c7 = s.charAt(i + 7);
                    long b0 = this.buffer1 | c0 << 8 | c1 << 24 | c2 << 40 | c3 << 56;
                    long b1 = c3 >>> 8 | c4 << 8 | c5 << 24 | c6 << 40 | c7 << 56;
                    this.processBuffer(b0, b1);
                    this.buffer1 = c7 >>> 8;
                    i += 8;
                }
                if (i < len) {
                    this.buffer1 |= (long)s.charAt(i) << 8;
                    if (i + 1 < len) {
                        this.buffer1 |= (long)s.charAt(i + 1) << 24;
                        if (i + 2 < len) {
                            this.buffer1 |= (long)s.charAt(i + 2) << 40;
                            if (i + 3 < len) {
                                l = s.charAt(i + 3);
                                this.buffer1 |= l << 56;
                                this.buffer0 = this.buffer1;
                                this.buffer1 = l >>> 8;
                                if (i + 4 < len) {
                                    this.buffer1 |= (long)s.charAt(i + 4) << 8;
                                    if (i + 5 < len) {
                                        this.buffer1 |= (long)s.charAt(i + 5) << 24;
                                        if (i + 6 < len) {
                                            this.buffer1 |= (long)s.charAt(i + 6) << 40;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            this.byteCount += (long)len << 1;
            return this;
        }
    }
}

