/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.recentFiles.frontend;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.recentFiles.frontend.model.FrontendRecentFilesModel;
import com.intellij.platform.recentFiles.shared.FileChangeKind;
import com.intellij.platform.recentFiles.shared.RecentFileKind;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/recentFiles/frontend/RecentlySelectedEditorListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "<init>", "()V", "fileOpened", "", "source", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileClosed", "selectionChanged", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "intellij.platform.recentFiles.frontend"})
@SourceDebugExtension(value={"SMAP\nRecentlyOpenedFileListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecentlyOpenedFileListener.kt\ncom/intellij/platform/recentFiles/frontend/RecentlySelectedEditorListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,38:1\n23#2:39\n67#2,4:40\n23#2:44\n67#2,4:45\n23#2:49\n67#2,4:50\n23#2:54\n67#2,4:55\n*S KotlinDebug\n*F\n+ 1 RecentlyOpenedFileListener.kt\ncom/intellij/platform/recentFiles/frontend/RecentlySelectedEditorListener\n*L\n16#1:39\n16#1:40,4\n23#1:44\n23#1:45,4\n26#1:49\n26#1:50,4\n33#1:54\n33#1:55,4\n*E\n"})
final class RecentlySelectedEditorListener
implements FileEditorManagerListener {
    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        RecentlySelectedEditorListener $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(RecentlySelectedEditorListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger2 = $this$trace$iv;
            boolean bl = false;
            logger2.trace("Add opened frontend file to model: " + file.getName());
        }
        Project project = source.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        FrontendRecentFilesModel frontendRecentFilesModel = FrontendRecentFilesModel.Companion.getInstance(project);
        frontendRecentFilesModel.applyFrontendChanges(RecentFileKind.RECENTLY_OPENED, CollectionsKt.listOf((Object)file), FileChangeKind.ADDED);
        frontendRecentFilesModel.applyFrontendChanges(RecentFileKind.RECENTLY_OPENED_UNPINNED, CollectionsKt.listOf((Object)file), FileChangeKind.ADDED);
    }

    /*
     * WARNING - void declaration
     */
    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        RecentlySelectedEditorListener $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger2 = Logger.getInstance(RecentlySelectedEditorListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        Logger $this$trace$iv = logger2;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Maybe remove closed frontend file from model: " + file.getName());
        }
        Project project = source.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        FrontendRecentFilesModel frontendRecentFilesModel = FrontendRecentFilesModel.Companion.getInstance(project);
        FileEditor[] fileEditorArray = source.getEditors(file);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getEditors(...)");
        if (((Object[])fileEditorArray).length == 0) {
            void $this$trace$iv2;
            RecentlySelectedEditorListener $this$thisLogger$iv2 = this;
            boolean $i$f$thisLogger2 = false;
            Logger logger3 = Logger.getInstance(RecentlySelectedEditorListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
            $this$thisLogger$iv2 = logger3;
            boolean $i$f$trace2 = false;
            if ($this$trace$iv2.isTraceEnabled()) {
                logger = $this$trace$iv2;
                boolean bl = false;
                logger.trace("Do remove closed frontend file from model: " + file.getName());
            }
            frontendRecentFilesModel.applyFrontendChanges(RecentFileKind.RECENTLY_OPENED_UNPINNED, CollectionsKt.listOf((Object)file), FileChangeKind.REMOVED);
        }
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VirtualFile virtualFile = event.getNewFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        RecentlySelectedEditorListener $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(RecentlySelectedEditorListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger2 = $this$trace$iv;
            boolean bl = false;
            logger2.trace("Update frontend file in model: " + file.getName());
        }
        Project project = event.getManager().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        FrontendRecentFilesModel frontendRecentFilesModel = FrontendRecentFilesModel.Companion.getInstance(project);
        frontendRecentFilesModel.applyFrontendChanges(RecentFileKind.RECENTLY_OPENED, CollectionsKt.listOf((Object)file), FileChangeKind.UPDATED_AND_PUT_ON_TOP);
        frontendRecentFilesModel.applyFrontendChanges(RecentFileKind.RECENTLY_OPENED_UNPINNED, CollectionsKt.listOf((Object)file), FileChangeKind.UPDATED_AND_PUT_ON_TOP);
    }
}

