/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch.tool;

import com.intellij.diff.DiffContext;
import com.intellij.diff.tools.combined.CombinedBlockProducer;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.actions.diff.CombinedDiffManagerImplKt;
import com.intellij.openapi.vcs.changes.patch.tool.PatchDiffRequestProducer;
import com.intellij.openapi.vcs.changes.patch.tool.StatusDiffRequestProducer;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u001d\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u000b\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H\u0002\u001a\u0018\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a8\u0006\u0016"}, d2={"switchToEditableView", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "buildCombinedDiffModel", "", "Lcom/intellij/diff/tools/combined/CombinedBlockProducer;", "document", "Lcom/intellij/openapi/editor/Document;", "createDiffRequestProducers", "Lcom/intellij/openapi/vcs/changes/ui/ChangeDiffRequestChain$Producer;", "createStatusMessageContent", "message", "", "Lorg/jetbrains/annotations/Nls;", "listenTypingAttempts", "diffContext", "Lcom/intellij/diff/DiffContext;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nDiffPatchFileEditorProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffPatchFileEditorProvider.kt\ncom/intellij/openapi/vcs/changes/patch/tool/DiffPatchFileEditorProviderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,221:1\n1563#2:222\n1634#2,3:223\n*S KotlinDebug\n*F\n+ 1 DiffPatchFileEditorProvider.kt\ncom/intellij/openapi/vcs/changes/patch/tool/DiffPatchFileEditorProviderKt\n*L\n130#1:222\n130#1:223,3\n*E\n"})
public final class DiffPatchFileEditorProviderKt {
    private static final void switchToEditableView(Project project, VirtualFile file) {
        FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, file), true);
    }

    private static final List<CombinedBlockProducer> buildCombinedDiffModel(Document document) {
        List<ChangeDiffRequestChain.Producer> producers = DiffPatchFileEditorProviderKt.createDiffRequestProducers(document);
        List<CombinedBlockProducer> diffModel = CombinedDiffManagerImplKt.prepareCombinedBlocksFromProducers(producers);
        return diffModel;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ChangeDiffRequestChain.Producer> createDiffRequestProducers(Document document) {
        try {
            void $this$mapTo$iv$iv;
            String string = document.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String patchText = string;
            if (StringsKt.isBlank((CharSequence)patchText)) {
                String string2 = VcsBundle.message((String)"patch.parse.error.empty.file", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                String message = string2;
                return CollectionsKt.listOf((Object)DiffPatchFileEditorProviderKt.createStatusMessageContent(document, message));
            }
            PatchReader reader = new PatchReader(patchText);
            reader.parseAllPatches();
            List<FilePatch> list = reader.getAllPatches();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getAllPatches(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FilePatch filePatch = (FilePatch)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(new PatchDiffRequestProducer((FilePatch)it));
            }
            return (List)destination$iv$iv;
        }
        catch (PatchSyntaxException e) {
            Object[] objectArray = new Object[]{e.getMessage()};
            String string = VcsBundle.message((String)"patch.parse.error", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            return CollectionsKt.listOf((Object)DiffPatchFileEditorProviderKt.createStatusMessageContent(document, message));
        }
    }

    private static final ChangeDiffRequestChain.Producer createStatusMessageContent(Document document, String message) {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        Intrinsics.checkNotNull((Object)virtualFile);
        VirtualFile file = virtualFile;
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        return new StatusDiffRequestProducer(filePath, message);
    }

    public static final void listenTypingAttempts(@NotNull DiffContext diffContext, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)diffContext, (String)"diffContext");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Runnable onTypingSwitch = (Runnable)diffContext.getUserData(DiffUserDataKeysEx.PATCH_FILE_PREVIEW_MODIFICATION_SWITCH);
        if (onTypingSwitch != null) {
            EditorModificationUtil.setReadOnlyHint((Editor)editor, (String)DiffBundle.message((String)"patch.editing.viewer.hint.enable.editing.text", (Object[])new Object[0]), arg_0 -> DiffPatchFileEditorProviderKt.listenTypingAttempts$lambda$0(onTypingSwitch, arg_0));
        }
    }

    private static final void listenTypingAttempts$lambda$0(Runnable $onTypingSwitch, HyperlinkEvent e) {
        if (Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            $onTypingSwitch.run();
        }
    }

    public static final /* synthetic */ List access$buildCombinedDiffModel(Document document) {
        return DiffPatchFileEditorProviderKt.buildCombinedDiffModel(document);
    }

    public static final /* synthetic */ void access$switchToEditableView(Project project, VirtualFile file) {
        DiffPatchFileEditorProviderKt.switchToEditableView(project, file);
    }

    public static final /* synthetic */ List access$createDiffRequestProducers(Document document) {
        return DiffPatchFileEditorProviderKt.createDiffRequestProducers(document);
    }
}

