/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.util.io.AppendablePersistentMap;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentHashMapValueStorage;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.function.IntUnaryOperator;
import java.util.function.ObjIntConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.dependencyView.IntIntMultiMaplet;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;

final class NaturalIntIntPersistentMultiMaplet
extends IntIntMultiMaplet {
    private static final IntSet NULL_COLLECTION = new IntOpenHashSet();
    private static final int CACHE_SIZE = 256;
    private static final DataExternalizer<IntSet> EXTERNALIZER = new DataExternalizer<IntSet>(){

        public void save(@NotNull DataOutput out, IntSet value) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            IntIterator iterator = value.iterator();
            while (iterator.hasNext()) {
                int elem = iterator.nextInt();
                if (elem == 0) {
                    throw new IOException("Zero values are not supported");
                }
                DataInputOutputUtil.writeINT((DataOutput)out, (int)elem);
            }
        }

        public IntSet read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            IntOpenHashSet result = new IntOpenHashSet();
            DataInputStream stream = (DataInputStream)in;
            while (stream.available() > 0) {
                int elem = DataInputOutputUtil.readINT((DataInput)in);
                if (elem < 0) {
                    result.remove(-elem);
                    continue;
                }
                if (elem <= 0) continue;
                result.add(elem);
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/builders/java/dependencyView/NaturalIntIntPersistentMultiMaplet$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final PersistentHashMap<Integer, IntSet> map;
    private final LoadingCache<Integer, IntSet> cache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NaturalIntIntPersistentMultiMaplet(File file, KeyDescriptor<Integer> keyExternalizer) throws IOException {
        Boolean prevValue = (Boolean)PersistentHashMapValueStorage.CreationTimeOptions.COMPACT_CHUNKS_WITH_VALUE_DESERIALIZATION.get();
        try {
            PersistentHashMapValueStorage.CreationTimeOptions.COMPACT_CHUNKS_WITH_VALUE_DESERIALIZATION.set(Boolean.TRUE);
            this.map = new PersistentHashMap(file.toPath(), keyExternalizer, EXTERNALIZER);
        }
        finally {
            PersistentHashMapValueStorage.CreationTimeOptions.COMPACT_CHUNKS_WITH_VALUE_DESERIALIZATION.set(prevValue);
        }
        this.cache = Caffeine.newBuilder().maximumSize(256L).build(key -> {
            try {
                IntSet collection = (IntSet)this.map.get(key);
                if (collection == null) {
                    return NULL_COLLECTION;
                }
                if (collection.isEmpty()) {
                    this.map.remove(key);
                    return NULL_COLLECTION;
                }
                return collection;
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        });
    }

    @Override
    public boolean containsKey(int key) {
        try {
            return this.map.containsMapping((Object)key);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public IntSet get(int key) {
        IntSet collection = (IntSet)this.cache.get((Object)key);
        return collection == NULL_COLLECTION ? null : collection;
    }

    @Override
    public void replace(int key, IntSet value) {
        try {
            this.cache.invalidate((Object)key);
            if (value == null || value.isEmpty()) {
                this.map.remove((Object)key);
            } else {
                this.map.put((Object)key, (Object)value);
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void put(int key, IntSet values) {
        try {
            if (!values.isEmpty()) {
                this.cache.invalidate((Object)key);
                this.map.appendData((Object)key, NaturalIntIntPersistentMultiMaplet.getAddAppender(values));
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void put(int key, int value) {
        try {
            this.cache.invalidate((Object)key);
            this.map.appendData((Object)key, NaturalIntIntPersistentMultiMaplet.getAddAppender(value));
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void removeAll(int key, IntSet values) {
        try {
            if (!values.isEmpty()) {
                this.cache.invalidate((Object)key);
                this.map.appendData((Object)key, NaturalIntIntPersistentMultiMaplet.getRemoveAppender(values));
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void removeFrom(int key, int value) {
        try {
            IntSet collection = (IntSet)this.cache.get((Object)key);
            if (collection != NULL_COLLECTION && collection.remove(value)) {
                this.cache.invalidate((Object)key);
                if (collection.isEmpty()) {
                    this.map.remove((Object)key);
                } else {
                    this.map.appendData((Object)key, NaturalIntIntPersistentMultiMaplet.getRemoveAppender(value));
                }
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void remove(int key) {
        try {
            this.cache.invalidate((Object)key);
            this.map.remove((Object)key);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void putAll(IntIntMultiMaplet m) {
        m.forEachEntry((integers, value) -> this.put(value, (IntSet)integers));
    }

    @Override
    public void replaceAll(IntIntMultiMaplet m) {
        m.forEachEntry((integers, value) -> this.replace(value, (IntSet)integers));
    }

    @Override
    public void close() {
        try {
            this.cache.invalidateAll();
            this.map.close();
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void flush(boolean memoryCachesOnly) {
        if (memoryCachesOnly) {
            if (this.map.isDirty()) {
                this.map.dropMemoryCaches();
            }
        } else {
            this.map.force();
        }
    }

    @Override
    void forEachEntry(ObjIntConsumer<? super IntSet> proc) {
        try {
            this.map.processKeysWithExistingMapping(key -> {
                try {
                    proc.accept((IntSet)this.map.get(key), (int)key);
                    return true;
                }
                catch (IOException e) {
                    throw new BuildDataCorruptedException(e);
                }
            });
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @NotNull
    private static AppendablePersistentMap.ValueDataAppender getAddAppender(int value) {
        AppendablePersistentMap.ValueDataAppender valueDataAppender = out -> DataInputOutputUtil.writeINT((DataOutput)out, (int)value);
        if (valueDataAppender == null) {
            NaturalIntIntPersistentMultiMaplet.$$$reportNull$$$0(0);
        }
        return valueDataAppender;
    }

    @NotNull
    private static AppendablePersistentMap.ValueDataAppender getRemoveAppender(int value) {
        AppendablePersistentMap.ValueDataAppender valueDataAppender = out -> DataInputOutputUtil.writeINT((DataOutput)out, (int)(-value));
        if (valueDataAppender == null) {
            NaturalIntIntPersistentMultiMaplet.$$$reportNull$$$0(1);
        }
        return valueDataAppender;
    }

    @NotNull
    private static AppendablePersistentMap.ValueDataAppender getAddAppender(IntSet set) {
        return NaturalIntIntPersistentMultiMaplet.getAppender(set, value -> value);
    }

    @NotNull
    private static AppendablePersistentMap.ValueDataAppender getRemoveAppender(IntSet set) {
        return NaturalIntIntPersistentMultiMaplet.getAppender(set, value -> -value);
    }

    @NotNull
    private static AppendablePersistentMap.ValueDataAppender getAppender(final IntSet set, final IntUnaryOperator converter) {
        return new AppendablePersistentMap.ValueDataAppender(){

            public void append(@NotNull DataOutput out) throws IOException {
                if (out == null) {
                    2.$$$reportNull$$$0(0);
                }
                IntIterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    int v = iterator.nextInt();
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)converter.applyAsInt(v));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/jps/builders/java/dependencyView/NaturalIntIntPersistentMultiMaplet$2", "append"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/jps/builders/java/dependencyView/NaturalIntIntPersistentMultiMaplet";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddAppender";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoveAppender";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

