/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia.impl;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.impl.BufferUtilKt;
import org.jetbrains.skia.impl.Native;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\bj\u0002`\u00072\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0017\u0010\f\u001a\u00060\bj\u0002`\u00072\u0006\u0010\r\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/skia/impl/BufferUtil;", "", "<init>", "()V", "getByteBufferFromPointer", "Ljava/nio/ByteBuffer;", "ptr", "Lorg/jetbrains/skia/impl/NativePointer;", "", "size", "", "(JI)Ljava/nio/ByteBuffer;", "getPointerFromByteBuffer", "buffer", "(Ljava/nio/ByteBuffer;)J", "skiko"})
@SourceDebugExtension(value={"SMAP\nBufferUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferUtil.kt\norg/jetbrains/skia/impl/BufferUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,21:1\n1#2:22\n*E\n"})
public final class BufferUtil {
    @NotNull
    public static final BufferUtil INSTANCE = new BufferUtil();

    private BufferUtil() {
    }

    @NotNull
    public final ByteBuffer getByteBufferFromPointer(long ptr, int size) {
        ByteBuffer byteBuffer = BufferUtilKt.access$_nGetByteBufferFromPointer(ptr, size);
        if (byteBuffer == null) {
            throw new IllegalArgumentException("JNI direct buffer access not support by current JVM!");
        }
        return byteBuffer;
    }

    public final long getPointerFromByteBuffer(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        long result = BufferUtilKt.access$_nGetPointerFromByteBuffer(buffer);
        if (!(result != Native.Companion.getNullPointer())) {
            boolean bl = false;
            String string = "The given buffer " + buffer + "is not a direct buffer or current JVM doesn't support JNI direct buffer access!";
            throw new IllegalArgumentException(string.toString());
        }
        return result;
    }
}

