/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.context;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.SurfaceColorFormat;
import org.jetbrains.skia.SurfaceOrigin;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skiko.AngleApi;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.context.ContextBasedContextHandler;
import org.jetbrains.skiko.redrawer.AngleRedrawer;
import org.jetbrains.skiko.redrawer.Redrawer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/skiko/context/AngleContextHandler;", "Lorg/jetbrains/skiko/context/ContextBasedContextHandler;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "<init>", "(Lorg/jetbrains/skiko/SkiaLayer;)V", "angleRedrawer", "Lorg/jetbrains/skiko/redrawer/AngleRedrawer;", "getAngleRedrawer", "()Lorg/jetbrains/skiko/redrawer/AngleRedrawer;", "makeContext", "Lorg/jetbrains/skia/DirectContext;", "currentWidth", "", "currentHeight", "isSizeChanged", "", "width", "height", "initCanvas", "", "rendererInfo", "", "skiko"})
public final class AngleContextHandler
extends ContextBasedContextHandler {
    private int currentWidth;
    private int currentHeight;

    public AngleContextHandler(@NotNull SkiaLayer layer) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        super(layer, "ANGLE");
    }

    private final AngleRedrawer getAngleRedrawer() {
        Redrawer redrawer = this.getLayer().getRedrawer$skiko();
        Intrinsics.checkNotNull((Object)redrawer);
        return (AngleRedrawer)redrawer;
    }

    @Override
    @NotNull
    protected DirectContext makeContext() {
        return this.getAngleRedrawer().makeContext();
    }

    private final boolean isSizeChanged(int width, int height) {
        if (width != this.currentWidth || height != this.currentHeight) {
            this.currentWidth = width;
            this.currentHeight = height;
            return true;
        }
        return false;
    }

    @Override
    protected void initCanvas() {
        int h;
        DirectContext directContext = this.getContext();
        if (directContext == null) {
            return;
        }
        DirectContext context = directContext;
        float scale = this.getLayer().getContentScale();
        int w = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getWidth() * scale)), (int)0);
        if (this.isSizeChanged(w, h = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getHeight() * scale)), (int)0)) || this.getSurface() == null) {
            this.disposeCanvas();
            context.flush();
            this.setRenderTarget(this.getAngleRedrawer().makeRenderTarget(w, h));
            BackendRenderTarget backendRenderTarget = this.getRenderTarget();
            Intrinsics.checkNotNull((Object)backendRenderTarget);
            Surface surface = Surface.Companion.makeFromBackendRenderTarget(context, backendRenderTarget, SurfaceOrigin.BOTTOM_LEFT, SurfaceColorFormat.RGBA_8888, ColorSpace.Companion.getSRGB(), new SurfaceProps(false, this.getLayer().getPixelGeometry(), 1, null));
            if (surface == null) {
                throw new RenderException("Cannot create surface", null, 2, null);
            }
            this.setSurface(surface);
        }
        Surface surface = this.getSurface();
        Intrinsics.checkNotNull((Object)surface);
        this.setCanvas(surface.getCanvas());
    }

    @Override
    @NotNull
    public String rendererInfo() {
        return super.rendererInfo() + "Vendor: " + AngleApi.INSTANCE.glGetString(AngleApi.INSTANCE.getGL_VENDOR()) + "\nModel: " + AngleApi.INSTANCE.glGetString(AngleApi.INSTANCE.getGL_RENDERER()) + "\nVersion: " + AngleApi.INSTANCE.glGetString(AngleApi.INSTANCE.getGL_VERSION()) + '\n';
    }
}

