/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import javax.tools.JavaFileManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.jps.javac.JpsFileObject;

@ApiStatus.Internal
final class ExtInputFileObject
extends JpsFileObject {
    private final String myPath;
    private final String myEncoding;
    private final byte[] myContent;

    ExtInputFileObject(JavaFileManager.Location location, String path, String encoding, byte[] content) {
        super(ExtInputFileObject.createURI(path), ExtInputFileObject.findKind(path), location);
        this.myPath = path.replace(File.separatorChar, '/');
        this.myEncoding = encoding;
        this.myContent = content;
    }

    private static URI createURI(String path) {
        try {
            if (File.separatorChar != '/') {
                path = path.replace(File.separatorChar, '/');
            }
            if (!path.startsWith("/")) {
                path = '/' + path;
            }
            if (path.startsWith("//")) {
                path = "//" + path;
            }
            return new URI("ext-file", null, path, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(path, e);
        }
    }

    @Override
    public InputStream openInputStream() {
        return new ByteArrayInputStream(this.myContent);
    }

    @Override
    public Writer openWriter() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String inferBinaryName(Iterable<? extends File> path, boolean caseSensitiveFS) {
        String _path = this.myPath;
        int idx = _path.lastIndexOf(46);
        if (idx >= 0) {
            _path = _path.substring(0, idx);
        }
        return _path.replace('/', '.');
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExtInputFileObject)) {
            return false;
        }
        ExtInputFileObject o = (ExtInputFileObject)other;
        return this.myPath.equals(o.myPath);
    }

    @Override
    public int hashCode() {
        return this.myPath.hashCode();
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        return new String(this.myContent, this.myEncoding);
    }
}

