/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.internal.daemon;

import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.daemon.client.DaemonClientConnection;
import org.gradle.launcher.daemon.client.DaemonClientFactory;
import org.gradle.launcher.daemon.client.DaemonConnector;
import org.gradle.launcher.daemon.client.DaemonStopClient;
import org.gradle.launcher.daemon.client.DaemonStopClientExecuter;
import org.gradle.launcher.daemon.context.DaemonConnectDetails;
import org.gradle.launcher.daemon.protocol.Command;
import org.gradle.launcher.daemon.protocol.Message;
import org.gradle.launcher.daemon.registry.DaemonInfo;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.internal.daemon.AbstractDaemonStopActionKt;
import org.jetbrains.plugins.gradle.internal.daemon.DaemonAction;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0000\b&\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H$J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013J\u001c\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/gradle/internal/daemon/AbstractDaemonStopAction;", "Lorg/jetbrains/plugins/gradle/internal/daemon/DaemonAction;", "serviceDirectoryPath", "", "<init>", "(Ljava/lang/String;)V", "commandClass", "Ljava/lang/Class;", "Lorg/gradle/launcher/daemon/protocol/Command;", "getCommandClass", "()Ljava/lang/Class;", "stopAll", "", "stopClient", "Lorg/gradle/launcher/daemon/client/DaemonStopClient;", "daemonServices", "Lorg/gradle/internal/service/ServiceRegistry;", "run", "daemonClientFactory", "Lorg/gradle/launcher/daemon/client/DaemonClientFactory;", "tokens", "", "", "intellij.gradle"})
@SourceDebugExtension(value={"SMAP\nAbstractDaemonStopAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractDaemonStopAction.kt\norg/jetbrains/plugins/gradle/internal/daemon/AbstractDaemonStopAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1869#2,2:74\n*S KotlinDebug\n*F\n+ 1 AbstractDaemonStopAction.kt\norg/jetbrains/plugins/gradle/internal/daemon/AbstractDaemonStopAction\n*L\n50#1:74,2\n*E\n"})
public abstract class AbstractDaemonStopAction
extends DaemonAction {
    @Nullable
    private final String serviceDirectoryPath;

    public AbstractDaemonStopAction(@Nullable String serviceDirectoryPath) {
        super(serviceDirectoryPath);
        this.serviceDirectoryPath = serviceDirectoryPath;
    }

    @NotNull
    protected abstract Class<? extends Command> getCommandClass();

    protected abstract void stopAll(@NotNull DaemonStopClient var1, @NotNull ServiceRegistry var2);

    public final void run(@NotNull DaemonClientFactory daemonClientFactory) {
        Intrinsics.checkNotNullParameter((Object)daemonClientFactory, (String)"daemonClientFactory");
        ServiceRegistry daemonServices = this.getDaemonServices(daemonClientFactory);
        if (GradleVersionUtil.isCurrentGradleAtLeast((String)"8.12")) {
            if (this.serviceDirectoryPath == null) {
                AbstractDaemonStopActionKt.access$getLOG$p().info("Gradle daemon service directory path is not defined. Unable to execute a daemon action.");
                return;
            }
            Object object = daemonServices.get(DaemonStopClientExecuter.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            DaemonStopClientExecuter executor = (DaemonStopClientExecuter)object;
            executor.execute(daemonServices, new File(this.serviceDirectoryPath), arg_0 -> AbstractDaemonStopAction.run$lambda$0(this, daemonServices, arg_0));
        } else {
            Object object = daemonServices.get(DaemonStopClient.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            DaemonStopClient stopClient = (DaemonStopClient)object;
            this.stopAll(stopClient, daemonServices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run(@NotNull DaemonClientFactory daemonClientFactory, @NotNull List<byte[]> tokens) {
        Intrinsics.checkNotNullParameter((Object)daemonClientFactory, (String)"daemonClientFactory");
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        ServiceRegistry daemonServices = this.getDaemonServices(daemonClientFactory);
        Object object = daemonServices.get(DaemonRegistry.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        DaemonRegistry daemonRegistry = (DaemonRegistry)object;
        Object object2 = daemonServices.get(DaemonConnector.class);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        DaemonConnector daemonConnector = (DaemonConnector)object2;
        Object object3 = daemonServices.get(IdGenerator.class);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        IdGenerator idGenerator = (IdGenerator)object3;
        List daemons = new ArrayList(daemonRegistry.getAll());
        Iterable $this$forEach$iv = tokens;
        boolean $i$f$forEach = false;
        block3: for (Object element$iv : $this$forEach$iv) {
            byte[] token = (byte[])element$iv;
            boolean bl = false;
            Iterator daemonIterator = daemons.iterator();
            while (daemonIterator.hasNext()) {
                DaemonInfo info = (DaemonInfo)daemonIterator.next();
                if (!Arrays.equals(info.getToken(), token)) continue;
                daemonIterator.remove();
                DaemonClientConnection connection = daemonConnector.maybeConnect((DaemonConnectDetails)info);
                if (connection == null) continue block3;
                try {
                    Class<? extends Command> clazz = this.getCommandClass();
                    Object object4 = idGenerator.generateId();
                    Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"generateId(...)");
                    Command stopCommand = DaemonAction.Companion.createCommand(clazz, object4, token);
                    connection.dispatch((Message)stopCommand);
                    continue block3;
                }
                finally {
                    connection.stop();
                    continue block3;
                }
            }
        }
    }

    private static final void run$lambda$0(AbstractDaemonStopAction this$0, ServiceRegistry $daemonServices, DaemonStopClient stopClient) {
        Intrinsics.checkNotNullParameter((Object)stopClient, (String)"stopClient");
        this$0.stopAll(stopClient, $daemonServices);
    }
}

