/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.method;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.method.AbstractAuthMethod;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class AuthGssApiWithMic
extends AbstractAuthMethod {
    private final LoginContext loginContext;
    private final List<Oid> mechanismOids;
    private final GSSManager manager;
    private GSSContext secContext;

    public AuthGssApiWithMic(LoginContext loginContext, List<Oid> mechanismOids) {
        this(loginContext, mechanismOids, GSSManager.getInstance());
    }

    public AuthGssApiWithMic(LoginContext loginContext, List<Oid> mechanismOids, GSSManager manager) {
        super("gssapi-with-mic");
        this.loginContext = loginContext;
        this.mechanismOids = mechanismOids;
        this.manager = manager;
        this.secContext = null;
    }

    @Override
    public SSHPacket buildReq() throws UserAuthException {
        SSHPacket packet = (SSHPacket)super.buildReq().putUInt32(this.mechanismOids.size());
        for (Oid oid : this.mechanismOids) {
            try {
                packet.putString(oid.getDER());
            }
            catch (GSSException e) {
                throw new UserAuthException("Mechanism OID could not be encoded: " + oid.toString(), (Throwable)e);
            }
        }
        return packet;
    }

    private void sendToken(byte[] token) throws TransportException {
        SSHPacket packet = (SSHPacket)new SSHPacket(Message.USERAUTH_INFO_RESPONSE).putString(token);
        this.params.getTransport().write(packet);
    }

    private void handleContextInitialization(SSHPacket buf) throws UserAuthException, TransportException {
        Oid selectedOid;
        byte[] bytes;
        try {
            bytes = buf.readBytes();
        }
        catch (Buffer.BufferException e) {
            throw new UserAuthException("Failed to read byte array from message buffer", (Throwable)e);
        }
        try {
            selectedOid = new Oid(bytes);
        }
        catch (GSSException e) {
            throw new UserAuthException("Exception constructing OID from server response", (Throwable)e);
        }
        this.log.debug("Server selected OID: {}", (Object)selectedOid.toString());
        this.log.debug("Initializing GSSAPI context");
        Subject subject = this.loginContext.getSubject();
        try {
            this.secContext = Subject.doAs(subject, new InitializeContextAction(selectedOid));
        }
        catch (PrivilegedActionException e) {
            throw new UserAuthException("Exception during context initialization", (Throwable)e);
        }
        this.log.debug("Sending initial token");
        byte[] inToken = new byte[]{};
        try {
            byte[] outToken = this.secContext.initSecContext(inToken, 0, inToken.length);
            this.sendToken(outToken);
        }
        catch (GSSException e) {
            throw new UserAuthException("Exception sending initial token", (Throwable)e);
        }
    }

    private byte[] handleTokenFromServer(SSHPacket buf) throws UserAuthException {
        byte[] token;
        try {
            token = buf.readStringAsBytes();
        }
        catch (Buffer.BufferException e) {
            throw new UserAuthException("Failed to read string from message buffer", (Throwable)e);
        }
        try {
            return this.secContext.initSecContext(token, 0, token.length);
        }
        catch (GSSException e) {
            throw new UserAuthException("Exception during token exchange", (Throwable)e);
        }
    }

    private byte[] generateMIC() throws UserAuthException {
        byte[] msg = ((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)new Buffer.PlainBuffer().putString(this.params.getTransport().getSessionID())).putByte(Message.USERAUTH_REQUEST.toByte())).putString(this.params.getUsername())).putString(this.params.getNextServiceName())).putString(this.getName())).getCompactData();
        try {
            return this.secContext.getMIC(msg, 0, msg.length, null);
        }
        catch (GSSException e) {
            throw new UserAuthException("Exception getting message integrity code", (Throwable)e);
        }
    }

    @Override
    public void handle(Message cmd, SSHPacket buf) throws UserAuthException, TransportException {
        if (cmd == Message.USERAUTH_60) {
            this.handleContextInitialization(buf);
        } else if (cmd == Message.USERAUTH_INFO_RESPONSE) {
            byte[] token = this.handleTokenFromServer(buf);
            if (!this.secContext.isEstablished()) {
                this.log.debug("Sending token");
                this.sendToken(token);
            } else if (this.secContext.getIntegState()) {
                this.log.debug("Per-message integrity protection available: finalizing authentication with message integrity code");
                this.params.getTransport().write((SSHPacket)new SSHPacket(Message.USERAUTH_GSSAPI_MIC).putString(this.generateMIC()));
            } else {
                this.log.debug("Per-message integrity protection unavailable: finalizing authentication");
                this.params.getTransport().write(new SSHPacket(Message.USERAUTH_GSSAPI_EXCHANGE_COMPLETE));
            }
        } else {
            super.handle(cmd, buf);
        }
    }

    private class InitializeContextAction
    implements PrivilegedExceptionAction<GSSContext> {
        private final Oid selectedOid;

        public InitializeContextAction(Oid selectedOid) {
            this.selectedOid = selectedOid;
        }

        @Override
        public GSSContext run() throws GSSException {
            GSSCredential clientCreds = AuthGssApiWithMic.this.manager.createCredential(1);
            GSSName peerName = AuthGssApiWithMic.this.manager.createName("host@" + AuthGssApiWithMic.this.params.getTransport().getRemoteHost(), GSSName.NT_HOSTBASED_SERVICE);
            GSSContext context = AuthGssApiWithMic.this.manager.createContext(peerName, this.selectedOid, clientCreds, 0);
            context.requestMutualAuth(true);
            context.requestInteg(true);
            return context;
        }
    }
}

