/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.framework.library.DownloadableLibraryType;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryPresentationProvider;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.config.GroovyDownloadableLibraryType;
import org.jetbrains.plugins.groovy.config.GroovyLibraryPresentationProviderBase;

public class GroovyLibraryDescription
extends CustomLibraryDescription {
    private static final String GROOVY_FRAMEWORK_NAME = "Groovy";
    private final String myEnvVariable;
    private final Set<? extends LibraryKind> myLibraryKinds;
    private final String myFrameworkName;
    private final DownloadableLibraryType myLibraryType;

    public GroovyLibraryDescription() {
        this("GROOVY_HOME", GroovyLibraryDescription.getAllGroovyKinds(), GROOVY_FRAMEWORK_NAME);
    }

    public static Set<? extends LibraryKind> getAllGroovyKinds() {
        HashSet<LibraryKind> kinds = new HashSet<LibraryKind>();
        for (LibraryPresentationProvider provider2 : (LibraryPresentationProvider[])LibraryPresentationProvider.EP_NAME.getExtensions()) {
            if (!(provider2 instanceof GroovyLibraryPresentationProviderBase)) continue;
            kinds.add(provider2.getKind());
        }
        return kinds;
    }

    public GroovyLibraryDescription(@NotNull String envVariable, @NotNull LibraryKind libraryKind, String frameworkName) {
        if (envVariable == null) {
            GroovyLibraryDescription.$$$reportNull$$$0(0);
        }
        if (libraryKind == null) {
            GroovyLibraryDescription.$$$reportNull$$$0(1);
        }
        this(envVariable, Collections.singleton(libraryKind), frameworkName);
    }

    private GroovyLibraryDescription(@NotNull String envVariable, @NotNull Set<? extends LibraryKind> libraryKinds, String frameworkName) {
        if (envVariable == null) {
            GroovyLibraryDescription.$$$reportNull$$$0(2);
        }
        if (libraryKinds == null) {
            GroovyLibraryDescription.$$$reportNull$$$0(3);
        }
        this.myEnvVariable = envVariable;
        this.myLibraryKinds = libraryKinds;
        this.myFrameworkName = frameworkName;
        this.myLibraryType = (DownloadableLibraryType)LibraryType.EP_NAME.findExtension(GroovyDownloadableLibraryType.class);
    }

    @Nullable
    public static GroovyLibraryPresentationProviderBase findManager(@NotNull VirtualFile dir) {
        if (dir == null) {
            GroovyLibraryDescription.$$$reportNull$$$0(4);
        }
        String name = dir.getName();
        List providers = ContainerUtil.findAll((Object[])((LibraryPresentationProvider[])LibraryPresentationProvider.EP_NAME.getExtensions()), GroovyLibraryPresentationProviderBase.class);
        for (GroovyLibraryPresentationProviderBase provider2 : providers) {
            if (!provider2.managesName(name) || !provider2.isSDKHome(dir)) continue;
            return provider2;
        }
        for (GroovyLibraryPresentationProviderBase manager : providers) {
            if (!manager.isSDKHome(dir)) continue;
            return manager;
        }
        return null;
    }

    @NotNull
    public Set<? extends LibraryKind> getSuitableLibraryKinds() {
        Set<? extends LibraryKind> set = this.myLibraryKinds;
        if (set == null) {
            GroovyLibraryDescription.$$$reportNull$$$0(5);
        }
        return set;
    }

    public NewLibraryConfiguration createNewLibrary(@NotNull JComponent parentComponent, VirtualFile contextDirectory) {
        if (parentComponent == null) {
            GroovyLibraryDescription.$$$reportNull$$$0(6);
        }
        VirtualFile initial = this.findPathToGroovyHome();
        FileChooserDescriptor descriptor = this.createFileChooserDescriptor();
        VirtualFile dir = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Component)parentComponent, null, (VirtualFile)initial);
        if (dir == null) {
            return null;
        }
        return this.createLibraryConfiguration(parentComponent, dir);
    }

    @Nullable
    public VirtualFile findPathToGroovyHome() {
        VirtualFile initial = GroovyLibraryDescription.findFile(System.getenv(this.myEnvVariable));
        if (initial == null && GROOVY_FRAMEWORK_NAME.equals(this.myFrameworkName)) {
            if (SystemInfo.isLinux) {
                return GroovyLibraryDescription.findFile("/usr/share/groovy");
            }
            if (SystemInfo.isMac) {
                return GroovyLibraryDescription.findFile("/usr/local/opt/groovy/libexec");
            }
        }
        return initial;
    }

    @NotNull
    public FileChooserDescriptor createFileChooserDescriptor() {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(this, false, true, false, false, false, false){

            public boolean isFileSelectable(@Nullable VirtualFile file) {
                if (!super.isFileSelectable(file)) {
                    return false;
                }
                return GroovyLibraryDescription.findManager(file) != null;
            }
        };
        descriptor.setTitle(GroovyBundle.message("framework.0.sdk.chooser.title", this.myFrameworkName));
        descriptor.setDescription(GroovyBundle.message("framework.0.sdk.chooser.description", this.myFrameworkName));
        FileChooserDescriptor fileChooserDescriptor = descriptor;
        if (fileChooserDescriptor == null) {
            GroovyLibraryDescription.$$$reportNull$$$0(7);
        }
        return fileChooserDescriptor;
    }

    @Nullable
    public NewLibraryConfiguration createLibraryConfiguration(@Nullable Component parentComponent, @NotNull VirtualFile pathToLibrary) {
        GroovyLibraryPresentationProviderBase provider2;
        if (pathToLibrary == null) {
            GroovyLibraryDescription.$$$reportNull$$$0(8);
        }
        if ((provider2 = GroovyLibraryDescription.findManager(pathToLibrary)) == null) {
            return null;
        }
        final String path = pathToLibrary.getPath();
        String sdkVersion = provider2.getSDKVersion(path);
        if (sdkVersion == null) {
            Messages.showErrorDialog((Component)parentComponent, (String)GroovyBundle.message("framework.0.sdk.chooser.error.message", this.myFrameworkName), (String)GroovyBundle.message("framework.0.sdk.chooser.error.title", new Object[0]));
            return null;
        }
        return new NewLibraryConfiguration(this, provider2.getLibraryPrefix() + "-" + sdkVersion){

            public void addRoots(@NotNull LibraryEditor editor) {
                if (editor == null) {
                    2.$$$reportNull$$$0(0);
                }
                provider2.fillLibrary(path, editor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/groovy/config/GroovyLibraryDescription$2", "addRoots"));
            }
        };
    }

    @Nullable
    private static VirtualFile findFile(String path) {
        if (path != null && !path.isEmpty()) {
            return LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)path));
        }
        return null;
    }

    @Nullable
    public DownloadableLibraryType getDownloadableLibraryType() {
        return this.myLibraryType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envVariable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryKind";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryKinds";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/config/GroovyLibraryDescription";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToLibrary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/config/GroovyLibraryDescription";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableLibraryKinds";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileChooserDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findManager";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNewLibrary";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createLibraryConfiguration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7 -> new IllegalStateException(string);
        };
    }
}

