/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.util;

import ch.qos.logback.core.pattern.util.IEscapeUtil;

public class RegularEscapeUtil
implements IEscapeUtil {
    @Override
    public void escape(String escapeChars, StringBuffer buf, char next, int pointer) {
        if (escapeChars.indexOf(next) >= 0) {
            buf.append(next);
        } else {
            switch (next) {
                case '_': {
                    break;
                }
                case '\\': {
                    buf.append(next);
                    break;
                }
                case 't': {
                    buf.append('\t');
                    break;
                }
                case 'r': {
                    buf.append('\r');
                    break;
                }
                case 'n': {
                    buf.append('\n');
                    break;
                }
                default: {
                    String commaSeperatedEscapeChars = this.formatEscapeCharsForListing(escapeChars);
                    throw new IllegalArgumentException("Illegal char '" + next + " at column " + pointer + ". Only \\\\, \\_" + commaSeperatedEscapeChars + ", \\t, \\n, \\r combinations are allowed as escape characters.");
                }
            }
        }
    }

    String formatEscapeCharsForListing(String escapeChars) {
        StringBuilder commaSeperatedEscapeChars = new StringBuilder();
        for (int i15 = 0; i15 < escapeChars.length(); ++i15) {
            commaSeperatedEscapeChars.append(", \\").append(escapeChars.charAt(i15));
        }
        return commaSeperatedEscapeChars.toString();
    }

    public static String basicEscape(String s15) {
        int len = s15.length();
        StringBuilder sbuf = new StringBuilder(len);
        int i15 = 0;
        while (i15 < len) {
            int c15;
            if ((c15 = s15.charAt(i15++)) == 92 && i15 < len) {
                if ((c15 = s15.charAt(i15++)) == 110) {
                    c15 = 10;
                } else if (c15 == 114) {
                    c15 = 13;
                } else if (c15 == 116) {
                    c15 = 9;
                } else if (c15 == 102) {
                    c15 = 12;
                } else if (c15 == 8) {
                    c15 = 8;
                } else if (c15 == 34) {
                    c15 = 34;
                } else if (c15 == 39) {
                    c15 = 39;
                } else if (c15 == 92) {
                    c15 = 92;
                }
            }
            sbuf.append((char)c15);
        }
        return sbuf.toString();
    }
}

