/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.v3;

import com.android.apksig.SigningCertificateLineage;
import com.android.apksig.internal.apk.ApkSigningBlockUtils;
import com.android.apksig.internal.apk.ContentDigestAlgorithm;
import com.android.apksig.internal.apk.SignatureAlgorithm;
import com.android.apksig.internal.util.Pair;
import com.android.apksig.util.DataSource;
import com.android.apksig.util.RunnablesExecutor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;

public class V3SchemeSigner {
    public static final int APK_SIGNATURE_SCHEME_V3_BLOCK_ID = -262969152;
    public static final int PROOF_OF_ROTATION_ATTR_ID = 1000370060;
    private final RunnablesExecutor mExecutor;
    private final DataSource mBeforeCentralDir;
    private final DataSource mCentralDir;
    private final DataSource mEocd;
    private final List<ApkSigningBlockUtils.SignerConfig> mSignerConfigs;
    private final int mBlockId;
    private final OptionalInt mOptionalV31MinSdkVersion;
    private final boolean mRotationTargetsDevRelease;

    private V3SchemeSigner(DataSource beforeCentralDir, DataSource centralDir, DataSource eocd, List<ApkSigningBlockUtils.SignerConfig> signerConfigs, RunnablesExecutor executor, int blockId, OptionalInt optionalV31MinSdkVersion, boolean rotationTargetsDevRelease) {
        this.mBeforeCentralDir = beforeCentralDir;
        this.mCentralDir = centralDir;
        this.mEocd = eocd;
        this.mSignerConfigs = signerConfigs;
        this.mExecutor = executor;
        this.mBlockId = blockId;
        this.mOptionalV31MinSdkVersion = optionalV31MinSdkVersion;
        this.mRotationTargetsDevRelease = rotationTargetsDevRelease;
    }

    public static List<SignatureAlgorithm> getSuggestedSignatureAlgorithms(PublicKey signingKey, int minSdkVersion, boolean verityEnabled, boolean deterministicDsaSigning) throws InvalidKeyException {
        String keyAlgorithm = signingKey.getAlgorithm();
        if ("RSA".equalsIgnoreCase(keyAlgorithm)) {
            int modulusLengthBits = ((RSAKey)((Object)signingKey)).getModulus().bitLength();
            if (modulusLengthBits <= 3072) {
                ArrayList<SignatureAlgorithm> algorithms = new ArrayList<SignatureAlgorithm>();
                algorithms.add(SignatureAlgorithm.RSA_PKCS1_V1_5_WITH_SHA256);
                if (verityEnabled) {
                    algorithms.add(SignatureAlgorithm.VERITY_RSA_PKCS1_V1_5_WITH_SHA256);
                }
                return algorithms;
            }
            return Collections.singletonList(SignatureAlgorithm.RSA_PKCS1_V1_5_WITH_SHA512);
        }
        if ("DSA".equalsIgnoreCase(keyAlgorithm)) {
            ArrayList<SignatureAlgorithm> algorithms = new ArrayList<SignatureAlgorithm>();
            algorithms.add(deterministicDsaSigning ? SignatureAlgorithm.DETDSA_WITH_SHA256 : SignatureAlgorithm.DSA_WITH_SHA256);
            if (verityEnabled) {
                algorithms.add(SignatureAlgorithm.VERITY_DSA_WITH_SHA256);
            }
            return algorithms;
        }
        if ("EC".equalsIgnoreCase(keyAlgorithm)) {
            int keySizeBits = ((ECKey)((Object)signingKey)).getParams().getOrder().bitLength();
            if (keySizeBits <= 256) {
                ArrayList<SignatureAlgorithm> algorithms = new ArrayList<SignatureAlgorithm>();
                algorithms.add(SignatureAlgorithm.ECDSA_WITH_SHA256);
                if (verityEnabled) {
                    algorithms.add(SignatureAlgorithm.VERITY_ECDSA_WITH_SHA256);
                }
                return algorithms;
            }
            return Collections.singletonList(SignatureAlgorithm.ECDSA_WITH_SHA512);
        }
        throw new InvalidKeyException("Unsupported key algorithm: " + keyAlgorithm);
    }

    public static ApkSigningBlockUtils.SigningSchemeBlockAndDigests generateApkSignatureSchemeV3Block(RunnablesExecutor executor, DataSource beforeCentralDir, DataSource centralDir, DataSource eocd, List<ApkSigningBlockUtils.SignerConfig> signerConfigs) throws IOException, InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        return new Builder(beforeCentralDir, centralDir, eocd, signerConfigs).setRunnablesExecutor(executor).setBlockId(-262969152).build().generateApkSignatureSchemeV3BlockAndDigests();
    }

    public static byte[] generateV3SignerAttribute(SigningCertificateLineage signingCertificateLineage) {
        byte[] encodedLineage = signingCertificateLineage.encodeSigningCertificateLineage();
        int payloadSize = 8 + encodedLineage.length;
        ByteBuffer result = ByteBuffer.allocate(payloadSize);
        result.order(ByteOrder.LITTLE_ENDIAN);
        result.putInt(4 + encodedLineage.length);
        result.putInt(1000370060);
        result.put(encodedLineage);
        return result.array();
    }

    private static byte[] generateV3RotationMinSdkVersionStrippingProtectionAttribute(int rotationMinSdkVersion) {
        int payloadSize = 12;
        ByteBuffer result = ByteBuffer.allocate(payloadSize);
        result.order(ByteOrder.LITTLE_ENDIAN);
        result.putInt(payloadSize - 4);
        result.putInt(1436519170);
        result.putInt(rotationMinSdkVersion);
        return result.array();
    }

    private static byte[] generateV31RotationTargetsDevReleaseAttribute() {
        int payloadSize = 8;
        ByteBuffer result = ByteBuffer.allocate(payloadSize);
        result.order(ByteOrder.LITTLE_ENDIAN);
        result.putInt(payloadSize - 4);
        result.putInt(-1029262406);
        return result.array();
    }

    public ApkSigningBlockUtils.SigningSchemeBlockAndDigests generateApkSignatureSchemeV3BlockAndDigests() throws IOException, InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        Pair<List<ApkSigningBlockUtils.SignerConfig>, Map<ContentDigestAlgorithm, byte[]>> digestInfo = ApkSigningBlockUtils.computeContentDigests(this.mExecutor, this.mBeforeCentralDir, this.mCentralDir, this.mEocd, this.mSignerConfigs);
        return new ApkSigningBlockUtils.SigningSchemeBlockAndDigests(this.generateApkSignatureSchemeV3Block(digestInfo.getSecond()), digestInfo.getSecond());
    }

    private Pair<byte[], Integer> generateApkSignatureSchemeV3Block(Map<ContentDigestAlgorithm, byte[]> contentDigests) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        ArrayList<byte[]> signerBlocks = new ArrayList<byte[]>(this.mSignerConfigs.size());
        int signerNumber = 0;
        for (ApkSigningBlockUtils.SignerConfig signerConfig : this.mSignerConfigs) {
            byte[] signerBlock;
            ++signerNumber;
            try {
                signerBlock = this.generateSignerBlock(signerConfig, contentDigests);
            }
            catch (InvalidKeyException e15) {
                throw new InvalidKeyException("Signer #" + signerNumber + " failed", e15);
            }
            catch (SignatureException e16) {
                throw new SignatureException("Signer #" + signerNumber + " failed", e16);
            }
            signerBlocks.add(signerBlock);
        }
        return Pair.of(ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedElements(new byte[][]{ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedElements(signerBlocks)}), this.mBlockId);
    }

    private byte[] generateSignerBlock(ApkSigningBlockUtils.SignerConfig signerConfig, Map<ContentDigestAlgorithm, byte[]> contentDigests) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (signerConfig.certificates.isEmpty()) {
            throw new SignatureException("No certificates configured for signer");
        }
        PublicKey publicKey = signerConfig.certificates.get(0).getPublicKey();
        byte[] encodedPublicKey = ApkSigningBlockUtils.encodePublicKey(publicKey);
        V3SignatureSchemeBlock.SignedData signedData = new V3SignatureSchemeBlock.SignedData();
        try {
            signedData.certificates = ApkSigningBlockUtils.encodeCertificates(signerConfig.certificates);
        }
        catch (CertificateEncodingException e15) {
            throw new SignatureException("Failed to encode certificates", e15);
        }
        ArrayList<Pair<Integer, byte[]>> digests = new ArrayList<Pair<Integer, byte[]>>(signerConfig.signatureAlgorithms.size());
        for (SignatureAlgorithm signatureAlgorithm : signerConfig.signatureAlgorithms) {
            ContentDigestAlgorithm contentDigestAlgorithm = signatureAlgorithm.getContentDigestAlgorithm();
            byte[] contentDigest = contentDigests.get((Object)contentDigestAlgorithm);
            if (contentDigest == null) {
                throw new RuntimeException((Object)((Object)contentDigestAlgorithm) + " content digest for " + (Object)((Object)signatureAlgorithm) + " not computed");
            }
            digests.add(Pair.of(signatureAlgorithm.getId(), contentDigest));
        }
        signedData.digests = digests;
        signedData.minSdkVersion = signerConfig.minSdkVersion;
        signedData.maxSdkVersion = signerConfig.maxSdkVersion;
        signedData.additionalAttributes = this.generateAdditionalAttributes(signerConfig);
        V3SignatureSchemeBlock.Signer signer = new V3SignatureSchemeBlock.Signer();
        signer.signedData = this.encodeSignedData(signedData);
        signer.minSdkVersion = signerConfig.minSdkVersion;
        signer.maxSdkVersion = signerConfig.maxSdkVersion;
        signer.publicKey = encodedPublicKey;
        signer.signatures = ApkSigningBlockUtils.generateSignaturesOverData(signerConfig, signer.signedData);
        return this.encodeSigner(signer);
    }

    private byte[] encodeSigner(V3SignatureSchemeBlock.Signer signer) {
        byte[] signedData = ApkSigningBlockUtils.encodeAsLengthPrefixedElement(signer.signedData);
        byte[] signatures = ApkSigningBlockUtils.encodeAsLengthPrefixedElement(ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(signer.signatures));
        byte[] publicKey = ApkSigningBlockUtils.encodeAsLengthPrefixedElement(signer.publicKey);
        int payloadSize = signedData.length + 4 + 4 + signatures.length + publicKey.length;
        ByteBuffer result = ByteBuffer.allocate(payloadSize);
        result.order(ByteOrder.LITTLE_ENDIAN);
        result.put(signedData);
        result.putInt(signer.minSdkVersion);
        result.putInt(signer.maxSdkVersion);
        result.put(signatures);
        result.put(publicKey);
        return result.array();
    }

    private byte[] encodeSignedData(V3SignatureSchemeBlock.SignedData signedData) {
        byte[] digests = ApkSigningBlockUtils.encodeAsLengthPrefixedElement(ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(signedData.digests));
        byte[] certs = ApkSigningBlockUtils.encodeAsLengthPrefixedElement(ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedElements(signedData.certificates));
        byte[] attributes = ApkSigningBlockUtils.encodeAsLengthPrefixedElement(signedData.additionalAttributes);
        int payloadSize = digests.length + certs.length + 4 + 4 + attributes.length;
        ByteBuffer result = ByteBuffer.allocate(payloadSize);
        result.order(ByteOrder.LITTLE_ENDIAN);
        result.put(digests);
        result.put(certs);
        result.putInt(signedData.minSdkVersion);
        result.putInt(signedData.maxSdkVersion);
        result.put(attributes);
        return result.array();
    }

    private byte[] generateAdditionalAttributes(ApkSigningBlockUtils.SignerConfig signerConfig) {
        ArrayList<byte[]> attributes = new ArrayList<byte[]>();
        if (signerConfig.signingCertificateLineage != null) {
            attributes.add(V3SchemeSigner.generateV3SignerAttribute(signerConfig.signingCertificateLineage));
        }
        if ((this.mRotationTargetsDevRelease || signerConfig.signerTargetsDevRelease) && this.mBlockId == 462663009) {
            attributes.add(V3SchemeSigner.generateV31RotationTargetsDevReleaseAttribute());
        }
        if (this.mOptionalV31MinSdkVersion.isPresent() && this.mBlockId == -262969152) {
            attributes.add(V3SchemeSigner.generateV3RotationMinSdkVersionStrippingProtectionAttribute(this.mOptionalV31MinSdkVersion.getAsInt()));
        }
        int attributesSize = attributes.stream().mapToInt(attribute -> ((byte[])attribute).length).sum();
        byte[] attributesBuffer = new byte[attributesSize];
        if (attributesSize == 0) {
            return new byte[0];
        }
        int index = 0;
        for (byte[] attribute2 : attributes) {
            System.arraycopy(attribute2, 0, attributesBuffer, index, attribute2.length);
            index += attribute2.length;
        }
        return attributesBuffer;
    }

    public static class Builder {
        private final DataSource mBeforeCentralDir;
        private final DataSource mCentralDir;
        private final DataSource mEocd;
        private final List<ApkSigningBlockUtils.SignerConfig> mSignerConfigs;
        private RunnablesExecutor mExecutor = RunnablesExecutor.MULTI_THREADED;
        private int mBlockId = -262969152;
        private OptionalInt mOptionalV31MinSdkVersion = OptionalInt.empty();
        private boolean mRotationTargetsDevRelease = false;

        public Builder(DataSource beforeCentralDir, DataSource centralDir, DataSource eocd, List<ApkSigningBlockUtils.SignerConfig> signerConfigs) {
            this.mBeforeCentralDir = beforeCentralDir;
            this.mCentralDir = centralDir;
            this.mEocd = eocd;
            this.mSignerConfigs = signerConfigs;
        }

        public Builder setRunnablesExecutor(RunnablesExecutor executor) {
            this.mExecutor = executor;
            return this;
        }

        public Builder setBlockId(int blockId) {
            this.mBlockId = blockId;
            return this;
        }

        public Builder setRotationMinSdkVersion(int rotationMinSdkVersion) {
            return this.setMinSdkVersionForV31(rotationMinSdkVersion);
        }

        public Builder setMinSdkVersionForV31(int minSdkVersion) {
            if (minSdkVersion == 34) {
                minSdkVersion = 33;
            }
            this.mOptionalV31MinSdkVersion = OptionalInt.of(minSdkVersion);
            return this;
        }

        public Builder setRotationTargetsDevRelease(boolean enabled) {
            this.mRotationTargetsDevRelease = enabled;
            return this;
        }

        public V3SchemeSigner build() {
            return new V3SchemeSigner(this.mBeforeCentralDir, this.mCentralDir, this.mEocd, this.mSignerConfigs, this.mExecutor, this.mBlockId, this.mOptionalV31MinSdkVersion, this.mRotationTargetsDevRelease);
        }
    }

    private static final class V3SignatureSchemeBlock {
        private V3SignatureSchemeBlock() {
        }

        private static final class SignedData {
            public List<Pair<Integer, byte[]>> digests;
            public List<byte[]> certificates;
            public int minSdkVersion;
            public int maxSdkVersion;
            public byte[] additionalAttributes;

            private SignedData() {
            }
        }

        private static final class Signer {
            public byte[] signedData;
            public int minSdkVersion;
            public int maxSdkVersion;
            public List<Pair<Integer, byte[]>> signatures;
            public byte[] publicKey;

            private Signer() {
            }
        }
    }
}

