/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.code;

import com.android.dx.util.FixedSizeList;

public final class LineNumberList
extends FixedSizeList {
    public static final LineNumberList EMPTY = new LineNumberList(0);

    public static LineNumberList concat(LineNumberList list1, LineNumberList list2) {
        int i15;
        if (list1 == EMPTY) {
            return list2;
        }
        int sz12 = list1.size();
        int sz22 = list2.size();
        LineNumberList result = new LineNumberList(sz12 + sz22);
        for (i15 = 0; i15 < sz12; ++i15) {
            result.set(i15, list1.get(i15));
        }
        for (i15 = 0; i15 < sz22; ++i15) {
            result.set(sz12 + i15, list2.get(i15));
        }
        return result;
    }

    public LineNumberList(int count) {
        super(count);
    }

    public Item get(int n15) {
        return (Item)this.get0(n15);
    }

    public void set(int n15, Item item) {
        if (item == null) {
            throw new NullPointerException("item == null");
        }
        this.set0(n15, item);
    }

    public void set(int n15, int startPc, int lineNumber) {
        this.set0(n15, new Item(startPc, lineNumber));
    }

    public int pcToLine(int pc5) {
        int sz4 = this.size();
        int bestPc = -1;
        int bestLine = -1;
        for (int i15 = 0; i15 < sz4; ++i15) {
            Item one = this.get(i15);
            int onePc = one.getStartPc();
            if (onePc > pc5 || onePc <= bestPc) continue;
            bestPc = onePc;
            bestLine = one.getLineNumber();
            if (bestPc == pc5) break;
        }
        return bestLine;
    }

    public static class Item {
        private final int startPc;
        private final int lineNumber;

        public Item(int startPc, int lineNumber) {
            if (startPc < 0) {
                throw new IllegalArgumentException("startPc < 0");
            }
            if (lineNumber < 0) {
                throw new IllegalArgumentException("lineNumber < 0");
            }
            this.startPc = startPc;
            this.lineNumber = lineNumber;
        }

        public int getStartPc() {
            return this.startPc;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }
    }
}

