/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.code;

import com.android.dx.rop.code.LocalItem;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.type.Type;
import com.android.dx.util.FixedSizeList;

public final class LocalVariableList
extends FixedSizeList {
    public static final LocalVariableList EMPTY = new LocalVariableList(0);

    public static LocalVariableList concat(LocalVariableList list1, LocalVariableList list2) {
        int i15;
        if (list1 == EMPTY) {
            return list2;
        }
        int sz12 = list1.size();
        int sz22 = list2.size();
        LocalVariableList result = new LocalVariableList(sz12 + sz22);
        for (i15 = 0; i15 < sz12; ++i15) {
            result.set(i15, list1.get(i15));
        }
        for (i15 = 0; i15 < sz22; ++i15) {
            result.set(sz12 + i15, list2.get(i15));
        }
        result.setImmutable();
        return result;
    }

    public static LocalVariableList mergeDescriptorsAndSignatures(LocalVariableList descriptorList, LocalVariableList signatureList) {
        int descriptorSize = descriptorList.size();
        LocalVariableList result = new LocalVariableList(descriptorSize);
        for (int i15 = 0; i15 < descriptorSize; ++i15) {
            Item item = descriptorList.get(i15);
            Item signatureItem = signatureList.itemToLocal(item);
            if (signatureItem != null) {
                CstString signature = signatureItem.getSignature();
                item = item.withSignature(signature);
            }
            result.set(i15, item);
        }
        result.setImmutable();
        return result;
    }

    public LocalVariableList(int count) {
        super(count);
    }

    public Item get(int n15) {
        return (Item)this.get0(n15);
    }

    public void set(int n15, Item item) {
        if (item == null) {
            throw new NullPointerException("item == null");
        }
        this.set0(n15, item);
    }

    public void set(int n15, int startPc, int length, CstString name, CstString descriptor2, CstString signature, int index) {
        this.set0(n15, new Item(startPc, length, name, descriptor2, signature, index));
    }

    public Item itemToLocal(Item item) {
        int sz4 = this.size();
        for (int i15 = 0; i15 < sz4; ++i15) {
            Item one = (Item)this.get0(i15);
            if (one == null || !one.matchesAllButType(item)) continue;
            return one;
        }
        return null;
    }

    public Item pcAndIndexToLocal(int pc5, int index) {
        int sz4 = this.size();
        for (int i15 = 0; i15 < sz4; ++i15) {
            Item one = (Item)this.get0(i15);
            if (one == null || !one.matchesPcAndIndex(pc5, index)) continue;
            return one;
        }
        return null;
    }

    public static class Item {
        private final int startPc;
        private final int length;
        private final CstString name;
        private final CstString descriptor;
        private final CstString signature;
        private final int index;

        public Item(int startPc, int length, CstString name, CstString descriptor2, CstString signature, int index) {
            if (startPc < 0) {
                throw new IllegalArgumentException("startPc < 0");
            }
            if (length < 0) {
                throw new IllegalArgumentException("length < 0");
            }
            if (name == null) {
                throw new NullPointerException("name == null");
            }
            if (descriptor2 == null && signature == null) {
                throw new NullPointerException("(descriptor == null) && (signature == null)");
            }
            if (index < 0) {
                throw new IllegalArgumentException("index < 0");
            }
            this.startPc = startPc;
            this.length = length;
            this.name = name;
            this.descriptor = descriptor2;
            this.signature = signature;
            this.index = index;
        }

        public int getStartPc() {
            return this.startPc;
        }

        public int getLength() {
            return this.length;
        }

        public CstString getDescriptor() {
            return this.descriptor;
        }

        public LocalItem getLocalItem() {
            return LocalItem.make(this.name, this.signature);
        }

        private CstString getSignature() {
            return this.signature;
        }

        public int getIndex() {
            return this.index;
        }

        public Type getType() {
            return Type.intern(this.descriptor.getString());
        }

        public Item withSignature(CstString newSignature) {
            return new Item(this.startPc, this.length, this.name, this.descriptor, newSignature, this.index);
        }

        public boolean matchesPcAndIndex(int pc5, int index) {
            return index == this.index && pc5 >= this.startPc && pc5 < this.startPc + this.length;
        }

        public boolean matchesAllButType(Item other) {
            return this.startPc == other.startPc && this.length == other.length && this.index == other.index && this.name.equals(other.name);
        }
    }
}

