/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.baksmali;

import com.android.tools.smali.baksmali.AnalysisArguments;
import com.android.tools.smali.baksmali.BaksmaliOptions;
import com.android.tools.smali.baksmali.DexInputCommand;
import com.android.tools.smali.baksmali.formatter.BaksmaliFormatter;
import com.android.tools.smali.dexlib2.analysis.ClassProto;
import com.android.tools.smali.dexlib2.iface.ClassDef;
import com.android.tools.smali.dexlib2.iface.reference.FieldReference;
import com.android.tools.smali.util.SparseArray;
import com.android.tools.smali.util.jcommander.ExtendedParameters;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;

@Parameters(commandDescription="Lists the instance field offsets for classes in a dex file.")
@ExtendedParameters(commandName="fieldoffsets", commandAliases={"fieldoffset", "fo"})
public class ListFieldOffsetsCommand
extends DexInputCommand {
    @Parameter(names={"-h", "-?", "--help"}, help=true, description="Show usage information")
    private boolean help;
    @ParametersDelegate
    private AnalysisArguments analysisArguments = new AnalysisArguments();

    public ListFieldOffsetsCommand(@Nonnull List<JCommander> commandAncestors) {
        super(commandAncestors);
    }

    @Override
    public void run() {
        if (this.help || this.inputList == null || this.inputList.isEmpty()) {
            this.usage();
            return;
        }
        if (this.inputList.size() > 1) {
            System.err.println("Too many files specified");
            this.usage();
            return;
        }
        String input = (String)this.inputList.get(0);
        this.loadDexFile(input);
        BaksmaliOptions options = this.getOptions();
        BaksmaliFormatter formatter = new BaksmaliFormatter();
        try {
            for (ClassDef classDef : this.dexFile.getClasses()) {
                ClassProto classProto = (ClassProto)options.classPath.getClass(classDef);
                SparseArray<FieldReference> fields2 = classProto.getInstanceFields();
                String className = "Class " + formatter.getType(classDef.getType()) + " : " + fields2.size() + " instance fields\n";
                System.out.write(className.getBytes());
                for (int i15 = 0; i15 < fields2.size(); ++i15) {
                    String field = fields2.keyAt(i15) + ":" + fields2.valueAt(i15).getType() + " " + fields2.valueAt(i15).getName() + "\n";
                    System.out.write(field.getBytes());
                }
                System.out.write("\n".getBytes());
            }
            System.out.close();
        }
        catch (IOException ex4) {
            throw new RuntimeException(ex4);
        }
    }

    @Nonnull
    private BaksmaliOptions getOptions() {
        if (this.dexFile == null) {
            throw new IllegalStateException("You must call loadDexFile first");
        }
        BaksmaliOptions options = new BaksmaliOptions();
        options.apiLevel = this.apiLevel;
        try {
            options.classPath = this.analysisArguments.loadClassPathForDexFile(this.inputFile.getAbsoluteFile().getParentFile(), this.dexEntry, false);
        }
        catch (Exception ex4) {
            System.err.println("Error occurred while loading class path files.");
            ex4.printStackTrace(System.err);
            System.exit(-1);
        }
        return options;
    }
}

