/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.rewriter;

import com.android.tools.smali.dexlib2.base.reference.BaseMethodHandleReference;
import com.android.tools.smali.dexlib2.base.reference.BaseMethodProtoReference;
import com.android.tools.smali.dexlib2.base.reference.BaseTypeReference;
import com.android.tools.smali.dexlib2.base.value.BaseFieldEncodedValue;
import com.android.tools.smali.dexlib2.base.value.BaseMethodEncodedValue;
import com.android.tools.smali.dexlib2.base.value.BaseMethodHandleEncodedValue;
import com.android.tools.smali.dexlib2.base.value.BaseMethodTypeEncodedValue;
import com.android.tools.smali.dexlib2.base.value.BaseTypeEncodedValue;
import com.android.tools.smali.dexlib2.iface.reference.FieldReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodHandleReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodProtoReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodReference;
import com.android.tools.smali.dexlib2.iface.reference.Reference;
import com.android.tools.smali.dexlib2.iface.reference.TypeReference;
import com.android.tools.smali.dexlib2.iface.value.EncodedValue;
import com.android.tools.smali.dexlib2.iface.value.FieldEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.MethodEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.MethodHandleEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.MethodTypeEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.TypeEncodedValue;
import com.android.tools.smali.dexlib2.rewriter.Rewriter;
import com.android.tools.smali.dexlib2.rewriter.Rewriters;
import com.android.tools.smali.util.ExceptionWithContext;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RewriterUtils {
    @Nullable
    public static <T> T rewriteNullable(@Nonnull Rewriter<T> rewriter, @Nullable T value) {
        return value == null ? null : (T)rewriter.rewrite(value);
    }

    public static <T> Set<T> rewriteSet(final @Nonnull Rewriter<T> rewriter, final @Nonnull Set<? extends T> set) {
        return new AbstractSet<T>(){

            @Override
            @Nonnull
            public Iterator<T> iterator() {
                final Iterator iterator2 = set.iterator();
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return iterator2.hasNext();
                    }

                    @Override
                    public T next() {
                        return RewriterUtils.rewriteNullable(rewriter, iterator2.next());
                    }

                    @Override
                    public void remove() {
                        iterator2.remove();
                    }
                };
            }

            @Override
            public int size() {
                return set.size();
            }
        };
    }

    public static <T> List<T> rewriteList(final @Nonnull Rewriter<T> rewriter, final @Nonnull List<? extends T> list2) {
        return new AbstractList<T>(){

            @Override
            public T get(int i15) {
                return RewriterUtils.rewriteNullable(rewriter, list2.get(i15));
            }

            @Override
            public int size() {
                return list2.size();
            }
        };
    }

    public static <T> Iterable<T> rewriteIterable(final @Nonnull Rewriter<T> rewriter, final @Nonnull Iterable<? extends T> iterable) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final Iterator iterator2 = iterable.iterator();
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return iterator2.hasNext();
                    }

                    @Override
                    public T next() {
                        return RewriterUtils.rewriteNullable(rewriter, iterator2.next());
                    }

                    @Override
                    public void remove() {
                        iterator2.remove();
                    }
                };
            }
        };
    }

    public static TypeReference rewriteTypeReference(final @Nonnull Rewriter<String> typeRewriter, final @Nonnull TypeReference typeReference) {
        return new BaseTypeReference(){

            @Override
            @Nonnull
            public String getType() {
                return typeRewriter.rewrite(typeReference.getType());
            }
        };
    }

    @Nonnull
    public static MethodHandleReference rewriteMethodHandleReference(final @Nonnull Rewriters rewriters, final @Nonnull MethodHandleReference methodHandleReference) {
        switch (methodHandleReference.getMethodHandleType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return new BaseMethodHandleReference(){

                    @Override
                    public int getMethodHandleType() {
                        return methodHandleReference.getMethodHandleType();
                    }

                    @Override
                    @Nonnull
                    public Reference getMemberReference() {
                        return rewriters.getFieldReferenceRewriter().rewrite((FieldReference)methodHandleReference.getMemberReference());
                    }
                };
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return new BaseMethodHandleReference(){

                    @Override
                    public int getMethodHandleType() {
                        return methodHandleReference.getMethodHandleType();
                    }

                    @Override
                    @Nonnull
                    public Reference getMemberReference() {
                        return rewriters.getMethodReferenceRewriter().rewrite((MethodReference)methodHandleReference.getMemberReference());
                    }
                };
            }
        }
        throw new ExceptionWithContext("Invalid method handle type: %d", methodHandleReference.getMethodHandleType());
    }

    @Nonnull
    public static MethodProtoReference rewriteMethodProtoReference(final @Nonnull Rewriter<String> typeRewriter, final @Nonnull MethodProtoReference methodProtoReference) {
        return new BaseMethodProtoReference(){

            @Override
            @Nonnull
            public List<? extends CharSequence> getParameterTypes() {
                return RewriterUtils.rewriteList(typeRewriter, methodProtoReference.getParameterTypes().stream().map(new Function<CharSequence, String>(){

                    @Override
                    @Nonnull
                    public String apply(CharSequence input) {
                        return input.toString();
                    }
                }).collect(Collectors.toList()));
            }

            @Override
            @Nonnull
            public String getReturnType() {
                return typeRewriter.rewrite(methodProtoReference.getReturnType());
            }
        };
    }

    @Nonnull
    public static EncodedValue rewriteValue(final @Nonnull Rewriters rewriters, final @Nonnull EncodedValue encodedValue) {
        switch (encodedValue.getValueType()) {
            case 4: 
            case 6: 
            case 16: 
            case 17: 
            case 23: {
                return encodedValue;
            }
            case 21: {
                return new BaseMethodTypeEncodedValue(){

                    @Override
                    @Nonnull
                    public MethodProtoReference getValue() {
                        return RewriterUtils.rewriteMethodProtoReference(rewriters.getTypeRewriter(), ((MethodTypeEncodedValue)encodedValue).getValue());
                    }
                };
            }
            case 22: {
                return new BaseMethodHandleEncodedValue(){

                    @Override
                    @Nonnull
                    public MethodHandleReference getValue() {
                        return RewriterUtils.rewriteMethodHandleReference(rewriters, ((MethodHandleEncodedValue)encodedValue).getValue());
                    }
                };
            }
            case 24: {
                return new BaseTypeEncodedValue(){

                    @Override
                    @Nonnull
                    public String getValue() {
                        return rewriters.getTypeRewriter().rewrite(((TypeEncodedValue)encodedValue).getValue());
                    }
                };
            }
            case 25: {
                return new BaseFieldEncodedValue(){

                    @Override
                    @Nonnull
                    public FieldReference getValue() {
                        return rewriters.getFieldReferenceRewriter().rewrite(((FieldEncodedValue)encodedValue).getValue());
                    }
                };
            }
            case 26: {
                return new BaseMethodEncodedValue(){

                    @Override
                    @Nonnull
                    public MethodReference getValue() {
                        return rewriters.getMethodReferenceRewriter().rewrite(((MethodEncodedValue)encodedValue).getValue());
                    }
                };
            }
        }
        throw new ExceptionWithContext("Unsupported encoded value type: %d", encodedValue.getValueType());
    }
}

