/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSeparatorUI;

public class FlatSeparatorUI
extends BasicSeparatorUI
implements FlatStylingSupport.StyleableUI,
PropertyChangeListener {
    @FlatStylingSupport.Styleable
    protected int height;
    @FlatStylingSupport.Styleable
    protected int stripeWidth;
    @FlatStylingSupport.Styleable
    protected int stripeIndent;
    private final boolean shared;
    private boolean defaults_initialized = false;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent c15) {
        return FlatUIUtils.canUseSharedUI(c15) ? FlatUIUtils.createSharedUI(FlatSeparatorUI.class, () -> new FlatSeparatorUI(true)) : new FlatSeparatorUI(false);
    }

    protected FlatSeparatorUI(boolean shared) {
        this.shared = shared;
    }

    protected String getPropertyPrefix() {
        return "Separator";
    }

    @Override
    public void installUI(JComponent c15) {
        super.installUI(c15);
        this.installStyle((JSeparator)c15);
    }

    @Override
    protected void installDefaults(JSeparator s15) {
        super.installDefaults(s15);
        if (!this.defaults_initialized) {
            String prefix = this.getPropertyPrefix();
            this.height = UIManager.getInt(prefix + ".height");
            this.stripeWidth = UIManager.getInt(prefix + ".stripeWidth");
            this.stripeIndent = UIManager.getInt(prefix + ".stripeIndent");
            this.defaults_initialized = true;
        }
    }

    @Override
    protected void uninstallDefaults(JSeparator s15) {
        super.uninstallDefaults(s15);
        this.defaults_initialized = false;
        this.oldStyleValues = null;
    }

    @Override
    protected void installListeners(JSeparator s15) {
        super.installListeners(s15);
        s15.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners(JSeparator s15) {
        super.uninstallListeners(s15);
        s15.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e15) {
        switch (e15.getPropertyName()) {
            case "FlatLaf.style": 
            case "FlatLaf.styleClass": {
                JSeparator s15 = (JSeparator)e15.getSource();
                if (this.shared && FlatStylingSupport.hasStyleProperty(s15)) {
                    s15.updateUI();
                } else {
                    this.installStyle(s15);
                }
                s15.revalidate();
                HiDPIUtils.repaint(s15);
            }
        }
    }

    protected void installStyle(JSeparator s15) {
        try {
            this.applyStyle(s15, FlatStylingSupport.getResolvedStyle(s15, this.getStyleType()));
        }
        catch (RuntimeException ex4) {
            LoggingFacade.INSTANCE.logSevere(null, ex4);
        }
    }

    String getStyleType() {
        return "Separator";
    }

    protected void applyStyle(JSeparator s15, Object style) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, style, (key, value) -> this.applyStyleProperty(s15, (String)key, value));
    }

    protected Object applyStyleProperty(JSeparator s15, String key, Object value) {
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, s15, key, value);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent c15) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent c15, String key) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g15, JComponent c15) {
        Graphics2D g25 = (Graphics2D)g15.create();
        try {
            FlatUIUtils.setRenderingHints(g25);
            g25.setColor(c15.getForeground());
            float width = UIScale.scale((float)this.stripeWidth);
            float indent = UIScale.scale((float)this.stripeIndent);
            if (((JSeparator)c15).getOrientation() == 1) {
                g25.fill(new Rectangle2D.Float(indent, 0.0f, width, c15.getHeight()));
            } else {
                g25.fill(new Rectangle2D.Float(0.0f, indent, c15.getWidth(), width));
            }
        }
        finally {
            g25.dispose();
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c15) {
        if (((JSeparator)c15).getOrientation() == 1) {
            return new Dimension(UIScale.scale(this.height), 0);
        }
        return new Dimension(0, UIScale.scale(this.height));
    }
}

