/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

@J2ktIncompatible
@GwtIncompatible
public final class LittleEndianDataOutputStream
extends FilterOutputStream
implements DataOutput {
    public LittleEndianDataOutputStream(OutputStream out) {
        super(new DataOutputStream(Preconditions.checkNotNull(out)));
    }

    @Override
    public void write(byte[] b15, int off, int len) throws IOException {
        this.out.write(b15, off, len);
    }

    @Override
    public void writeBoolean(boolean v15) throws IOException {
        ((DataOutputStream)this.out).writeBoolean(v15);
    }

    @Override
    public void writeByte(int v15) throws IOException {
        ((DataOutputStream)this.out).writeByte(v15);
    }

    @Override
    @Deprecated
    public void writeBytes(String s15) throws IOException {
        ((DataOutputStream)this.out).writeBytes(s15);
    }

    @Override
    public void writeChar(int v15) throws IOException {
        this.writeShort(v15);
    }

    @Override
    public void writeChars(String s15) throws IOException {
        for (int i15 = 0; i15 < s15.length(); ++i15) {
            this.writeChar(s15.charAt(i15));
        }
    }

    @Override
    public void writeDouble(double v15) throws IOException {
        this.writeLong(Double.doubleToLongBits(v15));
    }

    @Override
    public void writeFloat(float v15) throws IOException {
        this.writeInt(Float.floatToIntBits(v15));
    }

    @Override
    public void writeInt(int v15) throws IOException {
        this.out.write(0xFF & v15);
        this.out.write(0xFF & v15 >> 8);
        this.out.write(0xFF & v15 >> 16);
        this.out.write(0xFF & v15 >> 24);
    }

    @Override
    public void writeLong(long v15) throws IOException {
        ((DataOutputStream)this.out).writeLong(Long.reverseBytes(v15));
    }

    @Override
    public void writeShort(int v15) throws IOException {
        this.out.write(0xFF & v15);
        this.out.write(0xFF & v15 >> 8);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        ((DataOutputStream)this.out).writeUTF(str);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

