/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.stream;

import com.google.gson.Strictness;
import com.google.gson.internal.JsonReaderInternalAccess;
import com.google.gson.internal.TroubleshootingGuide;
import com.google.gson.internal.bind.JsonTreeReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Objects;

public class JsonReader
implements Closeable {
    private static final long MIN_INCOMPLETE_INTEGER = -922337203685477580L;
    private static final int PEEKED_NONE = 0;
    private static final int PEEKED_BEGIN_OBJECT = 1;
    private static final int PEEKED_END_OBJECT = 2;
    private static final int PEEKED_BEGIN_ARRAY = 3;
    private static final int PEEKED_END_ARRAY = 4;
    private static final int PEEKED_TRUE = 5;
    private static final int PEEKED_FALSE = 6;
    private static final int PEEKED_NULL = 7;
    private static final int PEEKED_SINGLE_QUOTED = 8;
    private static final int PEEKED_DOUBLE_QUOTED = 9;
    private static final int PEEKED_UNQUOTED = 10;
    private static final int PEEKED_BUFFERED = 11;
    private static final int PEEKED_SINGLE_QUOTED_NAME = 12;
    private static final int PEEKED_DOUBLE_QUOTED_NAME = 13;
    private static final int PEEKED_UNQUOTED_NAME = 14;
    private static final int PEEKED_LONG = 15;
    private static final int PEEKED_NUMBER = 16;
    private static final int PEEKED_EOF = 17;
    private static final int NUMBER_CHAR_NONE = 0;
    private static final int NUMBER_CHAR_SIGN = 1;
    private static final int NUMBER_CHAR_DIGIT = 2;
    private static final int NUMBER_CHAR_DECIMAL = 3;
    private static final int NUMBER_CHAR_FRACTION_DIGIT = 4;
    private static final int NUMBER_CHAR_EXP_E = 5;
    private static final int NUMBER_CHAR_EXP_SIGN = 6;
    private static final int NUMBER_CHAR_EXP_DIGIT = 7;
    private final Reader in;
    private Strictness strictness = Strictness.LEGACY_STRICT;
    static final int DEFAULT_NESTING_LIMIT = 255;
    private int nestingLimit = 255;
    static final int BUFFER_SIZE = 1024;
    private final char[] buffer = new char[1024];
    private int pos = 0;
    private int limit = 0;
    private int lineNumber = 0;
    private int lineStart = 0;
    int peeked = 0;
    private long peekedLong;
    private int peekedNumberLength;
    private String peekedString;
    private int[] stack = new int[32];
    private int stackSize = 0;
    private String[] pathNames;
    private int[] pathIndices;

    public JsonReader(Reader in4) {
        this.stack[this.stackSize++] = 6;
        this.pathNames = new String[32];
        this.pathIndices = new int[32];
        this.in = Objects.requireNonNull(in4, "in == null");
    }

    @Deprecated
    public final void setLenient(boolean lenient) {
        this.setStrictness(lenient ? Strictness.LENIENT : Strictness.LEGACY_STRICT);
    }

    public final boolean isLenient() {
        return this.strictness == Strictness.LENIENT;
    }

    public final void setStrictness(Strictness strictness) {
        Objects.requireNonNull(strictness);
        this.strictness = strictness;
    }

    public final Strictness getStrictness() {
        return this.strictness;
    }

    public final void setNestingLimit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("Invalid nesting limit: " + limit);
        }
        this.nestingLimit = limit;
    }

    public final int getNestingLimit() {
        return this.nestingLimit;
    }

    public void beginArray() throws IOException {
        int p15 = this.peeked;
        if (p15 == 0) {
            p15 = this.doPeek();
        }
        if (p15 != 3) {
            throw this.unexpectedTokenError("BEGIN_ARRAY");
        }
        this.push(1);
        this.pathIndices[this.stackSize - 1] = 0;
        this.peeked = 0;
    }

    public void endArray() throws IOException {
        int p15 = this.peeked;
        if (p15 == 0) {
            p15 = this.doPeek();
        }
        if (p15 == 4) {
            --this.stackSize;
        } else {
            throw this.unexpectedTokenError("END_ARRAY");
        }
        int n15 = this.stackSize - 1;
        this.pathIndices[n15] = this.pathIndices[n15] + 1;
        this.peeked = 0;
    }

    public void beginObject() throws IOException {
        int p15 = this.peeked;
        if (p15 == 0) {
            p15 = this.doPeek();
        }
        if (p15 != 1) {
            throw this.unexpectedTokenError("BEGIN_OBJECT");
        }
        this.push(3);
        this.peeked = 0;
    }

    public void endObject() throws IOException {
        int p15 = this.peeked;
        if (p15 == 0) {
            p15 = this.doPeek();
        }
        if (p15 == 2) {
            --this.stackSize;
        } else {
            throw this.unexpectedTokenError("END_OBJECT");
        }
        this.pathNames[this.stackSize] = null;
        int n15 = this.stackSize - 1;
        this.pathIndices[n15] = this.pathIndices[n15] + 1;
        this.peeked = 0;
    }

    public boolean hasNext() throws IOException {
        int p15 = this.peeked;
        if (p15 == 0) {
            p15 = this.doPeek();
        }
        return p15 != 2 && p15 != 4 && p15 != 17;
    }

    public JsonToken peek() throws IOException {
        int p15 = this.peeked;
        if (p15 == 0) {
            p15 = this.doPeek();
        }
        switch (p15) {
            case 1: {
                return JsonToken.BEGIN_OBJECT;
            }
            case 2: {
                return JsonToken.END_OBJECT;
            }
            case 3: {
                return JsonToken.BEGIN_ARRAY;
            }
            case 4: {
                return JsonToken.END_ARRAY;
            }
            case 12: 
            case 13: 
            case 14: {
                return JsonToken.NAME;
            }
            case 5: 
            case 6: {
                return JsonToken.BOOLEAN;
            }
            case 7: {
                return JsonToken.NULL;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return JsonToken.STRING;
            }
            case 15: 
            case 16: {
                return JsonToken.NUMBER;
            }
            case 17: {
                return JsonToken.END_DOCUMENT;
            }
        }
        throw new AssertionError();
    }

    int doPeek() throws IOException {
        int c15;
        int peekStack;
        block45: {
            block47: {
                block46: {
                    block44: {
                        peekStack = this.stack[this.stackSize - 1];
                        if (peekStack != 1) break block44;
                        this.stack[this.stackSize - 1] = 2;
                        break block45;
                    }
                    if (peekStack != 2) break block46;
                    c15 = this.nextNonWhitespace(true);
                    switch (c15) {
                        case 93: {
                            this.peeked = 4;
                            return this.peeked;
                        }
                        case 59: {
                            this.checkLenient();
                        }
                        case 44: {
                            break;
                        }
                        default: {
                            throw this.syntaxError("Unterminated array");
                        }
                    }
                    break block45;
                }
                if (peekStack == 3 || peekStack == 5) {
                    int c16;
                    this.stack[this.stackSize - 1] = 4;
                    if (peekStack == 5) {
                        c16 = this.nextNonWhitespace(true);
                        switch (c16) {
                            case 125: {
                                this.peeked = 2;
                                return this.peeked;
                            }
                            case 59: {
                                this.checkLenient();
                            }
                            case 44: {
                                break;
                            }
                            default: {
                                throw this.syntaxError("Unterminated object");
                            }
                        }
                    }
                    c16 = this.nextNonWhitespace(true);
                    switch (c16) {
                        case 34: {
                            this.peeked = 13;
                            return this.peeked;
                        }
                        case 39: {
                            this.checkLenient();
                            this.peeked = 12;
                            return this.peeked;
                        }
                        case 125: {
                            if (peekStack != 5) {
                                this.peeked = 2;
                                return this.peeked;
                            }
                            throw this.syntaxError("Expected name");
                        }
                    }
                    this.checkLenient();
                    --this.pos;
                    if (this.isLiteral((char)c16)) {
                        this.peeked = 14;
                        return this.peeked;
                    }
                    throw this.syntaxError("Expected name");
                }
                if (peekStack != 4) break block47;
                this.stack[this.stackSize - 1] = 5;
                c15 = this.nextNonWhitespace(true);
                switch (c15) {
                    case 58: {
                        break;
                    }
                    case 61: {
                        this.checkLenient();
                        if ((this.pos < this.limit || this.fillBuffer(1)) && this.buffer[this.pos] == '>') {
                            ++this.pos;
                            break;
                        }
                        break block45;
                    }
                    default: {
                        throw this.syntaxError("Expected ':'");
                    }
                }
                break block45;
            }
            if (peekStack == 6) {
                if (this.strictness == Strictness.LENIENT) {
                    this.consumeNonExecutePrefix();
                }
                this.stack[this.stackSize - 1] = 7;
            } else if (peekStack == 7) {
                c15 = this.nextNonWhitespace(false);
                if (c15 == -1) {
                    this.peeked = 17;
                    return this.peeked;
                }
                this.checkLenient();
                --this.pos;
            } else if (peekStack == 8) {
                throw new IllegalStateException("JsonReader is closed");
            }
        }
        c15 = this.nextNonWhitespace(true);
        switch (c15) {
            case 93: {
                if (peekStack == 1) {
                    this.peeked = 4;
                    return this.peeked;
                }
            }
            case 44: 
            case 59: {
                if (peekStack == 1 || peekStack == 2) {
                    this.checkLenient();
                    --this.pos;
                    this.peeked = 7;
                    return this.peeked;
                }
                throw this.syntaxError("Unexpected value");
            }
            case 39: {
                this.checkLenient();
                this.peeked = 8;
                return this.peeked;
            }
            case 34: {
                this.peeked = 9;
                return this.peeked;
            }
            case 91: {
                this.peeked = 3;
                return this.peeked;
            }
            case 123: {
                this.peeked = 1;
                return this.peeked;
            }
        }
        --this.pos;
        int result = this.peekKeyword();
        if (result != 0) {
            return result;
        }
        result = this.peekNumber();
        if (result != 0) {
            return result;
        }
        if (!this.isLiteral(this.buffer[this.pos])) {
            throw this.syntaxError("Expected value");
        }
        this.checkLenient();
        this.peeked = 10;
        return this.peeked;
    }

    private int peekKeyword() throws IOException {
        int peeking;
        String keywordUpper;
        String keyword;
        char c15 = this.buffer[this.pos];
        if (c15 == 't' || c15 == 'T') {
            keyword = "true";
            keywordUpper = "TRUE";
            peeking = 5;
        } else if (c15 == 'f' || c15 == 'F') {
            keyword = "false";
            keywordUpper = "FALSE";
            peeking = 6;
        } else if (c15 == 'n' || c15 == 'N') {
            keyword = "null";
            keywordUpper = "NULL";
            peeking = 7;
        } else {
            return 0;
        }
        boolean allowsUpperCased = this.strictness != Strictness.STRICT;
        int length = keyword.length();
        for (int i15 = 0; i15 < length; ++i15) {
            boolean matched;
            if (this.pos + i15 >= this.limit && !this.fillBuffer(i15 + 1)) {
                return 0;
            }
            c15 = this.buffer[this.pos + i15];
            boolean bl4 = matched = c15 == keyword.charAt(i15) || allowsUpperCased && c15 == keywordUpper.charAt(i15);
            if (matched) continue;
            return 0;
        }
        if ((this.pos + length < this.limit || this.fillBuffer(length + 1)) && this.isLiteral(this.buffer[this.pos + length])) {
            return 0;
        }
        this.pos += length;
        this.peeked = peeking;
        return this.peeked;
    }

    private int peekNumber() throws IOException {
        char[] buffer = this.buffer;
        int p15 = this.pos;
        int l15 = this.limit;
        long value = 0L;
        boolean negative = false;
        boolean fitsInLong = true;
        int last = 0;
        int i15 = 0;
        block6: while (true) {
            if (p15 + i15 == l15) {
                if (i15 == buffer.length) {
                    return 0;
                }
                if (!this.fillBuffer(i15 + 1)) break;
                p15 = this.pos;
                l15 = this.limit;
            }
            char c15 = buffer[p15 + i15];
            switch (c15) {
                case '-': {
                    if (last == 0) {
                        negative = true;
                        last = 1;
                        break;
                    }
                    if (last == 5) {
                        last = 6;
                        break;
                    }
                    return 0;
                }
                case '+': {
                    if (last == 5) {
                        last = 6;
                        break;
                    }
                    return 0;
                }
                case 'E': 
                case 'e': {
                    if (last == 2 || last == 4) {
                        last = 5;
                        break;
                    }
                    return 0;
                }
                case '.': {
                    if (last == 2) {
                        last = 3;
                        break;
                    }
                    return 0;
                }
                default: {
                    if (c15 < '0' || c15 > '9') {
                        if (!this.isLiteral(c15)) break block6;
                        return 0;
                    }
                    if (last == 1 || last == 0) {
                        value = -(c15 - 48);
                        last = 2;
                        break;
                    }
                    if (last == 2) {
                        if (value == 0L) {
                            return 0;
                        }
                        long newValue = value * 10L - (long)(c15 - 48);
                        fitsInLong &= value > -922337203685477580L || value == -922337203685477580L && newValue < value;
                        value = newValue;
                        break;
                    }
                    if (last == 3) {
                        last = 4;
                        break;
                    }
                    if (last != 5 && last != 6) break;
                    last = 7;
                }
            }
            ++i15;
        }
        if (!(last != 2 || !fitsInLong || value == Long.MIN_VALUE && !negative || value == 0L && negative)) {
            this.peekedLong = negative ? value : -value;
            this.pos += i15;
            this.peeked = 15;
            return this.peeked;
        }
        if (last == 2 || last == 4 || last == 7) {
            this.peekedNumberLength = i15;
            this.peeked = 16;
            return this.peeked;
        }
        return 0;
    }

    private boolean isLiteral(char c15) throws IOException {
        switch (c15) {
            case '#': 
            case '/': 
            case ';': 
            case '=': 
            case '\\': {
                this.checkLenient();
            }
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case ',': 
            case ':': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                return false;
            }
        }
        return true;
    }

    public String nextName() throws IOException {
        String result;
        int p15 = this.peeked;
        if (p15 == 0) {
            p15 = this.doPeek();
        }
        if (p15 == 14) {
            result = this.nextUnquotedValue();
        } else if (p15 == 12) {
            result = this.nextQuotedValue('\'');
        } else if (p15 == 13) {
            result = this.nextQuotedValue('\"');
        } else {
            throw this.unexpectedTokenError("a name");
        }
        this.peeked = 0;
        this.pathNames[this.stackSize - 1] = result;
        return result;
    }

    public String nextString() throws IOException {
        String result;
        int p15 = this.peeked;
        if (p15 == 0) {
            p15 = this.doPeek();
        }
        if (p15 == 10) {
            result = this.nextUnquotedValue();
        } else if (p15 == 8) {
            result = this.nextQuotedValue('\'');
        } else if (p15 == 9) {
            result = this.nextQuotedValue('\"');
        } else if (p15 == 11) {
            result = this.peekedString;
            this.peekedString = null;
        } else if (p15 == 15) {
            result = Long.toString(this.peekedLong);
        } else if (p15 == 16) {
            result = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else {
            throw this.unexpectedTokenError("a string");
        }
        this.peeked = 0;
        int n15 = this.stackSize - 1;
        this.pathIndices[n15] = this.pathIndices[n15] + 1;
        return result;
    }

    public boolean nextBoolean() throws IOException {
        int p15 = this.peeked;
        if (p15 == 0) {
            p15 = this.doPeek();
        }
        if (p15 == 5) {
            this.peeked = 0;
            int n15 = this.stackSize - 1;
            this.pathIndices[n15] = this.pathIndices[n15] + 1;
            return true;
        }
        if (p15 == 6) {
            this.peeked = 0;
            int n16 = this.stackSize - 1;
            this.pathIndices[n16] = this.pathIndices[n16] + 1;
            return false;
        }
        throw this.unexpectedTokenError("a boolean");
    }

    public void nextNull() throws IOException {
        int p15 = this.peeked;
        if (p15 == 0) {
            p15 = this.doPeek();
        }
        if (p15 != 7) {
            throw this.unexpectedTokenError("null");
        }
        this.peeked = 0;
        int n15 = this.stackSize - 1;
        this.pathIndices[n15] = this.pathIndices[n15] + 1;
    }

    public double nextDouble() throws IOException {
        int p15 = this.peeked;
        if (p15 == 0) {
            p15 = this.doPeek();
        }
        if (p15 == 15) {
            this.peeked = 0;
            int n15 = this.stackSize - 1;
            this.pathIndices[n15] = this.pathIndices[n15] + 1;
            return this.peekedLong;
        }
        if (p15 == 16) {
            this.peekedString = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else if (p15 == 8 || p15 == 9) {
            this.peekedString = this.nextQuotedValue(p15 == 8 ? (char)'\'' : '\"');
        } else if (p15 == 10) {
            this.peekedString = this.nextUnquotedValue();
        } else if (p15 != 11) {
            throw this.unexpectedTokenError("a double");
        }
        this.peeked = 11;
        double result = Double.parseDouble(this.peekedString);
        if (this.strictness != Strictness.LENIENT && (Double.isNaN(result) || Double.isInfinite(result))) {
            throw this.syntaxError("JSON forbids NaN and infinities: " + result);
        }
        this.peekedString = null;
        this.peeked = 0;
        int n16 = this.stackSize - 1;
        this.pathIndices[n16] = this.pathIndices[n16] + 1;
        return result;
    }

    public long nextLong() throws IOException {
        int p15 = this.peeked;
        if (p15 == 0) {
            p15 = this.doPeek();
        }
        if (p15 == 15) {
            this.peeked = 0;
            int n15 = this.stackSize - 1;
            this.pathIndices[n15] = this.pathIndices[n15] + 1;
            return this.peekedLong;
        }
        if (p15 == 16) {
            this.peekedString = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else if (p15 == 8 || p15 == 9 || p15 == 10) {
            this.peekedString = p15 == 10 ? this.nextUnquotedValue() : this.nextQuotedValue(p15 == 8 ? (char)'\'' : '\"');
            try {
                long result = Long.parseLong(this.peekedString);
                this.peeked = 0;
                int n16 = this.stackSize - 1;
                this.pathIndices[n16] = this.pathIndices[n16] + 1;
                return result;
            }
            catch (NumberFormatException result) {}
        } else {
            throw this.unexpectedTokenError("a long");
        }
        this.peeked = 11;
        double asDouble = Double.parseDouble(this.peekedString);
        long result = (long)asDouble;
        if ((double)result != asDouble) {
            throw new NumberFormatException("Expected a long but was " + this.peekedString + this.locationString());
        }
        this.peekedString = null;
        this.peeked = 0;
        int n17 = this.stackSize - 1;
        this.pathIndices[n17] = this.pathIndices[n17] + 1;
        return result;
    }

    private String nextQuotedValue(char quote) throws IOException {
        char[] buffer = this.buffer;
        StringBuilder builder = null;
        do {
            int p15 = this.pos;
            int l15 = this.limit;
            int start = p15;
            while (p15 < l15) {
                int len;
                char c15 = buffer[p15++];
                if (this.strictness == Strictness.STRICT && c15 < ' ') {
                    throw this.syntaxError("Unescaped control characters (\\u0000-\\u001F) are not allowed in strict mode");
                }
                if (c15 == quote) {
                    this.pos = p15;
                    len = p15 - start - 1;
                    if (builder == null) {
                        return new String(buffer, start, len);
                    }
                    builder.append(buffer, start, len);
                    return builder.toString();
                }
                if (c15 == '\\') {
                    this.pos = p15;
                    len = p15 - start - 1;
                    if (builder == null) {
                        int estimatedLength = (len + 1) * 2;
                        builder = new StringBuilder(Math.max(estimatedLength, 16));
                    }
                    builder.append(buffer, start, len);
                    builder.append(this.readEscapeCharacter());
                    p15 = this.pos;
                    l15 = this.limit;
                    start = p15;
                    continue;
                }
                if (c15 != '\n') continue;
                ++this.lineNumber;
                this.lineStart = p15;
            }
            if (builder == null) {
                int estimatedLength = (p15 - start) * 2;
                builder = new StringBuilder(Math.max(estimatedLength, 16));
            }
            builder.append(buffer, start, p15 - start);
            this.pos = p15;
        } while (this.fillBuffer(1));
        throw this.syntaxError("Unterminated string");
    }

    private String nextUnquotedValue() throws IOException {
        StringBuilder builder = null;
        int i15 = 0;
        block4: while (true) {
            if (this.pos + i15 < this.limit) {
                switch (this.buffer[this.pos + i15]) {
                    case '#': 
                    case '/': 
                    case ';': 
                    case '=': 
                    case '\\': {
                        this.checkLenient();
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case ',': 
                    case ':': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        break block4;
                    }
                    default: {
                        ++i15;
                        break;
                    }
                }
                continue;
            }
            if (i15 < this.buffer.length) {
                if (!this.fillBuffer(i15 + 1)) break;
                continue;
            }
            if (builder == null) {
                builder = new StringBuilder(Math.max(i15, 16));
            }
            builder.append(this.buffer, this.pos, i15);
            this.pos += i15;
            i15 = 0;
            if (!this.fillBuffer(1)) break;
        }
        String result = builder == null ? new String(this.buffer, this.pos, i15) : builder.append(this.buffer, this.pos, i15).toString();
        this.pos += i15;
        return result;
    }

    private void skipQuotedValue(char quote) throws IOException {
        char[] buffer = this.buffer;
        do {
            int p15 = this.pos;
            int l15 = this.limit;
            while (p15 < l15) {
                char c15;
                if ((c15 = buffer[p15++]) == quote) {
                    this.pos = p15;
                    return;
                }
                if (c15 == '\\') {
                    this.pos = p15;
                    char unused = this.readEscapeCharacter();
                    p15 = this.pos;
                    l15 = this.limit;
                    continue;
                }
                if (c15 != '\n') continue;
                ++this.lineNumber;
                this.lineStart = p15;
            }
            this.pos = p15;
        } while (this.fillBuffer(1));
        throw this.syntaxError("Unterminated string");
    }

    private void skipUnquotedValue() throws IOException {
        do {
            int i15 = 0;
            while (this.pos + i15 < this.limit) {
                switch (this.buffer[this.pos + i15]) {
                    case '#': 
                    case '/': 
                    case ';': 
                    case '=': 
                    case '\\': {
                        this.checkLenient();
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case ',': 
                    case ':': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        this.pos += i15;
                        return;
                    }
                }
                ++i15;
            }
            this.pos += i15;
        } while (this.fillBuffer(1));
    }

    public int nextInt() throws IOException {
        int p15 = this.peeked;
        if (p15 == 0) {
            p15 = this.doPeek();
        }
        if (p15 == 15) {
            int result = (int)this.peekedLong;
            if (this.peekedLong != (long)result) {
                throw new NumberFormatException("Expected an int but was " + this.peekedLong + this.locationString());
            }
            this.peeked = 0;
            int n15 = this.stackSize - 1;
            this.pathIndices[n15] = this.pathIndices[n15] + 1;
            return result;
        }
        if (p15 == 16) {
            this.peekedString = new String(this.buffer, this.pos, this.peekedNumberLength);
            this.pos += this.peekedNumberLength;
        } else if (p15 == 8 || p15 == 9 || p15 == 10) {
            this.peekedString = p15 == 10 ? this.nextUnquotedValue() : this.nextQuotedValue(p15 == 8 ? (char)'\'' : '\"');
            try {
                int result = Integer.parseInt(this.peekedString);
                this.peeked = 0;
                int n16 = this.stackSize - 1;
                this.pathIndices[n16] = this.pathIndices[n16] + 1;
                return result;
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            throw this.unexpectedTokenError("an int");
        }
        this.peeked = 11;
        double asDouble = Double.parseDouble(this.peekedString);
        int result = (int)asDouble;
        if ((double)result != asDouble) {
            throw new NumberFormatException("Expected an int but was " + this.peekedString + this.locationString());
        }
        this.peekedString = null;
        this.peeked = 0;
        int n17 = this.stackSize - 1;
        this.pathIndices[n17] = this.pathIndices[n17] + 1;
        return result;
    }

    @Override
    public void close() throws IOException {
        this.peeked = 0;
        this.stack[0] = 8;
        this.stackSize = 1;
        this.in.close();
    }

    public void skipValue() throws IOException {
        int count = 0;
        do {
            int p15;
            if ((p15 = this.peeked) == 0) {
                p15 = this.doPeek();
            }
            switch (p15) {
                case 3: {
                    this.push(1);
                    ++count;
                    break;
                }
                case 1: {
                    this.push(3);
                    ++count;
                    break;
                }
                case 4: {
                    --this.stackSize;
                    --count;
                    break;
                }
                case 2: {
                    if (count == 0) {
                        this.pathNames[this.stackSize - 1] = null;
                    }
                    --this.stackSize;
                    --count;
                    break;
                }
                case 10: {
                    this.skipUnquotedValue();
                    break;
                }
                case 8: {
                    this.skipQuotedValue('\'');
                    break;
                }
                case 9: {
                    this.skipQuotedValue('\"');
                    break;
                }
                case 14: {
                    this.skipUnquotedValue();
                    if (count != 0) break;
                    this.pathNames[this.stackSize - 1] = "<skipped>";
                    break;
                }
                case 12: {
                    this.skipQuotedValue('\'');
                    if (count != 0) break;
                    this.pathNames[this.stackSize - 1] = "<skipped>";
                    break;
                }
                case 13: {
                    this.skipQuotedValue('\"');
                    if (count != 0) break;
                    this.pathNames[this.stackSize - 1] = "<skipped>";
                    break;
                }
                case 16: {
                    this.pos += this.peekedNumberLength;
                    break;
                }
                case 17: {
                    return;
                }
            }
            this.peeked = 0;
        } while (count > 0);
        int n15 = this.stackSize - 1;
        this.pathIndices[n15] = this.pathIndices[n15] + 1;
    }

    private void push(int newTop) throws MalformedJsonException {
        if (this.stackSize - 1 >= this.nestingLimit) {
            throw new MalformedJsonException("Nesting limit " + this.nestingLimit + " reached" + this.locationString());
        }
        if (this.stackSize == this.stack.length) {
            int newLength = this.stackSize * 2;
            this.stack = Arrays.copyOf(this.stack, newLength);
            this.pathIndices = Arrays.copyOf(this.pathIndices, newLength);
            this.pathNames = Arrays.copyOf(this.pathNames, newLength);
        }
        this.stack[this.stackSize++] = newTop;
    }

    private boolean fillBuffer(int minimum) throws IOException {
        int total;
        char[] buffer = this.buffer;
        this.lineStart -= this.pos;
        if (this.limit != this.pos) {
            this.limit -= this.pos;
            System.arraycopy(buffer, this.pos, buffer, 0, this.limit);
        } else {
            this.limit = 0;
        }
        this.pos = 0;
        while ((total = this.in.read(buffer, this.limit, buffer.length - this.limit)) != -1) {
            this.limit += total;
            if (this.lineNumber == 0 && this.lineStart == 0 && this.limit > 0 && buffer[0] == '\ufeff') {
                ++this.pos;
                ++this.lineStart;
                ++minimum;
            }
            if (this.limit < minimum) continue;
            return true;
        }
        return false;
    }

    private int nextNonWhitespace(boolean throwOnEof) throws IOException {
        block12: {
            char c15;
            char[] buffer = this.buffer;
            int p15 = this.pos;
            int l15 = this.limit;
            block4: while (true) {
                if (p15 == l15) {
                    this.pos = p15;
                    if (!this.fillBuffer(1)) break block12;
                    p15 = this.pos;
                    l15 = this.limit;
                }
                if ((c15 = buffer[p15++]) == '\n') {
                    ++this.lineNumber;
                    this.lineStart = p15;
                    continue;
                }
                if (c15 == ' ' || c15 == '\r' || c15 == '\t') continue;
                if (c15 == '/') {
                    this.pos = p15;
                    if (p15 == l15) {
                        --this.pos;
                        boolean charsLoaded = this.fillBuffer(2);
                        ++this.pos;
                        if (!charsLoaded) {
                            return c15;
                        }
                    }
                    this.checkLenient();
                    char peek = buffer[this.pos];
                    switch (peek) {
                        case '*': {
                            ++this.pos;
                            if (!this.skipTo("*/")) {
                                throw this.syntaxError("Unterminated comment");
                            }
                            p15 = this.pos + 2;
                            l15 = this.limit;
                            continue block4;
                        }
                        case '/': {
                            ++this.pos;
                            this.skipToEndOfLine();
                            p15 = this.pos;
                            l15 = this.limit;
                            continue block4;
                        }
                    }
                    return c15;
                }
                if (c15 != '#') break;
                this.pos = p15;
                this.checkLenient();
                this.skipToEndOfLine();
                p15 = this.pos;
                l15 = this.limit;
            }
            this.pos = p15;
            return c15;
        }
        if (throwOnEof) {
            throw new EOFException("End of input" + this.locationString());
        }
        return -1;
    }

    private void checkLenient() throws MalformedJsonException {
        if (this.strictness != Strictness.LENIENT) {
            throw this.syntaxError("Use JsonReader.setStrictness(Strictness.LENIENT) to accept malformed JSON");
        }
    }

    private void skipToEndOfLine() throws IOException {
        while (this.pos < this.limit || this.fillBuffer(1)) {
            char c15;
            if ((c15 = this.buffer[this.pos++]) == '\n') {
                ++this.lineNumber;
                this.lineStart = this.pos;
                break;
            }
            if (c15 != '\r') continue;
            break;
        }
    }

    private boolean skipTo(String toFind) throws IOException {
        int length = toFind.length();
        while (this.pos + length <= this.limit || this.fillBuffer(length)) {
            block5: {
                if (this.buffer[this.pos] == '\n') {
                    ++this.lineNumber;
                    this.lineStart = this.pos + 1;
                } else {
                    for (int c15 = 0; c15 < length; ++c15) {
                        if (this.buffer[this.pos + c15] == toFind.charAt(c15)) {
                            continue;
                        }
                        break block5;
                    }
                    return true;
                }
            }
            ++this.pos;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.locationString();
    }

    String locationString() {
        int line = this.lineNumber + 1;
        int column = this.pos - this.lineStart + 1;
        return " at line " + line + " column " + column + " path " + this.getPath();
    }

    private String getPath(boolean usePreviousPath) {
        StringBuilder result = new StringBuilder().append('$');
        block5: for (int i15 = 0; i15 < this.stackSize; ++i15) {
            int scope = this.stack[i15];
            switch (scope) {
                case 1: 
                case 2: {
                    int pathIndex = this.pathIndices[i15];
                    if (usePreviousPath && pathIndex > 0 && i15 == this.stackSize - 1) {
                        --pathIndex;
                    }
                    result.append('[').append(pathIndex).append(']');
                    continue block5;
                }
                case 3: 
                case 4: 
                case 5: {
                    result.append('.');
                    if (this.pathNames[i15] == null) continue block5;
                    result.append(this.pathNames[i15]);
                    continue block5;
                }
                case 6: 
                case 7: 
                case 8: {
                    continue block5;
                }
                default: {
                    throw new AssertionError((Object)("Unknown scope value: " + scope));
                }
            }
        }
        return result.toString();
    }

    public String getPath() {
        return this.getPath(false);
    }

    public String getPreviousPath() {
        return this.getPath(true);
    }

    private char readEscapeCharacter() throws IOException {
        if (this.pos == this.limit && !this.fillBuffer(1)) {
            throw this.syntaxError("Unterminated escape sequence");
        }
        char escaped = this.buffer[this.pos++];
        switch (escaped) {
            case 'u': {
                int i15;
                if (this.pos + 4 > this.limit && !this.fillBuffer(4)) {
                    throw this.syntaxError("Unterminated escape sequence");
                }
                int result = 0;
                int end = i15 + 4;
                for (i15 = this.pos; i15 < end; ++i15) {
                    char c15 = this.buffer[i15];
                    result <<= 4;
                    if (c15 >= '0' && c15 <= '9') {
                        result += c15 - 48;
                        continue;
                    }
                    if (c15 >= 'a' && c15 <= 'f') {
                        result += c15 - 97 + 10;
                        continue;
                    }
                    if (c15 >= 'A' && c15 <= 'F') {
                        result += c15 - 65 + 10;
                        continue;
                    }
                    throw this.syntaxError("Malformed Unicode escape \\u" + new String(this.buffer, this.pos, 4));
                }
                this.pos += 4;
                return (char)result;
            }
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
            case '\n': {
                if (this.strictness == Strictness.STRICT) {
                    throw this.syntaxError("Cannot escape a newline character in strict mode");
                }
                ++this.lineNumber;
                this.lineStart = this.pos;
            }
            case '\'': {
                if (this.strictness == Strictness.STRICT) {
                    throw this.syntaxError("Invalid escaped character \"'\" in strict mode");
                }
            }
            case '\"': 
            case '/': 
            case '\\': {
                return escaped;
            }
        }
        throw this.syntaxError("Invalid escape sequence");
    }

    private MalformedJsonException syntaxError(String message2) throws MalformedJsonException {
        throw new MalformedJsonException(message2 + this.locationString() + "\nSee " + TroubleshootingGuide.createUrl("malformed-json"));
    }

    private IllegalStateException unexpectedTokenError(String expected) throws IOException {
        JsonToken peeked = this.peek();
        String troubleshootingId = peeked == JsonToken.NULL ? "adapter-not-null-safe" : "unexpected-json-structure";
        return new IllegalStateException("Expected " + expected + " but was " + (Object)((Object)this.peek()) + this.locationString() + "\nSee " + TroubleshootingGuide.createUrl(troubleshootingId));
    }

    private void consumeNonExecutePrefix() throws IOException {
        int unused = this.nextNonWhitespace(true);
        --this.pos;
        if (this.pos + 5 > this.limit && !this.fillBuffer(5)) {
            return;
        }
        char[] buf = this.buffer;
        int p15 = this.pos;
        if (buf[p15] != ')' || buf[p15 + 1] != ']' || buf[p15 + 2] != '}' || buf[p15 + 3] != '\'' || buf[p15 + 4] != '\n') {
            return;
        }
        this.pos += 5;
    }

    static {
        JsonReaderInternalAccess.INSTANCE = new JsonReaderInternalAccess(){

            @Override
            public void promoteNameToValue(JsonReader reader) throws IOException {
                if (reader instanceof JsonTreeReader) {
                    ((JsonTreeReader)reader).promoteNameToValue();
                    return;
                }
                int p15 = reader.peeked;
                if (p15 == 0) {
                    p15 = reader.doPeek();
                }
                if (p15 == 13) {
                    reader.peeked = 9;
                } else if (p15 == 12) {
                    reader.peeked = 8;
                } else if (p15 == 14) {
                    reader.peeked = 10;
                } else {
                    throw reader.unexpectedTokenError("a name");
                }
            }
        };
    }
}

